/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.vtk.handlers;

import java.util.HashMap;
import java.util.Map;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.g3d.vtk.common.VtkView;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;

public class CameraPositionHandler
extends AbstractHandler {
    private Map<VtkView, Vector3d> cameraPos = new HashMap<VtkView, Vector3d>();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart ap = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        final VtkView panel = (VtkView)ap.getAdapter(VtkView.class);
        String param = event.getParameter("org.simantics.g3d.viewDirection");
        String[] vals = param.split(",");
        final Vector3d direction = new Vector3d(Double.parseDouble(vals[0]), Double.parseDouble(vals[1]), Double.parseDouble(vals[2]));
        ThreadUtils.asyncExec((IThreadWorkQueue)panel.getThreadQueue(), (Runnable)new Runnable(){

            @Override
            public void run() {
                Vector3d focal = new Vector3d(panel.getRenderer().GetActiveCamera().GetFocalPoint());
                Vector3d pos = new Vector3d(panel.getRenderer().GetActiveCamera().GetPosition());
                CameraPositionHandler.this.cameraPos.put(panel, pos);
                Vector3d dir = new Vector3d(pos);
                dir.sub((Tuple3d)focal);
                double distance = dir.length();
                dir.set((Tuple3d)direction);
                dir.scale(distance);
                dir.add((Tuple3d)focal);
                panel.getRenderer().GetActiveCamera().SetPosition(dir.x, dir.y, dir.z);
                Vector3d vector3d = new Vector3d(0.0, 1.0, 0.0);
                if (Math.abs(direction.dot(vector3d)) < 0.95) {
                    panel.getRenderer().GetActiveCamera().SetViewUp(0.0, 1.0, 0.0);
                } else {
                    panel.getRenderer().GetActiveCamera().SetViewUp(1.0, 0.0, 0.0);
                }
                panel.getRenderer().ResetCameraClippingRange();
                panel.refresh();
            }
        });
        return null;
    }
}

