/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.csg.scenegraph2;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Quat4d;
import javax.vecmath.Vector3d;
import org.jcae.opencascade.jni.TopoDS_Shape;
import org.simantics.g3d.csg.scenegraph2.ICSGnode;
import org.simantics.g3d.math.MathTools;
import org.simantics.g3d.property.annotations.GetPropertyValue;
import org.simantics.g3d.property.annotations.PropertyContributor;
import org.simantics.g3d.property.annotations.SetPropertyValue;
import org.simantics.g3d.scenegraph.IG3DNode;
import org.simantics.g3d.scenegraph.base.INode;
import org.simantics.g3d.scenegraph.base.ParentNode;
import org.simantics.g3d.tools.NodeTools;
import org.simantics.g3d.vtk.common.VtkView;
import org.simantics.objmap.graph.annotations.RelatedElementsAdd;
import org.simantics.objmap.graph.annotations.RelatedElementsGet;
import org.simantics.objmap.graph.annotations.RelatedElementsRem;
import org.simantics.objmap.graph.annotations.RelatedGetValue;
import org.simantics.objmap.graph.annotations.RelatedSetValue;
import org.simantics.opencascade.OccTriangulator;
import org.simantics.opencascade.vtk.vtkSolidObject;
import org.simantics.utils.threads.AWTThread;
import vtk.vtkProp3D;

@PropertyContributor
public abstract class CSGparentNode
extends ParentNode<ICSGnode>
implements ICSGnode {
    private String name;
    private Vector3d position = new Vector3d();
    private Quat4d orientation = MathTools.getIdentityQuat();
    private vtkSolidObject solidObject;

    @Override
    @RelatedGetValue(value="http://www.simantics.org/Layer0-1.1/HasName")
    @GetPropertyValue(value="http://www.simantics.org/Layer0-1.1/HasName", tabId="Default", name="Name")
    public String getName() {
        return this.name;
    }

    @Override
    @RelatedSetValue(value="http://www.simantics.org/Layer0-1.1/HasName")
    @SetPropertyValue(value="http://www.simantics.org/Layer0-1.1/HasName")
    public void setName(String name) {
        if (name == null) {
            return;
        }
        this.name = name;
        this.firePropertyChanged("http://www.simantics.org/Layer0-1.1/HasName");
    }

    public String toString() {
        return this.getName();
    }

    @GetPropertyValue(value="http://www.simantics.org/G3D-0.1/hasOrientation", tabId="Transform", name="Orientation")
    public Quat4d getOrientation() {
        return this.orientation;
    }

    @RelatedGetValue(value="http://www.simantics.org/G3D-0.1/hasOrientation")
    public double[] getOrientationArr() {
        double[] arr = new double[4];
        this.orientation.get(arr);
        return arr;
    }

    @GetPropertyValue(value="http://www.simantics.org/G3D-0.1/hasPosition", tabId="Transform", name="Position")
    public Vector3d getPosition() {
        return this.position;
    }

    @RelatedGetValue(value="http://www.simantics.org/G3D-0.1/hasPosition")
    public double[] getPositionArr() {
        double[] arr = new double[3];
        this.position.get(arr);
        return arr;
    }

    @RelatedElementsAdd(value="http://www.simantics.org/CSG-0.1/hasPrimaryShape")
    public void addPrimaryChild(ICSGnode node) {
        this.addNode("primary", (INode)node);
    }

    @RelatedElementsGet(value="http://www.simantics.org/CSG-0.1/hasPrimaryShape")
    public Collection<ICSGnode> getPrimaryChild() {
        return this.getNodes("primary");
    }

    @RelatedElementsRem(value="http://www.simantics.org/CSG-0.1/hasPrimaryShape")
    public void remPrimaryChild(ICSGnode node) {
        this.removeNode("primary", (INode)node);
    }

    @RelatedElementsAdd(value="http://www.simantics.org/CSG-0.1/hasSecondaryShape")
    public void addSecondaryChild(ICSGnode node) {
        this.addNode("secondary", (INode)node);
    }

    @RelatedElementsGet(value="http://www.simantics.org/CSG-0.1/hasSecondaryShape")
    public Collection<ICSGnode> getSecondaryChild() {
        return this.getNodes("secondary");
    }

    @RelatedElementsRem(value="http://www.simantics.org/CSG-0.1/hasSecondaryShape")
    public void remSecondaryChild(ICSGnode node) {
        this.removeNode("secondary", (INode)node);
    }

    @RelatedElementsAdd(value="http://www.simantics.org/CSG-0.1/hasChildShape")
    public void addChild(ICSGnode node) {
        this.addNode("child", (INode)node);
    }

    @RelatedElementsGet(value="http://www.simantics.org/CSG-0.1/hasChildShape")
    public Collection<ICSGnode> getChild() {
        return this.getNodes("child");
    }

    @RelatedElementsRem(value="http://www.simantics.org/CSG-0.1/hasChildShape")
    public void remChild(ICSGnode node) {
        this.removeNode("child", (INode)node);
    }

    protected TopoDS_Shape getPrimary() {
        Iterator iterator = this.getNodes("primary").iterator();
        if (iterator.hasNext()) {
            ICSGnode node = (ICSGnode)iterator.next();
            return node.getGeometry();
        }
        return null;
    }

    protected TopoDS_Shape getSecondary() {
        Iterator iterator = this.getNodes("secondary").iterator();
        if (iterator.hasNext()) {
            ICSGnode node = (ICSGnode)iterator.next();
            return node.getGeometry();
        }
        return null;
    }

    @Override
    public TopoDS_Shape getGeometry() {
        TopoDS_Shape shape = this.getBaseGeometry();
        if (shape == null) {
            return null;
        }
        Quat4d q = this.getOrientation();
        AxisAngle4d r = new AxisAngle4d();
        r.set(q);
        TopoDS_Shape tshape = OccTriangulator.makeRotation((TopoDS_Shape)shape, (double[])new double[]{0.0, 0.0, 0.0, r.x, r.y, r.z}, (double)r.angle);
        shape.delete();
        shape = tshape;
        Vector3d p = this.getPosition();
        tshape = OccTriangulator.makeTranslation((TopoDS_Shape)shape, (double)p.x, (double)p.y, (double)p.z);
        shape.delete();
        return tshape;
    }

    @SetPropertyValue(value="http://www.simantics.org/G3D-0.1/hasOrientation")
    public void setOrientation(Quat4d orientation) {
        assert (orientation != null);
        this.orientation = orientation;
        this.firePropertyChanged("http://www.simantics.org/G3D-0.1/hasOrientation");
    }

    @SetPropertyValue(value="http://www.simantics.org/G3D-0.1/hasPosition")
    public void setPosition(Vector3d position) {
        assert (position != null);
        this.position = position;
        this.firePropertyChanged("http://www.simantics.org/G3D-0.1/hasPosition");
    }

    @RelatedSetValue(value="http://www.simantics.org/G3D-0.1/hasOrientation")
    public void setOrientation(double[] arr) {
        if (arr == null) {
            return;
        }
        this.setOrientation(new Quat4d(arr));
    }

    @RelatedSetValue(value="http://www.simantics.org/G3D-0.1/hasPosition")
    public void setPosition(double[] arr) {
        if (arr == null) {
            return;
        }
        this.setPosition(new Vector3d(arr));
    }

    @GetPropertyValue(value="http://www.simantics.org/G3D-0.1/hasWorldPosition", tabId="Transform", name="World Position")
    public Vector3d getWorldPosition() {
        IG3DNode parent = (IG3DNode)this.getParent();
        if (parent == null) {
            return this.position;
        }
        return NodeTools.getWorldPosition((IG3DNode)parent, (Vector3d)new Vector3d(this.position));
    }

    public Vector3d getWorldPosition(Vector3d localPosition) {
        return NodeTools.getWorldPosition((IG3DNode)this, (Vector3d)localPosition);
    }

    @GetPropertyValue(value="http://www.simantics.org/G3D-0.1/hasWorldOrientation", tabId="Transform", name="World Orientation")
    public Quat4d getWorldOrientation() {
        return this.getWorldOrientation(new Quat4d(this.orientation));
    }

    public Quat4d getWorldOrientation(Quat4d localOrientation) {
        IG3DNode parent = (IG3DNode)this.getParent();
        if (parent == null) {
            return localOrientation;
        }
        return NodeTools.getWorldOrientation((IG3DNode)parent, (Quat4d)localOrientation);
    }

    public Vector3d getLocalPosition(Vector3d worldPosition) {
        IG3DNode parent = (IG3DNode)this.getParent();
        if (parent == null) {
            return worldPosition;
        }
        return NodeTools.getLocalPosition((IG3DNode)parent, (Vector3d)new Vector3d(worldPosition));
    }

    public Quat4d getLocalOrientation(Quat4d worldOrientation) {
        IG3DNode parent = (IG3DNode)this.getParent();
        if (parent == null) {
            return worldOrientation;
        }
        return NodeTools.getLocalOrientation((IG3DNode)parent, (Quat4d)new Quat4d(worldOrientation));
    }

    @SetPropertyValue(value="http://www.simantics.org/G3D-0.1/hasWorldPosition")
    public void setWorldPosition(Vector3d position) {
        Vector3d localPos = this.getLocalPosition(position);
        this.setPosition(localPos);
    }

    @SetPropertyValue(value="http://www.simantics.org/G3D-0.1/hasWorldOrientation")
    public void setWorldOrientation(Quat4d orientation) {
        Quat4d localOr = this.getLocalOrientation(orientation);
        this.setOrientation(localOr);
    }

    @Override
    public void visualize(VtkView panel) {
        TopoDS_Shape shape;
        if (this.solidObject != null) {
            this.solidObject.delete();
            this.solidObject = null;
        }
        if ((shape = this.getGeometry()) == null) {
            return;
        }
        this.solidObject = new vtkSolidObject(panel, shape);
        this.solidObject.visualizeSolid(true, false);
    }

    @Override
    public Collection<vtkProp3D> getActors() {
        if (this.solidObject == null) {
            return Collections.EMPTY_LIST;
        }
        return this.solidObject.getActors();
    }

    @Override
    public void stopVisualize() {
        if (this.solidObject != null) {
            if (Thread.currentThread() == AWTThread.getThreadAccess().getThread()) {
                this.solidObject.delete();
            } else {
                this.solidObject.dispose();
            }
            this.solidObject = null;
        }
    }

    public void cleanup() {
        this.stopVisualize();
        super.cleanup();
    }

    public void remove() {
        super.remove();
    }

    public <C> C getAdapter(Class<C> adapter) {
        return null;
    }
}

