/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.csg.scenegraph2;

import java.util.Collection;
import java.util.Collections;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Quat4d;
import javax.vecmath.Vector3d;
import org.jcae.opencascade.jni.TopoDS_Shape;
import org.simantics.g3d.csg.scenegraph2.ICSGnode;
import org.simantics.g3d.property.annotations.GetPropertyValue;
import org.simantics.g3d.property.annotations.SetPropertyValue;
import org.simantics.g3d.scenegraph.G3DNode;
import org.simantics.g3d.vtk.common.VtkView;
import org.simantics.objmap.graph.annotations.RelatedGetValue;
import org.simantics.objmap.graph.annotations.RelatedSetValue;
import org.simantics.opencascade.OccTriangulator;
import org.simantics.opencascade.vtk.vtkSolidObject;
import org.simantics.utils.threads.AWTThread;
import vtk.vtkProp3D;

public abstract class CSGnode
extends G3DNode
implements ICSGnode {
    public static final double MIN_VALUE = 0.001;
    private String name;
    private vtkSolidObject solidObject;

    @Override
    @RelatedGetValue(value="http://www.simantics.org/Layer0-1.1/HasName")
    @GetPropertyValue(value="http://www.simantics.org/Layer0-1.1/HasName", tabId="Default", name="Name")
    public String getName() {
        return this.name;
    }

    @Override
    @RelatedSetValue(value="http://www.simantics.org/Layer0-1.1/HasName")
    @SetPropertyValue(value="http://www.simantics.org/Layer0-1.1/HasName")
    public void setName(String name) {
        if (name == null) {
            return;
        }
        this.name = name;
        this.firePropertyChanged("http://www.simantics.org/Layer0-1.1/HasName");
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public TopoDS_Shape getGeometry() {
        TopoDS_Shape shape = this.getBaseGeometry();
        if (shape == null) {
            return null;
        }
        Quat4d q = this.getOrientation();
        AxisAngle4d r = new AxisAngle4d();
        r.set(q);
        TopoDS_Shape tshape = OccTriangulator.makeRotation((TopoDS_Shape)shape, (double[])new double[]{0.0, 0.0, 0.0, r.x, r.y, r.z}, (double)r.angle);
        shape.delete();
        shape = tshape;
        Vector3d p = this.getPosition();
        tshape = OccTriangulator.makeTranslation((TopoDS_Shape)shape, (double)p.x, (double)p.y, (double)p.z);
        shape.delete();
        return tshape;
    }

    @Override
    public void visualize(VtkView panel) {
        TopoDS_Shape shape;
        if (this.solidObject != null) {
            this.solidObject.delete();
            this.solidObject = null;
        }
        if ((shape = this.getGeometry()) == null) {
            return;
        }
        this.solidObject = new vtkSolidObject(panel, shape);
        this.solidObject.visualizeSolid(true, false);
    }

    @Override
    public Collection<vtkProp3D> getActors() {
        if (this.solidObject == null) {
            return Collections.EMPTY_LIST;
        }
        return this.solidObject.getActors();
    }

    @Override
    public void stopVisualize() {
        if (this.solidObject != null) {
            if (Thread.currentThread() == AWTThread.getThreadAccess().getThread()) {
                this.solidObject.delete();
            } else {
                this.solidObject.dispose();
            }
            this.solidObject = null;
        }
    }

    public void cleanup() {
        this.stopVisualize();
        super.cleanup();
    }
}

