/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl;

import com.koloboke.collect.impl.Containers;
import com.koloboke.collect.impl.InternalDoubleShortMapOps;
import com.koloboke.collect.map.DoubleShortMap;
import com.koloboke.function.DoubleShortConsumer;
import com.koloboke.function.DoubleShortPredicate;
import java.util.Map;

public final class CommonDoubleShortMapOps {
    public static boolean containsAllEntries(final InternalDoubleShortMapOps map, Map<?, ?> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        if (another instanceof DoubleShortMap) {
            DoubleShortMap m2 = (DoubleShortMap)another;
            if (map.size() < m2.size()) {
                return false;
            }
            if (m2 instanceof InternalDoubleShortMapOps) {
                return ((InternalDoubleShortMapOps)m2).allEntriesContainingIn(map);
            }
            return m2.forEachWhile(new DoubleShortPredicate(){

                public boolean test(double a, short b) {
                    return map.containsEntry(a, b);
                }
            });
        }
        for (Map.Entry<?, ?> e : another.entrySet()) {
            if (map.containsEntry((Double)e.getKey(), (short)((Short)e.getValue()))) continue;
            return false;
        }
        return true;
    }

    public static void putAll(final InternalDoubleShortMapOps map, Map<? extends Double, ? extends Short> another) {
        if (map == another) {
            throw new IllegalArgumentException();
        }
        long maxPossibleSize = map.sizeAsLong() + Containers.sizeAsLong(another);
        map.ensureCapacity(maxPossibleSize);
        if (another instanceof DoubleShortMap) {
            if (another instanceof InternalDoubleShortMapOps) {
                ((InternalDoubleShortMapOps)another).reversePutAllTo(map);
            } else {
                ((DoubleShortMap)another).forEach(new DoubleShortConsumer(){

                    public void accept(double key, short value) {
                        map.justPut(key, value);
                    }
                });
            }
        } else {
            for (Map.Entry<? extends Double, ? extends Short> e : another.entrySet()) {
                map.justPut(e.getKey(), (short)e.getValue());
            }
        }
    }

    private CommonDoubleShortMapOps() {
    }
}

