/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.koloboke.collect.map.hash;

import com.koloboke.collect.*;
import com.koloboke.collect.hash.*;
import com.koloboke.compile.CustomKeyEquivalence;
import com.koloboke.compile.KolobokeMap;
import java.util.function.Consumer;
import com.koloboke.collect.map.*;

import javax.annotation.Nonnull;

import java.util.Map;



/**
 * An immutable factory of {@code HashLongDoubleMap}s.
 *
 * @see HashLongDoubleMap
 * @see HashLongDoubleMaps#getDefaultFactory()
 * @see KolobokeMap @KolobokeMap
 */
public interface HashLongDoubleMapFactory
        extends LongDoubleMapFactory<HashLongDoubleMapFactory>
        , LongHashFactory<HashLongDoubleMapFactory>
        {


    

    

    

    

    

    
    

    
    


    @Override
    @Nonnull
     HashLongDoubleMap newMutableMap();

    @Override
    @Nonnull
     HashLongDoubleMap newMutableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashLongDoubleMap newMutableMap(@Nonnull Map<Long, Double> map1,
            @Nonnull Map<Long, Double> map2, int expectedSize);

    @Override
    @Nonnull
     HashLongDoubleMap newMutableMap(@Nonnull Map<Long, Double> map1,
            @Nonnull Map<Long, Double> map2,
            @Nonnull Map<Long, Double> map3, int expectedSize);

    @Override
    @Nonnull
     HashLongDoubleMap newMutableMap(@Nonnull Map<Long, Double> map1,
            @Nonnull Map<Long, Double> map2,
            @Nonnull Map<Long, Double> map3,
            @Nonnull Map<Long, Double> map4, int expectedSize);

    @Override
    @Nonnull
     HashLongDoubleMap newMutableMap(@Nonnull Map<Long, Double> map1,
            @Nonnull Map<Long, Double> map2,
            @Nonnull Map<Long, Double> map3,
            @Nonnull Map<Long, Double> map4,
            @Nonnull Map<Long, Double> map5, int expectedSize);



    @Override
    @Nonnull
     HashLongDoubleMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.LongDoubleConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashLongDoubleMap newMutableMap(
            @Nonnull long[] keys, @Nonnull double[] values, int expectedSize);

    @Override
    @Nonnull
     HashLongDoubleMap newMutableMap(
            @Nonnull Long[] keys, @Nonnull Double[] values, int expectedSize);

    @Override
    @Nonnull
     HashLongDoubleMap newMutableMap(@Nonnull Iterable<Long> keys,
            @Nonnull Iterable<Double> values, int expectedSize);

    

    @Override
    @Nonnull
     HashLongDoubleMap newMutableMap(
            @Nonnull Map<Long, Double> map);

    @Override
    @Nonnull
     HashLongDoubleMap newMutableMap(@Nonnull Map<Long, Double> map1,
            @Nonnull Map<Long, Double> map2);

    @Override
    @Nonnull
     HashLongDoubleMap newMutableMap(@Nonnull Map<Long, Double> map1,
            @Nonnull Map<Long, Double> map2,
            @Nonnull Map<Long, Double> map3);

    @Override
    @Nonnull
     HashLongDoubleMap newMutableMap(@Nonnull Map<Long, Double> map1,
            @Nonnull Map<Long, Double> map2,
            @Nonnull Map<Long, Double> map3,
            @Nonnull Map<Long, Double> map4);

    @Override
    @Nonnull
     HashLongDoubleMap newMutableMap(@Nonnull Map<Long, Double> map1,
            @Nonnull Map<Long, Double> map2,
            @Nonnull Map<Long, Double> map3,
            @Nonnull Map<Long, Double> map4,
            @Nonnull Map<Long, Double> map5);



    @Override
    @Nonnull
     HashLongDoubleMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.LongDoubleConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashLongDoubleMap newMutableMap(
            @Nonnull long[] keys, @Nonnull double[] values);

    @Override
    @Nonnull
     HashLongDoubleMap newMutableMap(
            @Nonnull Long[] keys, @Nonnull Double[] values);

    @Override
    @Nonnull
     HashLongDoubleMap newMutableMap(@Nonnull Iterable<Long> keys,
            @Nonnull Iterable<Double> values);


    @Override
    @Nonnull
     HashLongDoubleMap newMutableMapOf(long k1, double v1);

    @Override
    @Nonnull
     HashLongDoubleMap newMutableMapOf(long k1, double v1,
            long k2, double v2);

    @Override
    @Nonnull
     HashLongDoubleMap newMutableMapOf(long k1, double v1,
            long k2, double v2, long k3, double v3);

    @Override
    @Nonnull
     HashLongDoubleMap newMutableMapOf(long k1, double v1,
            long k2, double v2, long k3, double v3,
            long k4, double v4);

    @Override
    @Nonnull
     HashLongDoubleMap newMutableMapOf(long k1, double v1,
            long k2, double v2, long k3, double v3,
            long k4, double v4, long k5, double v5);
    @Override
    @Nonnull
     HashLongDoubleMap newUpdatableMap();

    @Override
    @Nonnull
     HashLongDoubleMap newUpdatableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashLongDoubleMap newUpdatableMap(@Nonnull Map<Long, Double> map1,
            @Nonnull Map<Long, Double> map2, int expectedSize);

    @Override
    @Nonnull
     HashLongDoubleMap newUpdatableMap(@Nonnull Map<Long, Double> map1,
            @Nonnull Map<Long, Double> map2,
            @Nonnull Map<Long, Double> map3, int expectedSize);

    @Override
    @Nonnull
     HashLongDoubleMap newUpdatableMap(@Nonnull Map<Long, Double> map1,
            @Nonnull Map<Long, Double> map2,
            @Nonnull Map<Long, Double> map3,
            @Nonnull Map<Long, Double> map4, int expectedSize);

    @Override
    @Nonnull
     HashLongDoubleMap newUpdatableMap(@Nonnull Map<Long, Double> map1,
            @Nonnull Map<Long, Double> map2,
            @Nonnull Map<Long, Double> map3,
            @Nonnull Map<Long, Double> map4,
            @Nonnull Map<Long, Double> map5, int expectedSize);



    @Override
    @Nonnull
     HashLongDoubleMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.LongDoubleConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashLongDoubleMap newUpdatableMap(
            @Nonnull long[] keys, @Nonnull double[] values, int expectedSize);

    @Override
    @Nonnull
     HashLongDoubleMap newUpdatableMap(
            @Nonnull Long[] keys, @Nonnull Double[] values, int expectedSize);

    @Override
    @Nonnull
     HashLongDoubleMap newUpdatableMap(@Nonnull Iterable<Long> keys,
            @Nonnull Iterable<Double> values, int expectedSize);

    

    @Override
    @Nonnull
     HashLongDoubleMap newUpdatableMap(
            @Nonnull Map<Long, Double> map);

    @Override
    @Nonnull
     HashLongDoubleMap newUpdatableMap(@Nonnull Map<Long, Double> map1,
            @Nonnull Map<Long, Double> map2);

    @Override
    @Nonnull
     HashLongDoubleMap newUpdatableMap(@Nonnull Map<Long, Double> map1,
            @Nonnull Map<Long, Double> map2,
            @Nonnull Map<Long, Double> map3);

    @Override
    @Nonnull
     HashLongDoubleMap newUpdatableMap(@Nonnull Map<Long, Double> map1,
            @Nonnull Map<Long, Double> map2,
            @Nonnull Map<Long, Double> map3,
            @Nonnull Map<Long, Double> map4);

    @Override
    @Nonnull
     HashLongDoubleMap newUpdatableMap(@Nonnull Map<Long, Double> map1,
            @Nonnull Map<Long, Double> map2,
            @Nonnull Map<Long, Double> map3,
            @Nonnull Map<Long, Double> map4,
            @Nonnull Map<Long, Double> map5);



    @Override
    @Nonnull
     HashLongDoubleMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.LongDoubleConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashLongDoubleMap newUpdatableMap(
            @Nonnull long[] keys, @Nonnull double[] values);

    @Override
    @Nonnull
     HashLongDoubleMap newUpdatableMap(
            @Nonnull Long[] keys, @Nonnull Double[] values);

    @Override
    @Nonnull
     HashLongDoubleMap newUpdatableMap(@Nonnull Iterable<Long> keys,
            @Nonnull Iterable<Double> values);


    @Override
    @Nonnull
     HashLongDoubleMap newUpdatableMapOf(long k1, double v1);

    @Override
    @Nonnull
     HashLongDoubleMap newUpdatableMapOf(long k1, double v1,
            long k2, double v2);

    @Override
    @Nonnull
     HashLongDoubleMap newUpdatableMapOf(long k1, double v1,
            long k2, double v2, long k3, double v3);

    @Override
    @Nonnull
     HashLongDoubleMap newUpdatableMapOf(long k1, double v1,
            long k2, double v2, long k3, double v3,
            long k4, double v4);

    @Override
    @Nonnull
     HashLongDoubleMap newUpdatableMapOf(long k1, double v1,
            long k2, double v2, long k3, double v3,
            long k4, double v4, long k5, double v5);

    


    @Override
    @Nonnull
     HashLongDoubleMap newImmutableMap(@Nonnull Map<Long, Double> map1,
            @Nonnull Map<Long, Double> map2, int expectedSize);

    @Override
    @Nonnull
     HashLongDoubleMap newImmutableMap(@Nonnull Map<Long, Double> map1,
            @Nonnull Map<Long, Double> map2,
            @Nonnull Map<Long, Double> map3, int expectedSize);

    @Override
    @Nonnull
     HashLongDoubleMap newImmutableMap(@Nonnull Map<Long, Double> map1,
            @Nonnull Map<Long, Double> map2,
            @Nonnull Map<Long, Double> map3,
            @Nonnull Map<Long, Double> map4, int expectedSize);

    @Override
    @Nonnull
     HashLongDoubleMap newImmutableMap(@Nonnull Map<Long, Double> map1,
            @Nonnull Map<Long, Double> map2,
            @Nonnull Map<Long, Double> map3,
            @Nonnull Map<Long, Double> map4,
            @Nonnull Map<Long, Double> map5, int expectedSize);



    @Override
    @Nonnull
     HashLongDoubleMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.LongDoubleConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashLongDoubleMap newImmutableMap(
            @Nonnull long[] keys, @Nonnull double[] values, int expectedSize);

    @Override
    @Nonnull
     HashLongDoubleMap newImmutableMap(
            @Nonnull Long[] keys, @Nonnull Double[] values, int expectedSize);

    @Override
    @Nonnull
     HashLongDoubleMap newImmutableMap(@Nonnull Iterable<Long> keys,
            @Nonnull Iterable<Double> values, int expectedSize);

    

    @Override
    @Nonnull
     HashLongDoubleMap newImmutableMap(
            @Nonnull Map<Long, Double> map);

    @Override
    @Nonnull
     HashLongDoubleMap newImmutableMap(@Nonnull Map<Long, Double> map1,
            @Nonnull Map<Long, Double> map2);

    @Override
    @Nonnull
     HashLongDoubleMap newImmutableMap(@Nonnull Map<Long, Double> map1,
            @Nonnull Map<Long, Double> map2,
            @Nonnull Map<Long, Double> map3);

    @Override
    @Nonnull
     HashLongDoubleMap newImmutableMap(@Nonnull Map<Long, Double> map1,
            @Nonnull Map<Long, Double> map2,
            @Nonnull Map<Long, Double> map3,
            @Nonnull Map<Long, Double> map4);

    @Override
    @Nonnull
     HashLongDoubleMap newImmutableMap(@Nonnull Map<Long, Double> map1,
            @Nonnull Map<Long, Double> map2,
            @Nonnull Map<Long, Double> map3,
            @Nonnull Map<Long, Double> map4,
            @Nonnull Map<Long, Double> map5);



    @Override
    @Nonnull
     HashLongDoubleMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.LongDoubleConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashLongDoubleMap newImmutableMap(
            @Nonnull long[] keys, @Nonnull double[] values);

    @Override
    @Nonnull
     HashLongDoubleMap newImmutableMap(
            @Nonnull Long[] keys, @Nonnull Double[] values);

    @Override
    @Nonnull
     HashLongDoubleMap newImmutableMap(@Nonnull Iterable<Long> keys,
            @Nonnull Iterable<Double> values);


    @Override
    @Nonnull
     HashLongDoubleMap newImmutableMapOf(long k1, double v1);

    @Override
    @Nonnull
     HashLongDoubleMap newImmutableMapOf(long k1, double v1,
            long k2, double v2);

    @Override
    @Nonnull
     HashLongDoubleMap newImmutableMapOf(long k1, double v1,
            long k2, double v2, long k3, double v3);

    @Override
    @Nonnull
     HashLongDoubleMap newImmutableMapOf(long k1, double v1,
            long k2, double v2, long k3, double v3,
            long k4, double v4);

    @Override
    @Nonnull
     HashLongDoubleMap newImmutableMapOf(long k1, double v1,
            long k2, double v2, long k3, double v3,
            long k4, double v4, long k5, double v5);
}
