/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.koloboke.collect.map.hash;

import com.koloboke.collect.*;
import com.koloboke.collect.hash.*;
import com.koloboke.compile.CustomKeyEquivalence;
import com.koloboke.compile.KolobokeMap;
import java.util.function.Consumer;
import com.koloboke.collect.map.*;

import javax.annotation.Nonnull;

import java.util.Map;



/**
 * An immutable factory of {@code HashLongCharMap}s.
 *
 * @see HashLongCharMap
 * @see HashLongCharMaps#getDefaultFactory()
 * @see KolobokeMap @KolobokeMap
 */
public interface HashLongCharMapFactory
        extends LongCharMapFactory<HashLongCharMapFactory>
        , LongHashFactory<HashLongCharMapFactory>
        {


    

    

    

    

    

    
    

    
    


    @Override
    @Nonnull
     HashLongCharMap newMutableMap();

    @Override
    @Nonnull
     HashLongCharMap newMutableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashLongCharMap newMutableMap(@Nonnull Map<Long, Character> map1,
            @Nonnull Map<Long, Character> map2, int expectedSize);

    @Override
    @Nonnull
     HashLongCharMap newMutableMap(@Nonnull Map<Long, Character> map1,
            @Nonnull Map<Long, Character> map2,
            @Nonnull Map<Long, Character> map3, int expectedSize);

    @Override
    @Nonnull
     HashLongCharMap newMutableMap(@Nonnull Map<Long, Character> map1,
            @Nonnull Map<Long, Character> map2,
            @Nonnull Map<Long, Character> map3,
            @Nonnull Map<Long, Character> map4, int expectedSize);

    @Override
    @Nonnull
     HashLongCharMap newMutableMap(@Nonnull Map<Long, Character> map1,
            @Nonnull Map<Long, Character> map2,
            @Nonnull Map<Long, Character> map3,
            @Nonnull Map<Long, Character> map4,
            @Nonnull Map<Long, Character> map5, int expectedSize);



    @Override
    @Nonnull
     HashLongCharMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.LongCharConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashLongCharMap newMutableMap(
            @Nonnull long[] keys, @Nonnull char[] values, int expectedSize);

    @Override
    @Nonnull
     HashLongCharMap newMutableMap(
            @Nonnull Long[] keys, @Nonnull Character[] values, int expectedSize);

    @Override
    @Nonnull
     HashLongCharMap newMutableMap(@Nonnull Iterable<Long> keys,
            @Nonnull Iterable<Character> values, int expectedSize);

    

    @Override
    @Nonnull
     HashLongCharMap newMutableMap(
            @Nonnull Map<Long, Character> map);

    @Override
    @Nonnull
     HashLongCharMap newMutableMap(@Nonnull Map<Long, Character> map1,
            @Nonnull Map<Long, Character> map2);

    @Override
    @Nonnull
     HashLongCharMap newMutableMap(@Nonnull Map<Long, Character> map1,
            @Nonnull Map<Long, Character> map2,
            @Nonnull Map<Long, Character> map3);

    @Override
    @Nonnull
     HashLongCharMap newMutableMap(@Nonnull Map<Long, Character> map1,
            @Nonnull Map<Long, Character> map2,
            @Nonnull Map<Long, Character> map3,
            @Nonnull Map<Long, Character> map4);

    @Override
    @Nonnull
     HashLongCharMap newMutableMap(@Nonnull Map<Long, Character> map1,
            @Nonnull Map<Long, Character> map2,
            @Nonnull Map<Long, Character> map3,
            @Nonnull Map<Long, Character> map4,
            @Nonnull Map<Long, Character> map5);



    @Override
    @Nonnull
     HashLongCharMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.LongCharConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashLongCharMap newMutableMap(
            @Nonnull long[] keys, @Nonnull char[] values);

    @Override
    @Nonnull
     HashLongCharMap newMutableMap(
            @Nonnull Long[] keys, @Nonnull Character[] values);

    @Override
    @Nonnull
     HashLongCharMap newMutableMap(@Nonnull Iterable<Long> keys,
            @Nonnull Iterable<Character> values);


    @Override
    @Nonnull
     HashLongCharMap newMutableMapOf(long k1, char v1);

    @Override
    @Nonnull
     HashLongCharMap newMutableMapOf(long k1, char v1,
            long k2, char v2);

    @Override
    @Nonnull
     HashLongCharMap newMutableMapOf(long k1, char v1,
            long k2, char v2, long k3, char v3);

    @Override
    @Nonnull
     HashLongCharMap newMutableMapOf(long k1, char v1,
            long k2, char v2, long k3, char v3,
            long k4, char v4);

    @Override
    @Nonnull
     HashLongCharMap newMutableMapOf(long k1, char v1,
            long k2, char v2, long k3, char v3,
            long k4, char v4, long k5, char v5);
    @Override
    @Nonnull
     HashLongCharMap newUpdatableMap();

    @Override
    @Nonnull
     HashLongCharMap newUpdatableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashLongCharMap newUpdatableMap(@Nonnull Map<Long, Character> map1,
            @Nonnull Map<Long, Character> map2, int expectedSize);

    @Override
    @Nonnull
     HashLongCharMap newUpdatableMap(@Nonnull Map<Long, Character> map1,
            @Nonnull Map<Long, Character> map2,
            @Nonnull Map<Long, Character> map3, int expectedSize);

    @Override
    @Nonnull
     HashLongCharMap newUpdatableMap(@Nonnull Map<Long, Character> map1,
            @Nonnull Map<Long, Character> map2,
            @Nonnull Map<Long, Character> map3,
            @Nonnull Map<Long, Character> map4, int expectedSize);

    @Override
    @Nonnull
     HashLongCharMap newUpdatableMap(@Nonnull Map<Long, Character> map1,
            @Nonnull Map<Long, Character> map2,
            @Nonnull Map<Long, Character> map3,
            @Nonnull Map<Long, Character> map4,
            @Nonnull Map<Long, Character> map5, int expectedSize);



    @Override
    @Nonnull
     HashLongCharMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.LongCharConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashLongCharMap newUpdatableMap(
            @Nonnull long[] keys, @Nonnull char[] values, int expectedSize);

    @Override
    @Nonnull
     HashLongCharMap newUpdatableMap(
            @Nonnull Long[] keys, @Nonnull Character[] values, int expectedSize);

    @Override
    @Nonnull
     HashLongCharMap newUpdatableMap(@Nonnull Iterable<Long> keys,
            @Nonnull Iterable<Character> values, int expectedSize);

    

    @Override
    @Nonnull
     HashLongCharMap newUpdatableMap(
            @Nonnull Map<Long, Character> map);

    @Override
    @Nonnull
     HashLongCharMap newUpdatableMap(@Nonnull Map<Long, Character> map1,
            @Nonnull Map<Long, Character> map2);

    @Override
    @Nonnull
     HashLongCharMap newUpdatableMap(@Nonnull Map<Long, Character> map1,
            @Nonnull Map<Long, Character> map2,
            @Nonnull Map<Long, Character> map3);

    @Override
    @Nonnull
     HashLongCharMap newUpdatableMap(@Nonnull Map<Long, Character> map1,
            @Nonnull Map<Long, Character> map2,
            @Nonnull Map<Long, Character> map3,
            @Nonnull Map<Long, Character> map4);

    @Override
    @Nonnull
     HashLongCharMap newUpdatableMap(@Nonnull Map<Long, Character> map1,
            @Nonnull Map<Long, Character> map2,
            @Nonnull Map<Long, Character> map3,
            @Nonnull Map<Long, Character> map4,
            @Nonnull Map<Long, Character> map5);



    @Override
    @Nonnull
     HashLongCharMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.LongCharConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashLongCharMap newUpdatableMap(
            @Nonnull long[] keys, @Nonnull char[] values);

    @Override
    @Nonnull
     HashLongCharMap newUpdatableMap(
            @Nonnull Long[] keys, @Nonnull Character[] values);

    @Override
    @Nonnull
     HashLongCharMap newUpdatableMap(@Nonnull Iterable<Long> keys,
            @Nonnull Iterable<Character> values);


    @Override
    @Nonnull
     HashLongCharMap newUpdatableMapOf(long k1, char v1);

    @Override
    @Nonnull
     HashLongCharMap newUpdatableMapOf(long k1, char v1,
            long k2, char v2);

    @Override
    @Nonnull
     HashLongCharMap newUpdatableMapOf(long k1, char v1,
            long k2, char v2, long k3, char v3);

    @Override
    @Nonnull
     HashLongCharMap newUpdatableMapOf(long k1, char v1,
            long k2, char v2, long k3, char v3,
            long k4, char v4);

    @Override
    @Nonnull
     HashLongCharMap newUpdatableMapOf(long k1, char v1,
            long k2, char v2, long k3, char v3,
            long k4, char v4, long k5, char v5);

    


    @Override
    @Nonnull
     HashLongCharMap newImmutableMap(@Nonnull Map<Long, Character> map1,
            @Nonnull Map<Long, Character> map2, int expectedSize);

    @Override
    @Nonnull
     HashLongCharMap newImmutableMap(@Nonnull Map<Long, Character> map1,
            @Nonnull Map<Long, Character> map2,
            @Nonnull Map<Long, Character> map3, int expectedSize);

    @Override
    @Nonnull
     HashLongCharMap newImmutableMap(@Nonnull Map<Long, Character> map1,
            @Nonnull Map<Long, Character> map2,
            @Nonnull Map<Long, Character> map3,
            @Nonnull Map<Long, Character> map4, int expectedSize);

    @Override
    @Nonnull
     HashLongCharMap newImmutableMap(@Nonnull Map<Long, Character> map1,
            @Nonnull Map<Long, Character> map2,
            @Nonnull Map<Long, Character> map3,
            @Nonnull Map<Long, Character> map4,
            @Nonnull Map<Long, Character> map5, int expectedSize);



    @Override
    @Nonnull
     HashLongCharMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.LongCharConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashLongCharMap newImmutableMap(
            @Nonnull long[] keys, @Nonnull char[] values, int expectedSize);

    @Override
    @Nonnull
     HashLongCharMap newImmutableMap(
            @Nonnull Long[] keys, @Nonnull Character[] values, int expectedSize);

    @Override
    @Nonnull
     HashLongCharMap newImmutableMap(@Nonnull Iterable<Long> keys,
            @Nonnull Iterable<Character> values, int expectedSize);

    

    @Override
    @Nonnull
     HashLongCharMap newImmutableMap(
            @Nonnull Map<Long, Character> map);

    @Override
    @Nonnull
     HashLongCharMap newImmutableMap(@Nonnull Map<Long, Character> map1,
            @Nonnull Map<Long, Character> map2);

    @Override
    @Nonnull
     HashLongCharMap newImmutableMap(@Nonnull Map<Long, Character> map1,
            @Nonnull Map<Long, Character> map2,
            @Nonnull Map<Long, Character> map3);

    @Override
    @Nonnull
     HashLongCharMap newImmutableMap(@Nonnull Map<Long, Character> map1,
            @Nonnull Map<Long, Character> map2,
            @Nonnull Map<Long, Character> map3,
            @Nonnull Map<Long, Character> map4);

    @Override
    @Nonnull
     HashLongCharMap newImmutableMap(@Nonnull Map<Long, Character> map1,
            @Nonnull Map<Long, Character> map2,
            @Nonnull Map<Long, Character> map3,
            @Nonnull Map<Long, Character> map4,
            @Nonnull Map<Long, Character> map5);



    @Override
    @Nonnull
     HashLongCharMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.LongCharConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashLongCharMap newImmutableMap(
            @Nonnull long[] keys, @Nonnull char[] values);

    @Override
    @Nonnull
     HashLongCharMap newImmutableMap(
            @Nonnull Long[] keys, @Nonnull Character[] values);

    @Override
    @Nonnull
     HashLongCharMap newImmutableMap(@Nonnull Iterable<Long> keys,
            @Nonnull Iterable<Character> values);


    @Override
    @Nonnull
     HashLongCharMap newImmutableMapOf(long k1, char v1);

    @Override
    @Nonnull
     HashLongCharMap newImmutableMapOf(long k1, char v1,
            long k2, char v2);

    @Override
    @Nonnull
     HashLongCharMap newImmutableMapOf(long k1, char v1,
            long k2, char v2, long k3, char v3);

    @Override
    @Nonnull
     HashLongCharMap newImmutableMapOf(long k1, char v1,
            long k2, char v2, long k3, char v3,
            long k4, char v4);

    @Override
    @Nonnull
     HashLongCharMap newImmutableMapOf(long k1, char v1,
            long k2, char v2, long k3, char v3,
            long k4, char v4, long k5, char v5);
}
