/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.koloboke.collect.map.hash;

import com.koloboke.collect.*;
import com.koloboke.collect.hash.*;
import com.koloboke.compile.CustomKeyEquivalence;
import com.koloboke.compile.KolobokeMap;
import java.util.function.Consumer;
import com.koloboke.collect.map.*;

import javax.annotation.Nonnull;

import java.util.Map;



/**
 * An immutable factory of {@code HashDoubleCharMap}s.
 *
 * @see HashDoubleCharMap
 * @see HashDoubleCharMaps#getDefaultFactory()
 * @see KolobokeMap @KolobokeMap
 */
public interface HashDoubleCharMapFactory
        extends DoubleCharMapFactory<HashDoubleCharMapFactory>
        , HashContainerFactory<HashDoubleCharMapFactory>{


    

    

    

    

    

    
    

    
    


    @Override
    @Nonnull
     HashDoubleCharMap newMutableMap();

    @Override
    @Nonnull
     HashDoubleCharMap newMutableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashDoubleCharMap newMutableMap(@Nonnull Map<Double, Character> map1,
            @Nonnull Map<Double, Character> map2, int expectedSize);

    @Override
    @Nonnull
     HashDoubleCharMap newMutableMap(@Nonnull Map<Double, Character> map1,
            @Nonnull Map<Double, Character> map2,
            @Nonnull Map<Double, Character> map3, int expectedSize);

    @Override
    @Nonnull
     HashDoubleCharMap newMutableMap(@Nonnull Map<Double, Character> map1,
            @Nonnull Map<Double, Character> map2,
            @Nonnull Map<Double, Character> map3,
            @Nonnull Map<Double, Character> map4, int expectedSize);

    @Override
    @Nonnull
     HashDoubleCharMap newMutableMap(@Nonnull Map<Double, Character> map1,
            @Nonnull Map<Double, Character> map2,
            @Nonnull Map<Double, Character> map3,
            @Nonnull Map<Double, Character> map4,
            @Nonnull Map<Double, Character> map5, int expectedSize);



    @Override
    @Nonnull
     HashDoubleCharMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.DoubleCharConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashDoubleCharMap newMutableMap(
            @Nonnull double[] keys, @Nonnull char[] values, int expectedSize);

    @Override
    @Nonnull
     HashDoubleCharMap newMutableMap(
            @Nonnull Double[] keys, @Nonnull Character[] values, int expectedSize);

    @Override
    @Nonnull
     HashDoubleCharMap newMutableMap(@Nonnull Iterable<Double> keys,
            @Nonnull Iterable<Character> values, int expectedSize);

    

    @Override
    @Nonnull
     HashDoubleCharMap newMutableMap(
            @Nonnull Map<Double, Character> map);

    @Override
    @Nonnull
     HashDoubleCharMap newMutableMap(@Nonnull Map<Double, Character> map1,
            @Nonnull Map<Double, Character> map2);

    @Override
    @Nonnull
     HashDoubleCharMap newMutableMap(@Nonnull Map<Double, Character> map1,
            @Nonnull Map<Double, Character> map2,
            @Nonnull Map<Double, Character> map3);

    @Override
    @Nonnull
     HashDoubleCharMap newMutableMap(@Nonnull Map<Double, Character> map1,
            @Nonnull Map<Double, Character> map2,
            @Nonnull Map<Double, Character> map3,
            @Nonnull Map<Double, Character> map4);

    @Override
    @Nonnull
     HashDoubleCharMap newMutableMap(@Nonnull Map<Double, Character> map1,
            @Nonnull Map<Double, Character> map2,
            @Nonnull Map<Double, Character> map3,
            @Nonnull Map<Double, Character> map4,
            @Nonnull Map<Double, Character> map5);



    @Override
    @Nonnull
     HashDoubleCharMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.DoubleCharConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashDoubleCharMap newMutableMap(
            @Nonnull double[] keys, @Nonnull char[] values);

    @Override
    @Nonnull
     HashDoubleCharMap newMutableMap(
            @Nonnull Double[] keys, @Nonnull Character[] values);

    @Override
    @Nonnull
     HashDoubleCharMap newMutableMap(@Nonnull Iterable<Double> keys,
            @Nonnull Iterable<Character> values);


    @Override
    @Nonnull
     HashDoubleCharMap newMutableMapOf(double k1, char v1);

    @Override
    @Nonnull
     HashDoubleCharMap newMutableMapOf(double k1, char v1,
            double k2, char v2);

    @Override
    @Nonnull
     HashDoubleCharMap newMutableMapOf(double k1, char v1,
            double k2, char v2, double k3, char v3);

    @Override
    @Nonnull
     HashDoubleCharMap newMutableMapOf(double k1, char v1,
            double k2, char v2, double k3, char v3,
            double k4, char v4);

    @Override
    @Nonnull
     HashDoubleCharMap newMutableMapOf(double k1, char v1,
            double k2, char v2, double k3, char v3,
            double k4, char v4, double k5, char v5);
    @Override
    @Nonnull
     HashDoubleCharMap newUpdatableMap();

    @Override
    @Nonnull
     HashDoubleCharMap newUpdatableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashDoubleCharMap newUpdatableMap(@Nonnull Map<Double, Character> map1,
            @Nonnull Map<Double, Character> map2, int expectedSize);

    @Override
    @Nonnull
     HashDoubleCharMap newUpdatableMap(@Nonnull Map<Double, Character> map1,
            @Nonnull Map<Double, Character> map2,
            @Nonnull Map<Double, Character> map3, int expectedSize);

    @Override
    @Nonnull
     HashDoubleCharMap newUpdatableMap(@Nonnull Map<Double, Character> map1,
            @Nonnull Map<Double, Character> map2,
            @Nonnull Map<Double, Character> map3,
            @Nonnull Map<Double, Character> map4, int expectedSize);

    @Override
    @Nonnull
     HashDoubleCharMap newUpdatableMap(@Nonnull Map<Double, Character> map1,
            @Nonnull Map<Double, Character> map2,
            @Nonnull Map<Double, Character> map3,
            @Nonnull Map<Double, Character> map4,
            @Nonnull Map<Double, Character> map5, int expectedSize);



    @Override
    @Nonnull
     HashDoubleCharMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.DoubleCharConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashDoubleCharMap newUpdatableMap(
            @Nonnull double[] keys, @Nonnull char[] values, int expectedSize);

    @Override
    @Nonnull
     HashDoubleCharMap newUpdatableMap(
            @Nonnull Double[] keys, @Nonnull Character[] values, int expectedSize);

    @Override
    @Nonnull
     HashDoubleCharMap newUpdatableMap(@Nonnull Iterable<Double> keys,
            @Nonnull Iterable<Character> values, int expectedSize);

    

    @Override
    @Nonnull
     HashDoubleCharMap newUpdatableMap(
            @Nonnull Map<Double, Character> map);

    @Override
    @Nonnull
     HashDoubleCharMap newUpdatableMap(@Nonnull Map<Double, Character> map1,
            @Nonnull Map<Double, Character> map2);

    @Override
    @Nonnull
     HashDoubleCharMap newUpdatableMap(@Nonnull Map<Double, Character> map1,
            @Nonnull Map<Double, Character> map2,
            @Nonnull Map<Double, Character> map3);

    @Override
    @Nonnull
     HashDoubleCharMap newUpdatableMap(@Nonnull Map<Double, Character> map1,
            @Nonnull Map<Double, Character> map2,
            @Nonnull Map<Double, Character> map3,
            @Nonnull Map<Double, Character> map4);

    @Override
    @Nonnull
     HashDoubleCharMap newUpdatableMap(@Nonnull Map<Double, Character> map1,
            @Nonnull Map<Double, Character> map2,
            @Nonnull Map<Double, Character> map3,
            @Nonnull Map<Double, Character> map4,
            @Nonnull Map<Double, Character> map5);



    @Override
    @Nonnull
     HashDoubleCharMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.DoubleCharConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashDoubleCharMap newUpdatableMap(
            @Nonnull double[] keys, @Nonnull char[] values);

    @Override
    @Nonnull
     HashDoubleCharMap newUpdatableMap(
            @Nonnull Double[] keys, @Nonnull Character[] values);

    @Override
    @Nonnull
     HashDoubleCharMap newUpdatableMap(@Nonnull Iterable<Double> keys,
            @Nonnull Iterable<Character> values);


    @Override
    @Nonnull
     HashDoubleCharMap newUpdatableMapOf(double k1, char v1);

    @Override
    @Nonnull
     HashDoubleCharMap newUpdatableMapOf(double k1, char v1,
            double k2, char v2);

    @Override
    @Nonnull
     HashDoubleCharMap newUpdatableMapOf(double k1, char v1,
            double k2, char v2, double k3, char v3);

    @Override
    @Nonnull
     HashDoubleCharMap newUpdatableMapOf(double k1, char v1,
            double k2, char v2, double k3, char v3,
            double k4, char v4);

    @Override
    @Nonnull
     HashDoubleCharMap newUpdatableMapOf(double k1, char v1,
            double k2, char v2, double k3, char v3,
            double k4, char v4, double k5, char v5);

    


    @Override
    @Nonnull
     HashDoubleCharMap newImmutableMap(@Nonnull Map<Double, Character> map1,
            @Nonnull Map<Double, Character> map2, int expectedSize);

    @Override
    @Nonnull
     HashDoubleCharMap newImmutableMap(@Nonnull Map<Double, Character> map1,
            @Nonnull Map<Double, Character> map2,
            @Nonnull Map<Double, Character> map3, int expectedSize);

    @Override
    @Nonnull
     HashDoubleCharMap newImmutableMap(@Nonnull Map<Double, Character> map1,
            @Nonnull Map<Double, Character> map2,
            @Nonnull Map<Double, Character> map3,
            @Nonnull Map<Double, Character> map4, int expectedSize);

    @Override
    @Nonnull
     HashDoubleCharMap newImmutableMap(@Nonnull Map<Double, Character> map1,
            @Nonnull Map<Double, Character> map2,
            @Nonnull Map<Double, Character> map3,
            @Nonnull Map<Double, Character> map4,
            @Nonnull Map<Double, Character> map5, int expectedSize);



    @Override
    @Nonnull
     HashDoubleCharMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.DoubleCharConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashDoubleCharMap newImmutableMap(
            @Nonnull double[] keys, @Nonnull char[] values, int expectedSize);

    @Override
    @Nonnull
     HashDoubleCharMap newImmutableMap(
            @Nonnull Double[] keys, @Nonnull Character[] values, int expectedSize);

    @Override
    @Nonnull
     HashDoubleCharMap newImmutableMap(@Nonnull Iterable<Double> keys,
            @Nonnull Iterable<Character> values, int expectedSize);

    

    @Override
    @Nonnull
     HashDoubleCharMap newImmutableMap(
            @Nonnull Map<Double, Character> map);

    @Override
    @Nonnull
     HashDoubleCharMap newImmutableMap(@Nonnull Map<Double, Character> map1,
            @Nonnull Map<Double, Character> map2);

    @Override
    @Nonnull
     HashDoubleCharMap newImmutableMap(@Nonnull Map<Double, Character> map1,
            @Nonnull Map<Double, Character> map2,
            @Nonnull Map<Double, Character> map3);

    @Override
    @Nonnull
     HashDoubleCharMap newImmutableMap(@Nonnull Map<Double, Character> map1,
            @Nonnull Map<Double, Character> map2,
            @Nonnull Map<Double, Character> map3,
            @Nonnull Map<Double, Character> map4);

    @Override
    @Nonnull
     HashDoubleCharMap newImmutableMap(@Nonnull Map<Double, Character> map1,
            @Nonnull Map<Double, Character> map2,
            @Nonnull Map<Double, Character> map3,
            @Nonnull Map<Double, Character> map4,
            @Nonnull Map<Double, Character> map5);



    @Override
    @Nonnull
     HashDoubleCharMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.DoubleCharConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashDoubleCharMap newImmutableMap(
            @Nonnull double[] keys, @Nonnull char[] values);

    @Override
    @Nonnull
     HashDoubleCharMap newImmutableMap(
            @Nonnull Double[] keys, @Nonnull Character[] values);

    @Override
    @Nonnull
     HashDoubleCharMap newImmutableMap(@Nonnull Iterable<Double> keys,
            @Nonnull Iterable<Character> values);


    @Override
    @Nonnull
     HashDoubleCharMap newImmutableMapOf(double k1, char v1);

    @Override
    @Nonnull
     HashDoubleCharMap newImmutableMapOf(double k1, char v1,
            double k2, char v2);

    @Override
    @Nonnull
     HashDoubleCharMap newImmutableMapOf(double k1, char v1,
            double k2, char v2, double k3, char v3);

    @Override
    @Nonnull
     HashDoubleCharMap newImmutableMapOf(double k1, char v1,
            double k2, char v2, double k3, char v3,
            double k4, char v4);

    @Override
    @Nonnull
     HashDoubleCharMap newImmutableMapOf(double k1, char v1,
            double k2, char v2, double k3, char v3,
            double k4, char v4, double k5, char v5);
}
