/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.koloboke.collect.map.hash;

import com.koloboke.collect.*;
import com.koloboke.collect.hash.*;
import com.koloboke.compile.CustomKeyEquivalence;
import com.koloboke.compile.KolobokeMap;
import java.util.function.Consumer;
import com.koloboke.collect.map.*;

import javax.annotation.Nonnull;

import java.util.Map;



/**
 * An immutable factory of {@code HashCharIntMap}s.
 *
 * @see HashCharIntMap
 * @see HashCharIntMaps#getDefaultFactory()
 * @see KolobokeMap @KolobokeMap
 */
public interface HashCharIntMapFactory
        extends CharIntMapFactory<HashCharIntMapFactory>
        , CharHashFactory<HashCharIntMapFactory>
        {


    

    

    

    

    

    
    

    
    


    @Override
    @Nonnull
     HashCharIntMap newMutableMap();

    @Override
    @Nonnull
     HashCharIntMap newMutableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashCharIntMap newMutableMap(@Nonnull Map<Character, Integer> map1,
            @Nonnull Map<Character, Integer> map2, int expectedSize);

    @Override
    @Nonnull
     HashCharIntMap newMutableMap(@Nonnull Map<Character, Integer> map1,
            @Nonnull Map<Character, Integer> map2,
            @Nonnull Map<Character, Integer> map3, int expectedSize);

    @Override
    @Nonnull
     HashCharIntMap newMutableMap(@Nonnull Map<Character, Integer> map1,
            @Nonnull Map<Character, Integer> map2,
            @Nonnull Map<Character, Integer> map3,
            @Nonnull Map<Character, Integer> map4, int expectedSize);

    @Override
    @Nonnull
     HashCharIntMap newMutableMap(@Nonnull Map<Character, Integer> map1,
            @Nonnull Map<Character, Integer> map2,
            @Nonnull Map<Character, Integer> map3,
            @Nonnull Map<Character, Integer> map4,
            @Nonnull Map<Character, Integer> map5, int expectedSize);



    @Override
    @Nonnull
     HashCharIntMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.CharIntConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashCharIntMap newMutableMap(
            @Nonnull char[] keys, @Nonnull int[] values, int expectedSize);

    @Override
    @Nonnull
     HashCharIntMap newMutableMap(
            @Nonnull Character[] keys, @Nonnull Integer[] values, int expectedSize);

    @Override
    @Nonnull
     HashCharIntMap newMutableMap(@Nonnull Iterable<Character> keys,
            @Nonnull Iterable<Integer> values, int expectedSize);

    

    @Override
    @Nonnull
     HashCharIntMap newMutableMap(
            @Nonnull Map<Character, Integer> map);

    @Override
    @Nonnull
     HashCharIntMap newMutableMap(@Nonnull Map<Character, Integer> map1,
            @Nonnull Map<Character, Integer> map2);

    @Override
    @Nonnull
     HashCharIntMap newMutableMap(@Nonnull Map<Character, Integer> map1,
            @Nonnull Map<Character, Integer> map2,
            @Nonnull Map<Character, Integer> map3);

    @Override
    @Nonnull
     HashCharIntMap newMutableMap(@Nonnull Map<Character, Integer> map1,
            @Nonnull Map<Character, Integer> map2,
            @Nonnull Map<Character, Integer> map3,
            @Nonnull Map<Character, Integer> map4);

    @Override
    @Nonnull
     HashCharIntMap newMutableMap(@Nonnull Map<Character, Integer> map1,
            @Nonnull Map<Character, Integer> map2,
            @Nonnull Map<Character, Integer> map3,
            @Nonnull Map<Character, Integer> map4,
            @Nonnull Map<Character, Integer> map5);



    @Override
    @Nonnull
     HashCharIntMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.CharIntConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashCharIntMap newMutableMap(
            @Nonnull char[] keys, @Nonnull int[] values);

    @Override
    @Nonnull
     HashCharIntMap newMutableMap(
            @Nonnull Character[] keys, @Nonnull Integer[] values);

    @Override
    @Nonnull
     HashCharIntMap newMutableMap(@Nonnull Iterable<Character> keys,
            @Nonnull Iterable<Integer> values);


    @Override
    @Nonnull
     HashCharIntMap newMutableMapOf(char k1, int v1);

    @Override
    @Nonnull
     HashCharIntMap newMutableMapOf(char k1, int v1,
            char k2, int v2);

    @Override
    @Nonnull
     HashCharIntMap newMutableMapOf(char k1, int v1,
            char k2, int v2, char k3, int v3);

    @Override
    @Nonnull
     HashCharIntMap newMutableMapOf(char k1, int v1,
            char k2, int v2, char k3, int v3,
            char k4, int v4);

    @Override
    @Nonnull
     HashCharIntMap newMutableMapOf(char k1, int v1,
            char k2, int v2, char k3, int v3,
            char k4, int v4, char k5, int v5);
    @Override
    @Nonnull
     HashCharIntMap newUpdatableMap();

    @Override
    @Nonnull
     HashCharIntMap newUpdatableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashCharIntMap newUpdatableMap(@Nonnull Map<Character, Integer> map1,
            @Nonnull Map<Character, Integer> map2, int expectedSize);

    @Override
    @Nonnull
     HashCharIntMap newUpdatableMap(@Nonnull Map<Character, Integer> map1,
            @Nonnull Map<Character, Integer> map2,
            @Nonnull Map<Character, Integer> map3, int expectedSize);

    @Override
    @Nonnull
     HashCharIntMap newUpdatableMap(@Nonnull Map<Character, Integer> map1,
            @Nonnull Map<Character, Integer> map2,
            @Nonnull Map<Character, Integer> map3,
            @Nonnull Map<Character, Integer> map4, int expectedSize);

    @Override
    @Nonnull
     HashCharIntMap newUpdatableMap(@Nonnull Map<Character, Integer> map1,
            @Nonnull Map<Character, Integer> map2,
            @Nonnull Map<Character, Integer> map3,
            @Nonnull Map<Character, Integer> map4,
            @Nonnull Map<Character, Integer> map5, int expectedSize);



    @Override
    @Nonnull
     HashCharIntMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.CharIntConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashCharIntMap newUpdatableMap(
            @Nonnull char[] keys, @Nonnull int[] values, int expectedSize);

    @Override
    @Nonnull
     HashCharIntMap newUpdatableMap(
            @Nonnull Character[] keys, @Nonnull Integer[] values, int expectedSize);

    @Override
    @Nonnull
     HashCharIntMap newUpdatableMap(@Nonnull Iterable<Character> keys,
            @Nonnull Iterable<Integer> values, int expectedSize);

    

    @Override
    @Nonnull
     HashCharIntMap newUpdatableMap(
            @Nonnull Map<Character, Integer> map);

    @Override
    @Nonnull
     HashCharIntMap newUpdatableMap(@Nonnull Map<Character, Integer> map1,
            @Nonnull Map<Character, Integer> map2);

    @Override
    @Nonnull
     HashCharIntMap newUpdatableMap(@Nonnull Map<Character, Integer> map1,
            @Nonnull Map<Character, Integer> map2,
            @Nonnull Map<Character, Integer> map3);

    @Override
    @Nonnull
     HashCharIntMap newUpdatableMap(@Nonnull Map<Character, Integer> map1,
            @Nonnull Map<Character, Integer> map2,
            @Nonnull Map<Character, Integer> map3,
            @Nonnull Map<Character, Integer> map4);

    @Override
    @Nonnull
     HashCharIntMap newUpdatableMap(@Nonnull Map<Character, Integer> map1,
            @Nonnull Map<Character, Integer> map2,
            @Nonnull Map<Character, Integer> map3,
            @Nonnull Map<Character, Integer> map4,
            @Nonnull Map<Character, Integer> map5);



    @Override
    @Nonnull
     HashCharIntMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.CharIntConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashCharIntMap newUpdatableMap(
            @Nonnull char[] keys, @Nonnull int[] values);

    @Override
    @Nonnull
     HashCharIntMap newUpdatableMap(
            @Nonnull Character[] keys, @Nonnull Integer[] values);

    @Override
    @Nonnull
     HashCharIntMap newUpdatableMap(@Nonnull Iterable<Character> keys,
            @Nonnull Iterable<Integer> values);


    @Override
    @Nonnull
     HashCharIntMap newUpdatableMapOf(char k1, int v1);

    @Override
    @Nonnull
     HashCharIntMap newUpdatableMapOf(char k1, int v1,
            char k2, int v2);

    @Override
    @Nonnull
     HashCharIntMap newUpdatableMapOf(char k1, int v1,
            char k2, int v2, char k3, int v3);

    @Override
    @Nonnull
     HashCharIntMap newUpdatableMapOf(char k1, int v1,
            char k2, int v2, char k3, int v3,
            char k4, int v4);

    @Override
    @Nonnull
     HashCharIntMap newUpdatableMapOf(char k1, int v1,
            char k2, int v2, char k3, int v3,
            char k4, int v4, char k5, int v5);

    


    @Override
    @Nonnull
     HashCharIntMap newImmutableMap(@Nonnull Map<Character, Integer> map1,
            @Nonnull Map<Character, Integer> map2, int expectedSize);

    @Override
    @Nonnull
     HashCharIntMap newImmutableMap(@Nonnull Map<Character, Integer> map1,
            @Nonnull Map<Character, Integer> map2,
            @Nonnull Map<Character, Integer> map3, int expectedSize);

    @Override
    @Nonnull
     HashCharIntMap newImmutableMap(@Nonnull Map<Character, Integer> map1,
            @Nonnull Map<Character, Integer> map2,
            @Nonnull Map<Character, Integer> map3,
            @Nonnull Map<Character, Integer> map4, int expectedSize);

    @Override
    @Nonnull
     HashCharIntMap newImmutableMap(@Nonnull Map<Character, Integer> map1,
            @Nonnull Map<Character, Integer> map2,
            @Nonnull Map<Character, Integer> map3,
            @Nonnull Map<Character, Integer> map4,
            @Nonnull Map<Character, Integer> map5, int expectedSize);



    @Override
    @Nonnull
     HashCharIntMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.CharIntConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashCharIntMap newImmutableMap(
            @Nonnull char[] keys, @Nonnull int[] values, int expectedSize);

    @Override
    @Nonnull
     HashCharIntMap newImmutableMap(
            @Nonnull Character[] keys, @Nonnull Integer[] values, int expectedSize);

    @Override
    @Nonnull
     HashCharIntMap newImmutableMap(@Nonnull Iterable<Character> keys,
            @Nonnull Iterable<Integer> values, int expectedSize);

    

    @Override
    @Nonnull
     HashCharIntMap newImmutableMap(
            @Nonnull Map<Character, Integer> map);

    @Override
    @Nonnull
     HashCharIntMap newImmutableMap(@Nonnull Map<Character, Integer> map1,
            @Nonnull Map<Character, Integer> map2);

    @Override
    @Nonnull
     HashCharIntMap newImmutableMap(@Nonnull Map<Character, Integer> map1,
            @Nonnull Map<Character, Integer> map2,
            @Nonnull Map<Character, Integer> map3);

    @Override
    @Nonnull
     HashCharIntMap newImmutableMap(@Nonnull Map<Character, Integer> map1,
            @Nonnull Map<Character, Integer> map2,
            @Nonnull Map<Character, Integer> map3,
            @Nonnull Map<Character, Integer> map4);

    @Override
    @Nonnull
     HashCharIntMap newImmutableMap(@Nonnull Map<Character, Integer> map1,
            @Nonnull Map<Character, Integer> map2,
            @Nonnull Map<Character, Integer> map3,
            @Nonnull Map<Character, Integer> map4,
            @Nonnull Map<Character, Integer> map5);



    @Override
    @Nonnull
     HashCharIntMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.CharIntConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashCharIntMap newImmutableMap(
            @Nonnull char[] keys, @Nonnull int[] values);

    @Override
    @Nonnull
     HashCharIntMap newImmutableMap(
            @Nonnull Character[] keys, @Nonnull Integer[] values);

    @Override
    @Nonnull
     HashCharIntMap newImmutableMap(@Nonnull Iterable<Character> keys,
            @Nonnull Iterable<Integer> values);


    @Override
    @Nonnull
     HashCharIntMap newImmutableMapOf(char k1, int v1);

    @Override
    @Nonnull
     HashCharIntMap newImmutableMapOf(char k1, int v1,
            char k2, int v2);

    @Override
    @Nonnull
     HashCharIntMap newImmutableMapOf(char k1, int v1,
            char k2, int v2, char k3, int v3);

    @Override
    @Nonnull
     HashCharIntMap newImmutableMapOf(char k1, int v1,
            char k2, int v2, char k3, int v3,
            char k4, int v4);

    @Override
    @Nonnull
     HashCharIntMap newImmutableMapOf(char k1, int v1,
            char k2, int v2, char k3, int v3,
            char k4, int v4, char k5, int v5);
}
