/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.visualisations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.simantics.NameLabelUtil;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.request.ObjectsWithSupertype;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.request.Read;
import org.simantics.district.network.visualisations.model.DynamicArrowContribution;
import org.simantics.district.network.visualisations.model.DynamicColorContribution;
import org.simantics.district.network.visualisations.model.DynamicColorMap;
import org.simantics.district.network.visualisations.model.DynamicSizeContribution;
import org.simantics.district.network.visualisations.model.DynamicSizeMap;
import org.simantics.layer0.Layer0;
import org.simantics.scl.compiler.top.ValueNotFound;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.tuple.Tuple0;
import org.simantics.structural.stubs.StructuralResource2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicVisualisationsContributions {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicVisualisationsContributions.class);
    private static final String COMMON_DYNAMIC_VISUALISATIONS_MODULE = "CommonDynamicVisualisations";
    private static final String COLOR_MAP_CONTRIBUTION = "colorMapContribution";
    private static final String SIZE_MAP_CONTRIBUTION = "sizeMapContribution";
    private static final String DYNAMIC_VISUALISATIONS_CONTRIBUTION_MODULE = "DynamicVisualisationsContribution";
    private static final String COLOR_CONTRIBUTION = "colorContribution";
    private static final String SIZE_CONTRIBUTION = "sizeContribution";
    private static final String ARROW_CONTRIBUTION = "arrowContribution";

    public static Map<String, DynamicColorMap> dynamicColorMaps(ReadGraph graph) throws DatabaseException {
        List sharedOntologies = (List)Simantics.applySCL((String)"Simantics/SharedOntologies", (String)"getSharedOntologies", (ReadGraph)graph, (Object[])new Object[]{Tuple0.INSTANCE});
        HashMap<String, DynamicColorMap> results = new HashMap<String, DynamicColorMap>();
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        for (Resource sharedOntology : sharedOntologies) {
            Resource sclModule = Layer0Utils.getPossibleChild((ReadGraph)graph, (Resource)sharedOntology, (Resource)L0.SCLModule, (String)COMMON_DYNAMIC_VISUALISATIONS_MODULE);
            if (sclModule == null) continue;
            String moduleURI = graph.getURI(sclModule);
            Object oldGraph = SCLContext.getCurrent().get((Object)"graph");
            try {
                try {
                    SCLContext.getCurrent().put((Object)"graph", (Object)graph);
                    List result = (List)SCLOsgi.MODULE_REPOSITORY.getValue(moduleURI, COLOR_MAP_CONTRIBUTION);
                    for (DynamicColorMap colorMap : result) {
                        results.put(colorMap.getLabel(), colorMap);
                    }
                }
                catch (ValueNotFound e) {
                    LOGGER.debug("Dynamic color maps not found for {}", (Object)sclModule, (Object)e);
                    SCLContext.getCurrent().put((Object)"graph", oldGraph);
                    continue;
                }
            }
            catch (Throwable throwable) {
                SCLContext.getCurrent().put((Object)"graph", oldGraph);
                throw throwable;
            }
            SCLContext.getCurrent().put((Object)"graph", oldGraph);
        }
        return results;
    }

    public static Map<String, DynamicSizeMap> dynamicSizeMaps(ReadGraph graph) throws DatabaseException {
        List sharedOntologies = (List)Simantics.applySCL((String)"Simantics/SharedOntologies", (String)"getSharedOntologies", (ReadGraph)graph, (Object[])new Object[]{Tuple0.INSTANCE});
        HashMap<String, DynamicSizeMap> results = new HashMap<String, DynamicSizeMap>();
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        for (Resource sharedOntology : sharedOntologies) {
            Resource sclModule = Layer0Utils.getPossibleChild((ReadGraph)graph, (Resource)sharedOntology, (Resource)L0.SCLModule, (String)COMMON_DYNAMIC_VISUALISATIONS_MODULE);
            if (sclModule == null) continue;
            String moduleURI = graph.getURI(sclModule);
            Object oldGraph = SCLContext.getCurrent().get((Object)"graph");
            try {
                try {
                    SCLContext.getCurrent().put((Object)"graph", (Object)graph);
                    List result = (List)SCLOsgi.MODULE_REPOSITORY.getValue(moduleURI, SIZE_MAP_CONTRIBUTION);
                    for (DynamicSizeMap sizeMap : result) {
                        results.put(sizeMap.getLabel(), sizeMap);
                    }
                }
                catch (ValueNotFound e) {
                    LOGGER.debug("Dynamic size maps not found for {}", (Object)sclModule, (Object)e);
                    SCLContext.getCurrent().put((Object)"graph", oldGraph);
                    continue;
                }
            }
            catch (Throwable throwable) {
                SCLContext.getCurrent().put((Object)"graph", oldGraph);
                throw throwable;
            }
            SCLContext.getCurrent().put((Object)"graph", oldGraph);
        }
        return results;
    }

    public static Collection<DynamicColoringObject> dynamicColoringObjects(ReadGraph graph) throws DatabaseException {
        List sharedOntologies = (List)Simantics.applySCL((String)"Simantics/SharedOntologies", (String)"getSharedOntologies", (ReadGraph)graph, (Object[])new Object[]{Tuple0.INSTANCE});
        ArrayList<DynamicColoringObject> results = new ArrayList<DynamicColoringObject>();
        for (Resource sharedOntology : sharedOntologies) {
            Collection findByType = (Collection)graph.syncRequest((Read)new ObjectsWithSupertype(sharedOntology, Layer0.getInstance((ReadGraph)graph).ConsistsOf, StructuralResource2.getInstance((ReadGraph)graph).Component));
            for (Resource find : findByType) {
                NamedResource moduleType = new NamedResource(NameLabelUtil.modalName((ReadGraph)graph, (Resource)find), find);
                DynamicColoringObject dynamicColoringObject = DynamicVisualisationsContributions.dynamicColoringObject(graph, moduleType);
                if (dynamicColoringObject == null) continue;
                results.add(dynamicColoringObject);
            }
        }
        return results;
    }

    public static Collection<DynamicSizingObject> dynamicSizingObjects(ReadGraph graph) throws DatabaseException {
        List sharedOntologies = (List)Simantics.applySCL((String)"Simantics/SharedOntologies", (String)"getSharedOntologies", (ReadGraph)graph, (Object[])new Object[]{Tuple0.INSTANCE});
        ArrayList<DynamicSizingObject> results = new ArrayList<DynamicSizingObject>();
        for (Resource sharedOntology : sharedOntologies) {
            Collection findByType = (Collection)graph.syncRequest((Read)new ObjectsWithSupertype(sharedOntology, Layer0.getInstance((ReadGraph)graph).ConsistsOf, StructuralResource2.getInstance((ReadGraph)graph).Component));
            for (Resource find : findByType) {
                NamedResource moduleType = new NamedResource(NameLabelUtil.modalName((ReadGraph)graph, (Resource)find), find);
                DynamicSizingObject dynamicSizingObject = DynamicVisualisationsContributions.dynamicSizingObject(graph, moduleType);
                if (dynamicSizingObject == null) continue;
                results.add(dynamicSizingObject);
            }
        }
        return results;
    }

    private static DynamicColoringObject dynamicColoringObject(ReadGraph graph, NamedResource moduleType) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource sclModule = Layer0Utils.getPossibleChild((ReadGraph)graph, (Resource)moduleType.getResource(), (Resource)L0.SCLModule, (String)DYNAMIC_VISUALISATIONS_CONTRIBUTION_MODULE);
        if (sclModule != null) {
            String moduleURI = graph.getURI(sclModule);
            return new DynamicColoringObject(moduleType, DynamicVisualisationsContributions.getContributionSupplier(moduleURI, COLOR_CONTRIBUTION));
        }
        return null;
    }

    private static DynamicSizingObject dynamicSizingObject(ReadGraph graph, NamedResource moduleType) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource sclModule = Layer0Utils.getPossibleChild((ReadGraph)graph, (Resource)moduleType.getResource(), (Resource)L0.SCLModule, (String)DYNAMIC_VISUALISATIONS_CONTRIBUTION_MODULE);
        if (sclModule != null) {
            String moduleURI = graph.getURI(sclModule);
            return new DynamicSizingObject(moduleType, DynamicVisualisationsContributions.getContributionSupplier(moduleURI, SIZE_CONTRIBUTION));
        }
        return null;
    }

    public static Collection<DynamicArrowObject> dynamicEdgeArrowObjects(ReadGraph graph) throws DatabaseException {
        List sharedOntologies = (List)Simantics.applySCL((String)"Simantics/SharedOntologies", (String)"getSharedOntologies", (ReadGraph)graph, (Object[])new Object[]{Tuple0.INSTANCE});
        ArrayList<DynamicArrowObject> results = new ArrayList<DynamicArrowObject>();
        for (Resource sharedOntology : sharedOntologies) {
            Collection findByType = (Collection)graph.syncRequest((Read)new ObjectsWithSupertype(sharedOntology, Layer0.getInstance((ReadGraph)graph).ConsistsOf, StructuralResource2.getInstance((ReadGraph)graph).Component));
            for (Resource find : findByType) {
                NamedResource moduleType = new NamedResource(NameLabelUtil.modalName((ReadGraph)graph, (Resource)find), find);
                DynamicArrowObject dynamicarrowObject = DynamicVisualisationsContributions.dynamicEdgeArrowObject(graph, moduleType);
                if (dynamicarrowObject == null) continue;
                results.add(dynamicarrowObject);
            }
        }
        return results;
    }

    private static DynamicArrowObject dynamicEdgeArrowObject(ReadGraph graph, NamedResource moduleType) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource sclModule = Layer0Utils.getPossibleChild((ReadGraph)graph, (Resource)moduleType.getResource(), (Resource)L0.SCLModule, (String)DYNAMIC_VISUALISATIONS_CONTRIBUTION_MODULE);
        if (sclModule != null) {
            String moduleURI = graph.getURI(sclModule);
            return new DynamicArrowObject(moduleType, DynamicVisualisationsContributions.getContributionSupplier(moduleURI, ARROW_CONTRIBUTION));
        }
        return null;
    }

    private static <T> Supplier<Stream<T>> getContributionSupplier(String uri, String expressionText) {
        return () -> {
            try {
                List result = (List)SCLOsgi.MODULE_REPOSITORY.getValue(uri, expressionText);
                return result.stream();
            }
            catch (ValueNotFound e) {
                LOGGER.trace("Could not find contributions for module {} and expression {}", new Object[]{uri, expressionText, e});
                return Stream.empty();
            }
        };
    }

    public static class DynamicArrowObject {
        private final NamedResource arrowObject;
        private final Supplier<Stream<DynamicArrowContribution>> arrowContributionSupplier;
        private Map<String, DynamicArrowContribution> arrowContributions;

        public DynamicArrowObject(NamedResource coloringObject, Supplier<Stream<DynamicArrowContribution>> arrowContributionSupplier) {
            this.arrowObject = coloringObject;
            this.arrowContributionSupplier = arrowContributionSupplier;
        }

        public NamedResource getArrowObject() {
            return this.arrowObject;
        }

        public Map<String, DynamicArrowContribution> getArrowContributions() {
            if (this.arrowContributions == null) {
                this.arrowContributions = this.arrowContributionSupplier.get().collect(Collectors.toMap(c -> c.getLabel(), c -> c));
            }
            return this.arrowContributions;
        }
    }

    public static class DynamicColoringMap {
        private final NamedResource coloringObject;
        private final Supplier<Stream<DynamicColorMap>> colorContributionSupplier;
        private Map<String, DynamicColorMap> colorContributions;

        public DynamicColoringMap(NamedResource coloringObject, Supplier<Stream<DynamicColorMap>> colorContributionSupplier) {
            this.coloringObject = coloringObject;
            this.colorContributionSupplier = colorContributionSupplier;
        }

        public NamedResource getColoringObject() {
            return this.coloringObject;
        }

        public Map<String, DynamicColorMap> getColorContributions() {
            if (this.colorContributions == null) {
                this.colorContributions = this.colorContributionSupplier.get().collect(Collectors.toMap(c -> c.getLabel(), c -> c));
            }
            return this.colorContributions;
        }
    }

    public static class DynamicColoringObject {
        private final NamedResource coloringObject;
        private final Supplier<Stream<DynamicColorContribution>> colorContributionSupplier;
        private Map<String, DynamicColorContribution> colorContributions;

        public DynamicColoringObject(NamedResource coloringObject, Supplier<Stream<DynamicColorContribution>> colorContributionSupplier) {
            this.coloringObject = coloringObject;
            this.colorContributionSupplier = colorContributionSupplier;
        }

        public NamedResource getColoringObject() {
            return this.coloringObject;
        }

        public Map<String, DynamicColorContribution> getColorContributions() {
            if (this.colorContributions == null) {
                this.colorContributions = this.colorContributionSupplier.get().collect(Collectors.toMap(c -> c.getLabel(), c -> c));
            }
            return this.colorContributions;
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + " [" + this.coloringObject.getName() + " (" + this.coloringObject.getResource() + "), contributions=" + this.colorContributionsToString() + "]";
        }

        private String colorContributionsToString() {
            return this.colorContributions.keySet().stream().map(key -> {
                DynamicColorContribution dynamicColorContribution = this.colorContributions.get(key);
                return String.valueOf(key) + "=" + dynamicColorContribution.getLabel();
            }).collect(Collectors.joining(", ", "{", "}"));
        }
    }

    public static class DynamicSizingObject {
        private final NamedResource sizingObject;
        private final Supplier<Stream<DynamicSizeContribution>> sizeContributionSupplier;
        private Map<String, DynamicSizeContribution> sizeContributions;

        public DynamicSizingObject(NamedResource coloringObject, Supplier<Stream<DynamicSizeContribution>> sizeContributionSupplier) {
            this.sizingObject = coloringObject;
            this.sizeContributionSupplier = sizeContributionSupplier;
        }

        public NamedResource getSizingObject() {
            return this.sizingObject;
        }

        public Map<String, DynamicSizeContribution> getSizeContributions() {
            if (this.sizeContributions == null) {
                this.sizeContributions = this.sizeContributionSupplier.get().collect(Collectors.toMap(c -> c.getLabel(), c -> c));
            }
            return this.sizeContributions;
        }
    }
}

