/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.visualisations;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.QueryIndexUtils;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.district.network.visualisations.DynamicVisualisationsContributions;
import org.simantics.district.network.visualisations.model.ColorBarOptions;
import org.simantics.district.network.visualisations.model.DynamicArrowContribution;
import org.simantics.district.network.visualisations.model.DynamicColorContribution;
import org.simantics.district.network.visualisations.model.DynamicColorMap;
import org.simantics.district.network.visualisations.model.DynamicSizeContribution;
import org.simantics.district.network.visualisations.model.DynamicSizeMap;
import org.simantics.district.network.visualisations.model.SizeBarOptions;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.Pair;

public class DynamicVisualisations {
    public static ColorBarOptions colorBarOptions(ReadGraph graph, Resource visualisation) throws DatabaseException {
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        if (visualisation != null) {
            String colorBarLocation = (String)graph.getPossibleRelatedValue(visualisation, DN.Diagram_Visualisations_ColorBarLocation, (Binding)Bindings.STRING);
            String colorBarSize = (String)graph.getPossibleRelatedValue(visualisation, DN.Diagram_Visualisations_ColorBarSize, (Binding)Bindings.STRING);
            Boolean show = (Boolean)graph.getPossibleRelatedValue(visualisation, DN.Diagram_Visualisations_ShowColorBars, (Binding)Bindings.BOOLEAN);
            Boolean showTicks = (Boolean)graph.getPossibleRelatedValue(visualisation, DN.Diagram_Visualisations_ShowColorBarTicks, (Binding)Bindings.BOOLEAN);
            Boolean useGradients = (Boolean)graph.getPossibleRelatedValue(visualisation, DN.Diagram_Visualisations_UseColorBarGradients, (Binding)Bindings.BOOLEAN);
            if (colorBarLocation != null) {
                return new ColorBarOptions().showColorBars(show != null ? show : false).showColorBarsTicks(showTicks != null ? showTicks : false).useGradients(useGradients != null ? useGradients : false).withLocation(ColorBarOptions.ColorBarsLocation.valueOf(colorBarLocation)).withSize(ColorBarOptions.ColorBarsSize.valueOf(colorBarSize));
            }
        }
        return ColorBarOptions.useDefault();
    }

    public static void setColorBarOptions(WriteGraph graph, Resource visualisation, ColorBarOptions options) throws DatabaseException {
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        graph.claimLiteral(visualisation, DN.Diagram_Visualisations_ColorBarLocation, (Object)options.getLocation().toString(), (Binding)Bindings.STRING);
        graph.claimLiteral(visualisation, DN.Diagram_Visualisations_ColorBarSize, (Object)options.getSize().toString(), (Binding)Bindings.STRING);
        graph.claimLiteral(visualisation, DN.Diagram_Visualisations_ShowColorBars, (Object)options.isShowColorBars(), (Binding)Bindings.BOOLEAN);
        graph.claimLiteral(visualisation, DN.Diagram_Visualisations_ShowColorBarTicks, (Object)options.isShowColorBarsTicks(), (Binding)Bindings.BOOLEAN);
        graph.claimLiteral(visualisation, DN.Diagram_Visualisations_UseColorBarGradients, (Object)options.isUseGradients(), (Binding)Bindings.BOOLEAN);
    }

    public static Resource createVisualisation(WriteGraph graph, Resource parent, String visualisationName) throws DatabaseException {
        Resource vf = DynamicVisualisations.getOrCreateVisualisationsFolder(graph, parent);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        Resource visualisation = graph.newResource();
        graph.claim(visualisation, L0.InstanceOf, DN.Diagram_Visualisations);
        graph.claimLiteral(visualisation, L0.HasName, (Object)visualisationName);
        graph.claim(vf, DN.Diagram_hasVisualisation, visualisation);
        return visualisation;
    }

    public static Resource getOrCreateVisualisationsFolder(WriteGraph graph, Resource model) throws DatabaseException {
        Resource rf = DynamicVisualisations.getVisualisationFolder((ReadGraph)graph, model);
        if (rf == null) {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
            rf = graph.newResource();
            graph.claim(rf, L0.InstanceOf, null, DN.VisualisationsFolder);
            graph.claimLiteral(rf, L0.HasName, L0.NameOf, L0.String, (Object)UUID.randomUUID().toString(), (Binding)Bindings.STRING);
            graph.claim(model, L0.ConsistsOf, L0.PartOf, rf);
        }
        return rf;
    }

    public static Resource getVisualisationFolder(ReadGraph graph, Resource model) throws DatabaseException {
        List visualisationsFolders = QueryIndexUtils.searchByType((ReadGraph)graph, (Resource)model, (Resource)DistrictNetworkResource.getInstance((ReadGraph)graph).VisualisationsFolder);
        if (visualisationsFolders.size() > 0) {
            return (Resource)visualisationsFolders.get(0);
        }
        return null;
    }

    public static SizeBarOptions sizeBarOptions(ReadGraph graph, Resource visualisation) throws DatabaseException {
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        if (visualisation != null) {
            String sizeBarLocation = (String)graph.getPossibleRelatedValue(visualisation, DN.Diagram_Visualisations_SizeBarLocation, (Binding)Bindings.STRING);
            String sizeBarSize = (String)graph.getPossibleRelatedValue(visualisation, DN.Diagram_Visualisations_SizeBarSize, (Binding)Bindings.STRING);
            Boolean show = (Boolean)graph.getPossibleRelatedValue(visualisation, DN.Diagram_Visualisations_ShowSizeBars, (Binding)Bindings.BOOLEAN);
            Boolean showTicks = (Boolean)graph.getPossibleRelatedValue(visualisation, DN.Diagram_Visualisations_ShowSizeBarTicks, (Binding)Bindings.BOOLEAN);
            Boolean useGradients = (Boolean)graph.getPossibleRelatedValue(visualisation, DN.Diagram_Visualisations_UseSizeBarGradients, (Binding)Bindings.BOOLEAN);
            if (sizeBarLocation != null) {
                return new SizeBarOptions().showSizeBars(show != null ? show : false).showSizeBarsTicks(showTicks != null ? showTicks : false).useGradients(useGradients != null ? useGradients : false).withLocation(SizeBarOptions.SizeBarsLocation.valueOf(sizeBarLocation)).withSize(SizeBarOptions.SizeBarsSize.valueOf(sizeBarSize));
            }
        }
        return SizeBarOptions.useDefault();
    }

    public static void setSizeBarOptions(WriteGraph graph, Resource visualisation, SizeBarOptions options) throws DatabaseException {
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        graph.claimLiteral(visualisation, DN.Diagram_Visualisations_SizeBarLocation, (Object)options.getLocation().toString(), (Binding)Bindings.STRING);
        graph.claimLiteral(visualisation, DN.Diagram_Visualisations_SizeBarSize, (Object)options.getSize().toString(), (Binding)Bindings.STRING);
        graph.claimLiteral(visualisation, DN.Diagram_Visualisations_ShowSizeBars, (Object)options.isShowSizeBars(), (Binding)Bindings.BOOLEAN);
        graph.claimLiteral(visualisation, DN.Diagram_Visualisations_ShowSizeBarTicks, (Object)options.isShowSizeBarsTicks(), (Binding)Bindings.BOOLEAN);
        graph.claimLiteral(visualisation, DN.Diagram_Visualisations_UseSizeBarGradients, (Object)options.isUseGradients(), (Binding)Bindings.BOOLEAN);
    }

    public static Map<String, DynamicColorContribution> colorContributions(ReadGraph graph, Resource visualisation) throws DatabaseException {
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        if (visualisation == null) {
            return Collections.emptyMap();
        }
        HashMap<String, DynamicColorContribution> contributions = new HashMap<String, DynamicColorContribution>();
        Map<String, DynamicColorMap> colorMaps = DynamicVisualisationsContributions.dynamicColorMaps(graph);
        Collection colorContributions = graph.getObjects(visualisation, DN.Diagram_Visualisations_colorContributions);
        for (Resource colorContribution : colorContributions) {
            String ucName = (String)graph.getRelatedValue(colorContribution, DN.Diagram_Visualisations_colorContributionContributorName, (Binding)Bindings.STRING);
            String label = (String)graph.getRelatedValue(colorContribution, DN.Diagram_Visualisations_colorContributionLabel, (Binding)Bindings.STRING);
            String moduleName = (String)graph.getRelatedValue(colorContribution, DN.Diagram_Visualisations_colorContributionModuleName, (Binding)Bindings.STRING);
            String attributeName = (String)graph.getRelatedValue(colorContribution, DN.Diagram_Visualisations_colorContributionModuleAttribute, (Binding)Bindings.STRING);
            String unit = (String)graph.getRelatedValue(colorContribution, DN.Diagram_Visualisations_colorContributionUnit, (Binding)Bindings.STRING);
            Double variableGain = (Double)graph.getRelatedValue(colorContribution, DN.Diagram_Visualisations_colorContributionVariableGain, (Binding)Bindings.DOUBLE);
            Double variableBias = (Double)graph.getRelatedValue(colorContribution, DN.Diagram_Visualisations_colorContributionVariableBias, (Binding)Bindings.DOUBLE);
            String dynamicColorMap = (String)graph.getRelatedValue(colorContribution, DN.Diagram_Visualisations_colorContributionDefaultColorMap, (Binding)Bindings.STRING);
            Double defaultMin = (Double)graph.getRelatedValue(colorContribution, DN.Diagram_Visualisations_colorContributionDefaultMin, (Binding)Bindings.DOUBLE);
            Double defaultMax = (Double)graph.getRelatedValue(colorContribution, DN.Diagram_Visualisations_colorContributionDefaultMax, (Binding)Bindings.DOUBLE);
            Boolean used = (Boolean)graph.getRelatedValue(colorContribution, DN.Diagram_Visualisations_colorContributionUsed, (Binding)Bindings.BOOLEAN);
            Boolean useDefault = (Boolean)graph.getRelatedValue(colorContribution, DN.Diagram_Visualisations_colorContributionUseDefault, (Binding)Bindings.BOOLEAN);
            DynamicColorContribution dynamicColorContribution = new DynamicColorContribution(label, moduleName, attributeName, unit, variableGain, variableBias, colorMaps.get(dynamicColorMap), defaultMin, defaultMax);
            dynamicColorContribution.setUsed(used != null ? used : false);
            dynamicColorContribution.setUseDefault(useDefault != null ? useDefault : false);
            contributions.put(ucName, dynamicColorContribution);
        }
        return contributions;
    }

    public static void setColorContributions(WriteGraph graph, Resource visualisation, List<Pair<String, DynamicColorContribution>> collect) throws DatabaseException {
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        graph.deny(visualisation, DN.Diagram_Visualisations_colorContributions);
        for (Pair<String, DynamicColorContribution> coll : collect) {
            Resource colorContribution = graph.newResource();
            graph.claim(colorContribution, L0.InstanceOf, DN.Diagram_Visualisations_ColorContribution);
            graph.claimLiteral(colorContribution, L0.HasName, coll.first);
            DynamicColorContribution contr = (DynamicColorContribution)coll.second;
            graph.claimLiteral(colorContribution, DN.Diagram_Visualisations_colorContributionContributorName, coll.first, (Binding)Bindings.STRING);
            graph.claimLiteral(colorContribution, DN.Diagram_Visualisations_colorContributionLabel, (Object)contr.getLabel(), (Binding)Bindings.STRING);
            graph.claimLiteral(colorContribution, DN.Diagram_Visualisations_colorContributionModuleName, (Object)contr.getModuleName(), (Binding)Bindings.STRING);
            graph.claimLiteral(colorContribution, DN.Diagram_Visualisations_colorContributionModuleAttribute, (Object)contr.getAttributeName(), (Binding)Bindings.STRING);
            graph.claimLiteral(colorContribution, DN.Diagram_Visualisations_colorContributionUnit, (Object)contr.getUnit(), (Binding)Bindings.STRING);
            graph.claimLiteral(colorContribution, DN.Diagram_Visualisations_colorContributionVariableGain, (Object)contr.getVariableGain(), (Binding)Bindings.DOUBLE);
            graph.claimLiteral(colorContribution, DN.Diagram_Visualisations_colorContributionVariableBias, (Object)contr.getVariableBias(), (Binding)Bindings.DOUBLE);
            graph.claimLiteral(colorContribution, DN.Diagram_Visualisations_colorContributionDefaultColorMap, (Object)contr.getDefaultColorMap().getLabel(), (Binding)Bindings.STRING);
            graph.claimLiteral(colorContribution, DN.Diagram_Visualisations_colorContributionDefaultMin, (Object)contr.getDefaultMin(), (Binding)Bindings.DOUBLE);
            graph.claimLiteral(colorContribution, DN.Diagram_Visualisations_colorContributionDefaultMax, (Object)contr.getDefaultMax(), (Binding)Bindings.DOUBLE);
            graph.claimLiteral(colorContribution, DN.Diagram_Visualisations_colorContributionUsed, (Object)contr.isUsed(), (Binding)Bindings.BOOLEAN);
            graph.claimLiteral(colorContribution, DN.Diagram_Visualisations_colorContributionUseDefault, (Object)contr.isUseDefault(), (Binding)Bindings.BOOLEAN);
            graph.claim(visualisation, DN.Diagram_Visualisations_colorContributions, colorContribution);
        }
    }

    public static void setEdgeArrowContributions(WriteGraph graph, Resource visualisation, List<Pair<String, DynamicArrowContribution>> edgeArrowCollect) throws DatabaseException {
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        graph.deny(visualisation, DN.Diagram_Visualisations_arrowContributions);
        for (Pair<String, DynamicArrowContribution> coll : edgeArrowCollect) {
            Resource arrowContribution = graph.newResource();
            graph.claim(arrowContribution, L0.InstanceOf, DN.Diagram_Visualisations_ArrowContribution);
            graph.claimLiteral(arrowContribution, L0.HasName, coll.first);
            DynamicArrowContribution contr = (DynamicArrowContribution)coll.second;
            graph.claimLiteral(arrowContribution, DN.Diagram_Visualisations_arrowContributionContributorName, coll.first, (Binding)Bindings.STRING);
            graph.claimLiteral(arrowContribution, DN.Diagram_Visualisations_arrowContributionLabel, (Object)contr.getLabel(), (Binding)Bindings.STRING);
            graph.claimLiteral(arrowContribution, DN.Diagram_Visualisations_arrowContributionModuleName, (Object)contr.getModuleName(), (Binding)Bindings.STRING);
            graph.claimLiteral(arrowContribution, DN.Diagram_Visualisations_arrowContributionModuleAttribute, (Object)contr.getAttributeName(), (Binding)Bindings.STRING);
            graph.claimLiteral(arrowContribution, DN.Diagram_Visualisations_arrowContributionVariableGain, (Object)contr.getDefaultGain(), (Binding)Bindings.DOUBLE);
            graph.claimLiteral(arrowContribution, DN.Diagram_Visualisations_arrowContributionVariableBias, (Object)contr.getDefaultBias(), (Binding)Bindings.DOUBLE);
            graph.claimLiteral(arrowContribution, DN.Diagram_Visualisations_arrowContributionUsed, (Object)contr.isUsed(), (Binding)Bindings.BOOLEAN);
            graph.claimLiteral(arrowContribution, DN.Diagram_Visualisations_arrowContributionUseDefault, (Object)contr.isUseDefault(), (Binding)Bindings.BOOLEAN);
            graph.claim(visualisation, DN.Diagram_Visualisations_arrowContributions, arrowContribution);
        }
    }

    public static Map<String, DynamicSizeContribution> sizeContributions(ReadGraph graph, Resource visualisation) throws DatabaseException {
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        if (visualisation == null) {
            return Collections.emptyMap();
        }
        HashMap<String, DynamicSizeContribution> contributions = new HashMap<String, DynamicSizeContribution>();
        Map<String, DynamicSizeMap> sizeMaps = DynamicVisualisationsContributions.dynamicSizeMaps(graph);
        Collection sizeContributions = graph.getObjects(visualisation, DN.Diagram_Visualisations_sizeContributions);
        for (Resource sizeContribution : sizeContributions) {
            String ucName = (String)graph.getRelatedValue(sizeContribution, DN.Diagram_Visualisations_sizeContributionContributorName, (Binding)Bindings.STRING);
            String label = (String)graph.getRelatedValue(sizeContribution, DN.Diagram_Visualisations_sizeContributionLabel, (Binding)Bindings.STRING);
            String moduleName = (String)graph.getRelatedValue(sizeContribution, DN.Diagram_Visualisations_sizeContributionModuleName, (Binding)Bindings.STRING);
            String attributeName = (String)graph.getRelatedValue(sizeContribution, DN.Diagram_Visualisations_sizeContributionModuleAttribute, (Binding)Bindings.STRING);
            String unit = (String)graph.getRelatedValue(sizeContribution, DN.Diagram_Visualisations_sizeContributionUnit, (Binding)Bindings.STRING);
            Double variableGain = (Double)graph.getRelatedValue(sizeContribution, DN.Diagram_Visualisations_sizeContributionVariableGain, (Binding)Bindings.DOUBLE);
            Double variableBias = (Double)graph.getRelatedValue(sizeContribution, DN.Diagram_Visualisations_sizeContributionVariableBias, (Binding)Bindings.DOUBLE);
            String dynamicSizeMap = (String)graph.getRelatedValue(sizeContribution, DN.Diagram_Visualisations_sizeContributionDefaultSizeMap, (Binding)Bindings.STRING);
            Double defaultMin = (Double)graph.getRelatedValue(sizeContribution, DN.Diagram_Visualisations_sizeContributionDefaultMin, (Binding)Bindings.DOUBLE);
            Double defaultMax = (Double)graph.getRelatedValue(sizeContribution, DN.Diagram_Visualisations_sizeContributionDefaultMax, (Binding)Bindings.DOUBLE);
            Boolean used = (Boolean)graph.getRelatedValue(sizeContribution, DN.Diagram_Visualisations_sizeContributionUsed, (Binding)Bindings.BOOLEAN);
            Boolean useDefault = (Boolean)graph.getRelatedValue(sizeContribution, DN.Diagram_Visualisations_sizeContributionUseDefault, (Binding)Bindings.BOOLEAN);
            DynamicSizeContribution dsc = new DynamicSizeContribution(label, moduleName, attributeName, unit, variableGain, variableBias, sizeMaps.get(dynamicSizeMap), defaultMin, defaultMax);
            dsc.setUsed(used != null ? used : false);
            dsc.setUseDefault(useDefault != null ? useDefault : false);
            contributions.put(ucName, dsc);
        }
        return contributions;
    }

    public static Map<String, DynamicArrowContribution> arrowContributions(ReadGraph graph, Resource visualisation) throws DatabaseException {
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        if (visualisation == null) {
            return Collections.emptyMap();
        }
        HashMap<String, DynamicArrowContribution> contributions = new HashMap<String, DynamicArrowContribution>();
        Collection sizeContributions = graph.getObjects(visualisation, DN.Diagram_Visualisations_arrowContributions);
        for (Resource sizeContribution : sizeContributions) {
            String ucName = (String)graph.getRelatedValue(sizeContribution, DN.Diagram_Visualisations_arrowContributionContributorName, (Binding)Bindings.STRING);
            String label = (String)graph.getRelatedValue(sizeContribution, DN.Diagram_Visualisations_arrowContributionLabel, (Binding)Bindings.STRING);
            String moduleName = (String)graph.getRelatedValue(sizeContribution, DN.Diagram_Visualisations_arrowContributionModuleName, (Binding)Bindings.STRING);
            String attributeName = (String)graph.getRelatedValue(sizeContribution, DN.Diagram_Visualisations_arrowContributionModuleAttribute, (Binding)Bindings.STRING);
            Double variableGain = (Double)graph.getRelatedValue(sizeContribution, DN.Diagram_Visualisations_arrowContributionVariableGain, (Binding)Bindings.DOUBLE);
            Double variableBias = (Double)graph.getRelatedValue(sizeContribution, DN.Diagram_Visualisations_arrowContributionVariableBias, (Binding)Bindings.DOUBLE);
            Boolean used = (Boolean)graph.getRelatedValue(sizeContribution, DN.Diagram_Visualisations_arrowContributionUsed, (Binding)Bindings.BOOLEAN);
            Boolean useDefault = (Boolean)graph.getRelatedValue(sizeContribution, DN.Diagram_Visualisations_arrowContributionUseDefault, (Binding)Bindings.BOOLEAN);
            DynamicArrowContribution dac = new DynamicArrowContribution(label, moduleName, attributeName, variableGain, variableBias);
            dac.setUsed(used != null ? used : false);
            dac.setUseDefault(useDefault != null ? useDefault : false);
            contributions.put(ucName, dac);
        }
        return contributions;
    }

    public static void setSizeContributions(WriteGraph graph, Resource visualisation, List<Pair<String, DynamicSizeContribution>> collect) throws DatabaseException {
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        graph.deny(visualisation, DN.Diagram_Visualisations_sizeContributions);
        for (Pair<String, DynamicSizeContribution> coll : collect) {
            Resource sizeContribution = graph.newResource();
            graph.claim(sizeContribution, L0.InstanceOf, DN.Diagram_Visualisations_SizeContribution);
            graph.claimLiteral(sizeContribution, L0.HasName, coll.first);
            DynamicSizeContribution contr = (DynamicSizeContribution)coll.second;
            graph.claimLiteral(sizeContribution, DN.Diagram_Visualisations_sizeContributionContributorName, coll.first, (Binding)Bindings.STRING);
            graph.claimLiteral(sizeContribution, DN.Diagram_Visualisations_sizeContributionLabel, (Object)contr.getLabel(), (Binding)Bindings.STRING);
            graph.claimLiteral(sizeContribution, DN.Diagram_Visualisations_sizeContributionModuleName, (Object)contr.getModuleName(), (Binding)Bindings.STRING);
            graph.claimLiteral(sizeContribution, DN.Diagram_Visualisations_sizeContributionModuleAttribute, (Object)contr.getAttributeName(), (Binding)Bindings.STRING);
            graph.claimLiteral(sizeContribution, DN.Diagram_Visualisations_sizeContributionUnit, (Object)contr.getUnit(), (Binding)Bindings.STRING);
            graph.claimLiteral(sizeContribution, DN.Diagram_Visualisations_sizeContributionVariableGain, (Object)contr.getVariableGain(), (Binding)Bindings.DOUBLE);
            graph.claimLiteral(sizeContribution, DN.Diagram_Visualisations_sizeContributionVariableBias, (Object)contr.getVariableBias(), (Binding)Bindings.DOUBLE);
            graph.claimLiteral(sizeContribution, DN.Diagram_Visualisations_sizeContributionDefaultSizeMap, (Object)contr.getDefaultSizeMap().getLabel(), (Binding)Bindings.STRING);
            graph.claimLiteral(sizeContribution, DN.Diagram_Visualisations_sizeContributionDefaultMin, (Object)contr.getDefaultMin(), (Binding)Bindings.DOUBLE);
            graph.claimLiteral(sizeContribution, DN.Diagram_Visualisations_sizeContributionDefaultMax, (Object)contr.getDefaultMax(), (Binding)Bindings.DOUBLE);
            graph.claimLiteral(sizeContribution, DN.Diagram_Visualisations_sizeContributionUsed, (Object)contr.isUsed(), (Binding)Bindings.BOOLEAN);
            graph.claimLiteral(sizeContribution, DN.Diagram_Visualisations_sizeContributionUseDefault, (Object)contr.isUseDefault(), (Binding)Bindings.BOOLEAN);
            graph.claim(visualisation, DN.Diagram_Visualisations_sizeContributions, sizeContribution);
        }
    }

    public static void setActiveVisualisation(WriteGraph graph, Resource diagram, Resource visualisationTemplate) throws DatabaseException {
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        graph.deny(diagram, DN.Diagram_hasActiveVisualisation);
        graph.claim(diagram, DN.Diagram_hasActiveVisualisation, visualisationTemplate);
    }

    public static void setHideElements(WriteGraph graph, Resource visualisation, boolean edges, boolean points, boolean consumers, boolean producers, boolean valves, boolean pumpingStations) throws DatabaseException {
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        graph.claimLiteral(visualisation, DN.Diagram_Visualisations_HideEdges, (Object)edges, (Binding)Bindings.BOOLEAN);
        graph.claimLiteral(visualisation, DN.Diagram_Visualisations_HidePoints, (Object)points, (Binding)Bindings.BOOLEAN);
        graph.claimLiteral(visualisation, DN.Diagram_Visualisations_HideConsumers, (Object)consumers, (Binding)Bindings.BOOLEAN);
        graph.claimLiteral(visualisation, DN.Diagram_Visualisations_HideProducers, (Object)producers, (Binding)Bindings.BOOLEAN);
        graph.claimLiteral(visualisation, DN.Diagram_Visualisations_HideValves, (Object)valves, (Binding)Bindings.BOOLEAN);
        graph.claimLiteral(visualisation, DN.Diagram_Visualisations_HidePumpingStations, (Object)pumpingStations, (Binding)Bindings.BOOLEAN);
    }

    public static void setStaticProperties(WriteGraph graph, Resource visualisation, boolean networkBranches, boolean points, boolean consumers) throws DatabaseException {
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        graph.claimLiteral(visualisation, DN.Diagram_Visualisations_StaticPropertiesNetworkBranches, (Object)networkBranches, (Binding)Bindings.BOOLEAN);
        graph.claimLiteral(visualisation, DN.Diagram_Visualisations_StaticPropertiesPoints, (Object)points, (Binding)Bindings.BOOLEAN);
        graph.claimLiteral(visualisation, DN.Diagram_Visualisations_StaticPropertiesConsumers, (Object)consumers, (Binding)Bindings.BOOLEAN);
    }

    public static void setDynamicSymbols(WriteGraph graph, Resource visualisation, boolean edges, boolean producers, boolean valves, boolean pumpingStations) throws DatabaseException {
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        graph.claimLiteral(visualisation, DN.Diagram_Visualisations_DynamicSymbolsProducers, (Object)producers, (Binding)Bindings.BOOLEAN);
        graph.claimLiteral(visualisation, DN.Diagram_Visualisations_DynamicSymbolsShutoffValves, (Object)edges, (Binding)Bindings.BOOLEAN);
        graph.claimLiteral(visualisation, DN.Diagram_Visualisations_DynamicSymbolsValves, (Object)valves, (Binding)Bindings.BOOLEAN);
        graph.claimLiteral(visualisation, DN.Diagram_Visualisations_DynamicSymbolsPumpingStations, (Object)pumpingStations, (Binding)Bindings.BOOLEAN);
    }

    public static void setIntervalAndDisabled(WriteGraph graph, Resource visualisation, long interval, boolean disabled, boolean resetVisualisation) throws DatabaseException {
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        graph.claimLiteral(visualisation, DN.Diagram_Visualisations_Interval, (Object)interval, (Binding)Bindings.LONG);
        graph.claimLiteral(visualisation, DN.Diagram_Visualisations_DisabledUpdates, (Object)disabled, (Binding)Bindings.BOOLEAN);
        graph.claimLiteral(visualisation, DN.Diagram_Visualisations_ResetVisualisation, (Object)resetVisualisation, (Binding)Bindings.BOOLEAN);
    }

    public static void setKeyVariablesHover(WriteGraph graph, Resource visualisation, boolean hoverVertex, boolean hoverEdges) throws DatabaseException {
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        graph.claimLiteral(visualisation, DN.Diagram_Visualisations_KeyVariableVertexHover, (Object)hoverVertex, (Binding)Bindings.BOOLEAN);
        graph.claimLiteral(visualisation, DN.Diagram_Visualisations_KeyVariableEdgeHover, (Object)hoverEdges, (Binding)Bindings.BOOLEAN);
    }
}

