/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.profile;

import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.district.network.profile.ThrottledStyleBase;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DSceneGraph;
import org.simantics.scenegraph.g2d.nodes.SingleElementNode;
import org.simantics.scenegraph.profile.EvaluationContext;
import org.simantics.scenegraph.profile.common.ProfileVariables;
import org.simantics.scl.runtime.function.Function;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.scl.runtime.function.FunctionImpl1;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertexSymbolStyle
extends ThrottledStyleBase<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(VertexSymbolStyle.class);

    @Override
    public String calculateThrottledStyle(ReadGraph graph, Resource runtimeDiagram, Resource entry, Resource groupItem) throws DatabaseException {
        boolean wasSynchronous = graph.setSynchronous(true);
        try {
            Function symbolFunction = VertexSymbolStyle.getSymbolFunction(graph, entry);
            if (symbolFunction == null) {
                return null;
            }
            String string = (String)Simantics.applySCLRead((ReadGraph)graph, (Function1)symbolFunction, (Object)groupItem);
            return string;
        }
        finally {
            graph.setSynchronous(wasSynchronous);
        }
    }

    protected static Function getSymbolFunction(ReadGraph graph, Resource entry) throws DatabaseException {
        return (Function)graph.syncRequest((Read)new SymbolFunctionRequest(entry), (Listener)TransientCacheListener.instance());
    }

    @Override
    public void applyThrottledStyleForNode(EvaluationContext observer, INode node, String value) {
        SingleElementNode n = (SingleElementNode)node;
        for (INode nn : n.getNodes()) {
            ProfileVariables.claimNodeProperty((INode)nn, (String)"SVG", (Object)value, (EvaluationContext)observer);
        }
    }

    protected void cleanupStyleForNode(EvaluationContext evaluationContext, INode node) {
        ((G2DSceneGraph)node.getRootNode()).clearPending((Object)node);
        SingleElementNode n = (SingleElementNode)node;
        for (INode nn : n.getNodes()) {
            ProfileVariables.claimNodeProperty((INode)nn, (String)"SVG", null, (EvaluationContext)evaluationContext);
        }
    }

    protected static final class SymbolFunctionRequest
    extends ResourceRead<Function> {
        protected static final Function CONST_NULL = new FunctionImpl1<Resource, String>(){

            public String apply(Resource p0) {
                return null;
            }
        };

        public SymbolFunctionRequest(Resource entry) {
            super(entry);
        }

        public Function perform(ReadGraph graph) throws DatabaseException {
            DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
            Function symbolFunction = (Function)graph.getPossibleRelatedValue2(this.resource, DN.HasSymbolFunction, (Object)this.resource);
            if (symbolFunction == null) {
                symbolFunction = CONST_NULL;
            }
            return symbolFunction;
        }
    }
}

