/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.profile;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.diagram.profile.StyleBase;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.profile.EvaluationContext;
import org.simantics.scenegraph.profile.Group;
import org.simantics.scenegraph.profile.Observer;
import org.simantics.scenegraph.profile.common.ObserverGroupListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ThrottledStyleBase<Result>
extends StyleBase<Optional<Result>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThrottledStyleBase.class);
    private static final long DEFAULT_INTERVAL = 2000L;
    private AtomicLong interval = new AtomicLong(2000L);
    private Listener<Optional<Result>> resultListener;

    protected Read<Optional<Result>> getStyleCalculationRequest(Resource runtimeDiagram, Resource entry, Resource item) {
        return super.getStyleCalculationRequest(runtimeDiagram, entry, item);
    }

    protected Listener<Optional<Result>> getStyleResultListener(ObserverGroupListener groupListener, Resource item, Group group, Observer observer, Resource runtimeDiagram) {
        this.resultListener = super.getStyleResultListener(groupListener, item, group, observer, runtimeDiagram);
        return this.resultListener;
    }

    public final Optional<Result> calculateStyle(ReadGraph graph, Resource runtimeDiagram, Resource entry, Resource groupItem) throws DatabaseException {
        return Optional.ofNullable(this.calculateThrottledStyle(graph, runtimeDiagram, entry, groupItem));
    }

    public abstract Result calculateThrottledStyle(ReadGraph var1, Resource var2, Resource var3, Resource var4) throws DatabaseException;

    public final void applyStyleForNode(EvaluationContext evaluationContext, INode node, Optional<Result> result) {
        if (!Optional.empty().equals(result) && result != null) {
            this.applyThrottledStyleForNode(evaluationContext, node, result.get());
        } else {
            LOGGER.debug("Do not apply as results are unchanged for {} {} {}", new Object[]{evaluationContext, node, result});
            this.applyThrottledStyleForNode(evaluationContext, node, null);
        }
    }

    public abstract void applyThrottledStyleForNode(EvaluationContext var1, INode var2, Result var3);

    private class ProfileUpdateIntervalListener
    implements Listener<Long> {
        private Resource runtimeDiagram;
        private Resource entry;
        private Resource item;

        public ProfileUpdateIntervalListener(Resource runtimeDiagram, Resource entry, Resource item) {
            this.runtimeDiagram = runtimeDiagram;
            this.entry = entry;
            this.item = item;
        }

        public void execute(Long result) {
            ThrottledStyleBase.this.interval.set(result);
        }

        public void exception(Throwable t) {
            LOGGER.error("Could not listen interval from runtime diagram {}", (Object)this.runtimeDiagram, (Object)t);
        }

        public boolean isDisposed() {
            return ThrottledStyleBase.this.resultListener.isDisposed();
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + ((Object)((Object)this.getEnclosingInstance())).hashCode();
            result = 31 * result + (this.entry == null ? 0 : this.entry.hashCode());
            result = 31 * result + (this.item == null ? 0 : this.item.hashCode());
            result = 31 * result + (this.runtimeDiagram == null ? 0 : this.runtimeDiagram.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProfileUpdateIntervalListener other = (ProfileUpdateIntervalListener)obj;
            if (!((Object)((Object)this.getEnclosingInstance())).equals((Object)other.getEnclosingInstance())) {
                return false;
            }
            if (this.entry == null ? other.entry != null : !this.entry.equals(other.entry)) {
                return false;
            }
            if (this.item == null ? other.item != null : !this.item.equals(other.item)) {
                return false;
            }
            return !(this.runtimeDiagram == null ? other.runtimeDiagram != null : !this.runtimeDiagram.equals(other.runtimeDiagram));
        }

        private ThrottledStyleBase<Result> getEnclosingInstance() {
            return ThrottledStyleBase.this;
        }
    }

    private static class ProfileUpdateIntervalRead
    extends UnaryRead<Resource, Long> {
        public ProfileUpdateIntervalRead(Resource parameter) {
            super((Object)parameter);
        }

        public Long perform(ReadGraph graph) throws DatabaseException {
            Resource configuration = graph.getPossibleObject((Resource)this.parameter, DiagramResource.getInstance((ReadGraph)graph).RuntimeDiagram_HasConfiguration);
            DistrictNetworkResource.getInstance((ReadGraph)graph);
            Long interval = 2000L;
            return interval != null ? interval : 2000L;
        }
    }
}

