/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.profile;

import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.Read;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.district.network.profile.RuntimeDynamicVisualisationsRequest;
import org.simantics.district.network.profile.ThrottledStyleBase;
import org.simantics.district.network.visualisations.DynamicVisualisationsContributions;
import org.simantics.district.network.visualisations.model.DynamicSizeContribution;
import org.simantics.district.network.visualisations.model.DynamicSizeMap;
import org.simantics.district.network.visualisations.model.DynamicVisualisation;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DSceneGraph;
import org.simantics.scenegraph.g2d.nodes.SingleElementNode;
import org.simantics.scenegraph.profile.EvaluationContext;
import org.simantics.scenegraph.profile.common.ProfileVariables;
import org.simantics.scl.runtime.SCLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DNElementSizeStyle
extends ThrottledStyleBase<Double> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DNElementSizeStyle.class);
    private static final boolean DEBUG = false;
    private static final Double PENDING = Double.NaN;
    private static final Double ONE = 1.0;

    @Override
    public Double calculateThrottledStyle(ReadGraph graph, Resource runtimeDiagram, Resource entry, Resource groupItem) throws DatabaseException {
        DynamicVisualisation dv = (DynamicVisualisation)graph.syncRequest((Read)new RuntimeDynamicVisualisationsRequest(runtimeDiagram), (AsyncProcedure)TransientCacheAsyncListener.instance());
        boolean wasSynchronous = graph.setSynchronous(true);
        try {
            if (dv != null) {
                String mappingName;
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
                ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
                Resource mapping = graph.getSingleObject(groupItem, DN.HasMapping);
                Map<String, DynamicSizeContribution> sizeContributions = dv.getSizeContributions();
                DynamicSizeContribution dsc = sizeContributions.get(mappingName = (String)graph.getRelatedValue(mapping, L0.HasName));
                if (dsc != null && dsc.isUsed()) {
                    Resource mappedComponent = graph.getPossibleObject(groupItem, DN.MappedComponent);
                    if (mappedComponent != null) {
                        Resource component = graph.getSingleObject(mappedComponent, MOD.ElementToComponent);
                        Variable variable = Variables.getVariable((ReadGraph)graph, (Resource)component);
                        Variable possibleActiveVariable = Variables.possibleActiveVariable((ReadGraph)graph, (Variable)variable);
                        if (possibleActiveVariable != null) {
                            Variable module = possibleActiveVariable.getPossibleChild(graph, dsc.getModuleName());
                            if (module != null) {
                                Variable attribute = module.getPossibleProperty(graph, dsc.getAttributeName());
                                if (attribute != null) {
                                    Double possibleValue = (Double)attribute.getPossibleValue(graph, (Binding)Bindings.DOUBLE);
                                    if (possibleValue != null) {
                                        double maxValue;
                                        double minValue;
                                        if (dsc.isUseDefault()) {
                                            DynamicVisualisationsContributions.DynamicSizingObject dynamicSizingObject = dv.getDefaultSizeContributions().get(mappingName);
                                            Object currentGraph = SCLContext.getCurrent().get((Object)"graph");
                                            try {
                                                SCLContext.getCurrent().put((Object)"graph", (Object)graph);
                                                DynamicSizeContribution ddcc = dynamicSizingObject.getSizeContributions().get(dsc.getLabel());
                                                minValue = ddcc.getDefaultMin();
                                                maxValue = ddcc.getDefaultMax();
                                            }
                                            finally {
                                                SCLContext.getCurrent().put((Object)"graph", currentGraph);
                                            }
                                        } else {
                                            minValue = dsc.getDefaultMin();
                                            maxValue = dsc.getDefaultMax();
                                        }
                                        double adjustedValue = possibleValue * dsc.getVariableGain() + dsc.getVariableBias();
                                        DynamicSizeMap defaultSizeMap = dsc.getDefaultSizeMap();
                                        double size = defaultSizeMap.getSize(adjustedValue, dv.getSizeBarOptions().isUseGradients(), minValue, maxValue);
                                        Double d = size;
                                        return d;
                                    }
                                    LOGGER.warn("No value for {}", (Object)attribute.getURI(graph));
                                } else {
                                    LOGGER.warn("Wrong attribute name {} for {} !!", (Object)dsc.getAttributeName(), (Object)module.getURI(graph));
                                }
                            } else {
                                LOGGER.warn("Wrong modulename {} for {} !!", (Object)dsc.getModuleName(), (Object)possibleActiveVariable.getURI(graph));
                            }
                        } else {
                            LOGGER.debug("No active experiment for {}", (Object)variable.getURI(graph));
                        }
                    } else {
                        LOGGER.debug("No mapped component for {} to calculate dynamic size style", (Object)groupItem);
                    }
                }
            }
        }
        finally {
            graph.setSynchronous(wasSynchronous);
        }
        return 1.0;
    }

    @Override
    public void applyThrottledStyleForNode(EvaluationContext observer, INode node, Double value) {
        SingleElementNode n = (SingleElementNode)node;
        if (value == PENDING) {
            ((G2DSceneGraph)node.getRootNode()).setPending((Object)node);
        } else {
            ((G2DSceneGraph)node.getRootNode()).clearPending((Object)node);
        }
        if (value == null) {
            value = ONE;
        }
        for (INode nn : n.getNodes()) {
            ProfileVariables.claimNodeProperty((INode)nn, (String)"size", (Object)value, (EvaluationContext)observer);
            ProfileVariables.claimNodeProperty((INode)nn, (String)"stroke", (Object)value, (EvaluationContext)observer);
        }
    }

    protected void cleanupStyleForNode(EvaluationContext evaluationContext, INode node) {
        ((G2DSceneGraph)node.getRootNode()).clearPending((Object)node);
        SingleElementNode n = (SingleElementNode)node;
        for (INode nn : n.getNodes()) {
            ProfileVariables.claimNodeProperty((INode)nn, (String)"size", (Object)ONE, (EvaluationContext)evaluationContext);
            ProfileVariables.claimNodeProperty((INode)nn, (String)"stroke", (Object)ONE, (EvaluationContext)evaluationContext);
        }
    }
}

