/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.profile;

import java.util.Map;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.district.network.profile.MidBranchEdgeSetRequest;
import org.simantics.district.network.profile.RuntimeDynamicVisualisationsRequest;
import org.simantics.district.network.profile.ThrottledStyleBase;
import org.simantics.district.network.visualisations.DynamicVisualisationsContributions;
import org.simantics.district.network.visualisations.model.DynamicArrowContribution;
import org.simantics.district.network.visualisations.model.DynamicVisualisation;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DSceneGraph;
import org.simantics.scenegraph.g2d.nodes.ConnectionNode;
import org.simantics.scenegraph.profile.EvaluationContext;
import org.simantics.scenegraph.profile.common.ProfileVariables;
import org.simantics.scl.runtime.SCLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrowLengthStyle
extends ThrottledStyleBase<Double> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArrowLengthStyle.class);
    private static final Double PENDING = Double.NaN;

    @Override
    public Double calculateThrottledStyle(ReadGraph graph, Resource runtimeDiagram, Resource entry, Resource groupItem) throws DatabaseException {
        Resource diagram = graph.getSingleObject(groupItem, Layer0.getInstance((ReadGraph)graph).PartOf);
        Set edgesToUse = (Set)graph.syncRequest((Read)new MidBranchEdgeSetRequest(diagram), (Listener)TransientCacheListener.instance());
        if (!edgesToUse.contains(groupItem)) {
            return null;
        }
        DynamicVisualisation dv = (DynamicVisualisation)graph.syncRequest((Read)new RuntimeDynamicVisualisationsRequest(runtimeDiagram), (AsyncProcedure)TransientCacheAsyncListener.instance());
        boolean wasSynchronous = graph.setSynchronous(true);
        try {
            if (dv != null) {
                String mappingName;
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
                ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
                Resource mapping = graph.getSingleObject(groupItem, DN.HasMapping);
                Map<String, DynamicArrowContribution> arrowContributions = dv.getArrowContributions();
                DynamicArrowContribution dac = arrowContributions.get(mappingName = (String)graph.getRelatedValue(mapping, L0.HasName));
                if (dac != null && dac.isUsed()) {
                    Resource mappedComponent = graph.getPossibleObject(groupItem, DN.MappedComponent);
                    if (mappedComponent != null) {
                        Resource component = graph.getSingleObject(mappedComponent, MOD.ElementToComponent);
                        Variable variable = Variables.getVariable((ReadGraph)graph, (Resource)component);
                        Variable possibleActiveVariable = Variables.possibleActiveVariable((ReadGraph)graph, (Variable)variable);
                        if (possibleActiveVariable != null) {
                            Variable module = possibleActiveVariable.getPossibleChild(graph, dac.getModuleName());
                            if (module != null) {
                                Variable attribute = module.getPossibleProperty(graph, dac.getAttributeName());
                                if (attribute != null) {
                                    Double possibleValue = (Double)attribute.getPossibleValue(graph, (Binding)Bindings.DOUBLE);
                                    if (possibleValue != null) {
                                        double gainValue;
                                        double biasValue;
                                        if (dac.isUseDefault()) {
                                            DynamicVisualisationsContributions.DynamicArrowObject dynamicArrowObject = dv.getDefaultArrowContributions().get(mappingName);
                                            Object currentGraph = SCLContext.getCurrent().get((Object)"graph");
                                            try {
                                                SCLContext.getCurrent().put((Object)"graph", (Object)graph);
                                                DynamicArrowContribution ddcc = dynamicArrowObject.getArrowContributions().get(dac.getLabel());
                                                biasValue = ddcc.getDefaultBias();
                                                gainValue = ddcc.getDefaultGain();
                                            }
                                            finally {
                                                SCLContext.getCurrent().put((Object)"graph", currentGraph);
                                            }
                                        } else {
                                            biasValue = dac.getDefaultBias();
                                            gainValue = dac.getDefaultGain();
                                        }
                                        Double d = possibleValue * gainValue + biasValue;
                                        return d;
                                    }
                                    LOGGER.warn("No value for {}", (Object)attribute.getURI(graph));
                                } else {
                                    LOGGER.warn("Wrong attribute name {} for {} !!", (Object)dac.getAttributeName(), (Object)module.getURI(graph));
                                }
                            } else {
                                LOGGER.warn("Wrong modulename {} for {} !!", (Object)dac.getModuleName(), (Object)possibleActiveVariable.getURI(graph));
                            }
                        } else {
                            LOGGER.debug("No active experiment for {}", (Object)variable.getURI(graph));
                        }
                    } else {
                        LOGGER.debug("No mapped component for {} to calculate dynamic color style", (Object)groupItem);
                    }
                }
            }
        }
        finally {
            graph.setSynchronous(wasSynchronous);
        }
        return null;
    }

    @Override
    public void applyThrottledStyleForNode(EvaluationContext observer, INode node, Double value) {
        ConnectionNode n = (ConnectionNode)node;
        if (value == PENDING) {
            ((G2DSceneGraph)node.getRootNode()).setPending((Object)node);
        } else {
            ((G2DSceneGraph)node.getRootNode()).clearPending((Object)node);
        }
        for (INode nn : n.getNodes()) {
            ProfileVariables.claimNodeProperty((INode)nn, (String)"arrowLength", (Object)value, (EvaluationContext)observer);
        }
    }

    protected void cleanupStyleForNode(EvaluationContext evaluationContext, INode node) {
        ((G2DSceneGraph)node.getRootNode()).clearPending((Object)node);
        ConnectionNode n = (ConnectionNode)node;
        for (INode nn : n.getNodes()) {
            ProfileVariables.claimNodeProperty((INode)nn, (String)"arrowLength", null, (EvaluationContext)evaluationContext);
        }
    }
}

