/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.profile;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.district.network.visualisations.DynamicVisualisations;
import org.simantics.district.network.visualisations.DynamicVisualisationsContributions;
import org.simantics.district.network.visualisations.model.ColorBarOptions;
import org.simantics.district.network.visualisations.model.DynamicArrowContribution;
import org.simantics.district.network.visualisations.model.DynamicColorContribution;
import org.simantics.district.network.visualisations.model.DynamicSizeContribution;
import org.simantics.district.network.visualisations.model.DynamicVisualisation;
import org.simantics.district.network.visualisations.model.SizeBarOptions;
import org.simantics.layer0.Layer0;

public class ActiveDynamicVisualisationsRequest
extends ResourceRead<DynamicVisualisation> {
    public ActiveDynamicVisualisationsRequest(Resource parent) {
        super(parent);
    }

    public DynamicVisualisation perform(ReadGraph graph) throws DatabaseException {
        Resource visualisationResource;
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        Resource visualisationFolder = DynamicVisualisations.getVisualisationFolder(graph, this.resource);
        if (visualisationFolder != null && (visualisationResource = graph.getPossibleObject(visualisationFolder, DN.Diagram_hasActiveVisualisation)) != null) {
            String name = (String)graph.getRelatedValue(visualisationResource, Layer0.getInstance((ReadGraph)graph).HasName);
            Long interval = (Long)graph.getPossibleRelatedValue(visualisationResource, DN.Diagram_Visualisations_Interval, (Binding)Bindings.LONG);
            Boolean disabledUpdates = (Boolean)graph.getPossibleRelatedValue(visualisationResource, DN.Diagram_Visualisations_DisabledUpdates, (Binding)Bindings.BOOLEAN);
            Boolean resetVisualisation = (Boolean)graph.getPossibleRelatedValue(visualisationResource, DN.Diagram_Visualisations_ResetVisualisation, (Binding)Bindings.BOOLEAN);
            Collection<DynamicVisualisationsContributions.DynamicColoringObject> dynamicColoringObjects = DynamicVisualisationsContributions.dynamicColoringObjects(graph);
            Map<String, DynamicVisualisationsContributions.DynamicColoringObject> defaultColoringObjects = dynamicColoringObjects.stream().collect(Collectors.toMap(dcc -> dcc.getColoringObject().getName(), dcc -> dcc));
            Collection<DynamicVisualisationsContributions.DynamicSizingObject> dynamicSizingObjects = DynamicVisualisationsContributions.dynamicSizingObjects(graph);
            Map<String, DynamicVisualisationsContributions.DynamicSizingObject> defaultSizingObjects = dynamicSizingObjects.stream().collect(Collectors.toMap(dcc -> dcc.getSizingObject().getName(), dcc -> dcc));
            Collection<DynamicVisualisationsContributions.DynamicArrowObject> dynamicArrowObjects = DynamicVisualisationsContributions.dynamicEdgeArrowObjects(graph);
            Map<String, DynamicVisualisationsContributions.DynamicArrowObject> defaultArrowObjects = dynamicArrowObjects.stream().collect(Collectors.toMap(dac -> dac.getArrowObject().getName(), dac -> dac));
            Map<String, DynamicColorContribution> colorContributions = DynamicVisualisations.colorContributions(graph, visualisationResource);
            ColorBarOptions colorBarOptions = DynamicVisualisations.colorBarOptions(graph, visualisationResource);
            Map<String, DynamicSizeContribution> sizeContributions = DynamicVisualisations.sizeContributions(graph, visualisationResource);
            SizeBarOptions sizeBarOptions = DynamicVisualisations.sizeBarOptions(graph, visualisationResource);
            Map<String, DynamicArrowContribution> arrowContributions = DynamicVisualisations.arrowContributions(graph, visualisationResource);
            Boolean hideEdges = (Boolean)graph.getPossibleRelatedValue(visualisationResource, DN.Diagram_Visualisations_HideEdges, (Binding)Bindings.BOOLEAN);
            Boolean hidePoints = (Boolean)graph.getPossibleRelatedValue(visualisationResource, DN.Diagram_Visualisations_HidePoints, (Binding)Bindings.BOOLEAN);
            Boolean hideConsumers = (Boolean)graph.getPossibleRelatedValue(visualisationResource, DN.Diagram_Visualisations_HideConsumers, (Binding)Bindings.BOOLEAN);
            Boolean hideProducers = (Boolean)graph.getPossibleRelatedValue(visualisationResource, DN.Diagram_Visualisations_HideProducers, (Binding)Bindings.BOOLEAN);
            Boolean hideValves = (Boolean)graph.getPossibleRelatedValue(visualisationResource, DN.Diagram_Visualisations_HideValves, (Binding)Bindings.BOOLEAN);
            Boolean hidePumpingStations = (Boolean)graph.getPossibleRelatedValue(visualisationResource, DN.Diagram_Visualisations_HidePumpingStations, (Binding)Bindings.BOOLEAN);
            Boolean staticPropertiesNetworkBranch = (Boolean)graph.getPossibleRelatedValue(visualisationResource, DN.Diagram_Visualisations_StaticPropertiesNetworkBranches, (Binding)Bindings.BOOLEAN);
            Boolean staticProperiesPoints = (Boolean)graph.getPossibleRelatedValue(visualisationResource, DN.Diagram_Visualisations_StaticPropertiesPoints, (Binding)Bindings.BOOLEAN);
            Boolean staticPropertiesConsumers = (Boolean)graph.getPossibleRelatedValue(visualisationResource, DN.Diagram_Visualisations_StaticPropertiesConsumers, (Binding)Bindings.BOOLEAN);
            Boolean dynamicSymbolsProducers = (Boolean)graph.getPossibleRelatedValue(visualisationResource, DN.Diagram_Visualisations_DynamicSymbolsProducers, (Binding)Bindings.BOOLEAN);
            Boolean dynamicSymbolsShutoffValves = (Boolean)graph.getPossibleRelatedValue(visualisationResource, DN.Diagram_Visualisations_DynamicSymbolsShutoffValves, (Binding)Bindings.BOOLEAN);
            Boolean dynamicSymbolsValves = (Boolean)graph.getPossibleRelatedValue(visualisationResource, DN.Diagram_Visualisations_DynamicSymbolsValves, (Binding)Bindings.BOOLEAN);
            Boolean dynamicSymbolsPumpingStations = (Boolean)graph.getPossibleRelatedValue(visualisationResource, DN.Diagram_Visualisations_DynamicSymbolsPumpingStations, (Binding)Bindings.BOOLEAN);
            Boolean keyVariablesVertexHover = (Boolean)graph.getPossibleRelatedValue(visualisationResource, DN.Diagram_Visualisations_KeyVariableVertexHover, (Binding)Bindings.BOOLEAN);
            Boolean keyVariablesEdgesHover = (Boolean)graph.getPossibleRelatedValue(visualisationResource, DN.Diagram_Visualisations_KeyVariableEdgeHover, (Binding)Bindings.BOOLEAN);
            DynamicVisualisation visualisation = new DynamicVisualisation(name, visualisationResource, interval != null ? interval : 2000L, disabledUpdates != null ? disabledUpdates : false, resetVisualisation != null ? resetVisualisation : false, colorContributions, defaultColoringObjects, colorBarOptions, sizeContributions, defaultSizingObjects, sizeBarOptions, defaultArrowObjects, arrowContributions, hideEdges != null ? hideEdges : false, hidePoints != null ? hidePoints : false, hideConsumers != null ? hideConsumers : false, hideProducers != null ? hideProducers : false, hideValves != null ? hideValves : false, hidePumpingStations != null ? hidePumpingStations : false, staticPropertiesNetworkBranch != null ? staticPropertiesNetworkBranch : false, staticProperiesPoints != null ? staticProperiesPoints : false, staticPropertiesConsumers != null ? staticPropertiesConsumers : false, dynamicSymbolsProducers != null ? dynamicSymbolsProducers : false, dynamicSymbolsShutoffValves != null ? dynamicSymbolsShutoffValves : false, dynamicSymbolsValves != null ? dynamicSymbolsValves : false, dynamicSymbolsPumpingStations != null ? dynamicSymbolsPumpingStations : false, keyVariablesVertexHover != null ? keyVariablesVertexHover : false, keyVariablesEdgesHover != null ? keyVariablesEdgesHover : false);
            return visualisation;
        }
        return null;
    }
}

