/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.styles;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.diagram.profile.StyleBase;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.district.network.DistrictNetworkUtil;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.district.network.ui.nodes.DistrictNetworkNodeUtils;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.scenegraph.profile.EvaluationContext;
import org.simantics.scenegraph.profile.Observer;
import org.simantics.scenegraph.profile.common.ProfileVariables;
import org.simantics.scenegraph.utils.GeometryUtils;
import org.simantics.scl.compiler.top.ValueNotFound;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.structural.stubs.StructuralResource2;

public class ConnectionLineStyle
extends StyleBase<List<Point2D>> {
    public List<Point2D> calculateStyle(ReadGraph graph, Resource runtimeDiagram, Resource entry, Resource groupItem) throws DatabaseException {
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        Resource vertex = groupItem;
        if (!graph.isInstanceOf(vertex, DN.Vertex)) {
            return Collections.emptyList();
        }
        double[] coords = (double[])graph.getRelatedValue(vertex, DiagramResource.getInstance((ReadGraph)graph).HasLocation);
        Resource component = DistrictNetworkUtil.getMappedComponentCached((ReadGraph)graph, (Resource)vertex);
        if (component == null) {
            return Collections.emptyList();
        }
        Resource componentType = graph.getPossibleType(component, STR.Component);
        if (componentType == null) {
            return Collections.emptyList();
        }
        Function1<Resource, List<Resource>> fun = ConnectionLineStyle.getConnectedComponentsFunctionCached(graph, componentType);
        if (fun == null) {
            return Collections.emptyList();
        }
        List components = (List)Simantics.applySCLRead((ReadGraph)graph, fun, (Object)component);
        if (components == null || components.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Point2D> result = new ArrayList<Point2D>(components.size() + 1);
        result.add(new Point2D.Double(coords[0], coords[1]));
        for (Resource comp : components) {
            Resource mappingElement;
            Resource e = comp != null ? graph.getPossibleObject(comp, MOD.ComponentToElement) : null;
            Resource resource = mappingElement = e != null ? graph.getPossibleObject(e, DN.MappedFromElement) : null;
            if (mappingElement != null) {
                double[] coords2 = (double[])graph.getRelatedValue(mappingElement, DiagramResource.getInstance((ReadGraph)graph).HasLocation);
                result.add(new Point2D.Double(coords2[0], coords2[1]));
                continue;
            }
            result.add(null);
        }
        return result;
    }

    public void applyStyleForNode(EvaluationContext observer, INode parent, List<Point2D> result) {
        if (result == null || result.size() < 2) {
            ProfileVariables.denyChild((INode)parent, (String)"*", (String)"districtNetworkConnection");
            return;
        }
        ConnectionLineNode node = (ConnectionLineNode)ProfileVariables.claimChild((INode)parent, (String)"*", (String)"districtNetworkConnection", ConnectionLineNode.class, (Observer)observer);
        if (node == null) {
            return;
        }
        node.setPoints(result);
        node.setZIndex(0);
        node.setStrokeWidth(2.0f);
    }

    protected void cleanupStyleForNode(EvaluationContext evaluationContext, INode parent) {
        ProfileVariables.denyChild((INode)parent, (String)"*", (String)"districtNetworkConnection");
    }

    private static Function1<Resource, List<Resource>> getConnectedComponentsFunctionCached(ReadGraph graph, Resource componentType) throws DatabaseException {
        return (Function1)graph.syncRequest((Read)new ConnectedComponentsFunctionRequest(componentType), (Listener)TransientCacheListener.instance());
    }

    private static final class ConnectedComponentsFunctionRequest
    extends ResourceRead<Function1<Resource, List<Resource>>> {
        public ConnectedComponentsFunctionRequest(Resource resource) {
            super(resource);
        }

        public Function1<Resource, List<Resource>> perform(ReadGraph graph) throws DatabaseException {
            Resource actionsModule = Layer0Utils.getPossibleChild((ReadGraph)graph, (Resource)this.resource, (String)"Actions");
            if (actionsModule == null || !graph.isInstanceOf(actionsModule, Layer0.getInstance((ReadGraph)graph).SCLModule)) {
                return null;
            }
            String uri = graph.getURI(actionsModule);
            SCLContext sclContext = SCLContext.getCurrent();
            Object oldGraph = sclContext.get((Object)"graph");
            try {
                sclContext.put((Object)"graph", (Object)graph);
                Function1 function1 = (Function1)SCLOsgi.MODULE_REPOSITORY.getValue(uri, "getConnectedComponents");
                return function1;
            }
            catch (ValueNotFound valueNotFound) {
                return null;
            }
            finally {
                sclContext.put((Object)"graph", oldGraph);
            }
        }
    }

    public static class ConnectionLineNode
    extends G2DNode {
        private static final BasicStroke STROKE = new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{4.0f, 2.0f}, 0.0f);
        private static final Color[] colors = new Color[]{Color.RED, Color.GREEN, Color.BLUE, Color.ORANGE, Color.CYAN, Color.PINK};
        private float strokeWidth;
        private Line2D[] lines;
        private static final long serialVersionUID = 1L;

        public Rectangle2D getBoundsInLocal() {
            return null;
        }

        public Rectangle2D getBoundsInLocal(boolean b) {
            return null;
        }

        public Rectangle2D getBounds() {
            return null;
        }

        public void setStrokeWidth(float w) {
            this.strokeWidth = w;
        }

        public void setPoints(List<Point2D> result) {
            Point2D p0 = DistrictNetworkNodeUtils.calculatePoint2D(result.get(0), null);
            this.lines = new Line2D[result.size() - 1];
            int i = 1;
            while (i < result.size()) {
                Point2D p = result.get(i);
                this.lines[i - 1] = p != null ? new Line2D.Double(p0, DistrictNetworkNodeUtils.calculatePoint2D(p, null)) : null;
                ++i;
            }
        }

        public void render(Graphics2D g2d) {
            if (this.lines == null || this.lines.length == 0) {
                return;
            }
            float scaleRecip = (float)GeometryUtils.getScale((AffineTransform)g2d.getTransform());
            g2d.setStroke(GeometryUtils.scaleStroke((Stroke)STROKE, (float)(this.strokeWidth / scaleRecip)));
            int i = 0;
            while (i < this.lines.length) {
                if (this.lines[i] != null) {
                    g2d.setColor(colors[i % colors.length]);
                    g2d.draw(this.lines[i]);
                }
                ++i;
            }
        }
    }
}

