/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.participants;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Cursor;
import java.util.Collection;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.simantics.db.Resource;
import org.simantics.diagram.ui.DiagramModelHints;
import org.simantics.district.network.ui.adapters.DistrictNetworkVertexElement;
import org.simantics.district.network.ui.internal.Activator;
import org.simantics.district.route.Route;
import org.simantics.district.route.RouteService;
import org.simantics.district.route.RouteServiceListener;
import org.simantics.district.route.Waypoint;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.IMouseCursorContext;
import org.simantics.g2d.canvas.IMouseCursorHandle;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.canvas.impl.HintReflection;
import org.simantics.g2d.canvas.impl.SGNodeReflection;
import org.simantics.g2d.diagram.handler.PickContext;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.diagram.participant.pointertool.AbstractMode;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.participant.TransformUtil;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.events.Event;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.KeyEvent;
import org.simantics.scenegraph.g2d.events.command.Command;
import org.simantics.scenegraph.g2d.events.command.CommandEvent;
import org.simantics.scenegraph.g2d.events.command.Commands;
import org.simantics.scenegraph.g2d.nodes.SingleElementNode;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintObservable;
import org.simantics.utils.ui.AdaptionUtils;
import org.simantics.utils.ui.SWTUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutingMode
extends AbstractMode {
    private static final Logger LOGGER = LoggerFactory.getLogger(RoutingMode.class);
    @DependencyReflection.Dependency
    protected TransformUtil util;
    @DependencyReflection.Dependency
    protected PickContext pickContext;
    @DependencyReflection.Dependency
    protected Selection selection;
    protected IMouseCursorHandle cursor;
    private RouteService routeService;
    private Route route;
    protected G2DParentNode parent;
    protected SingleElementNode node = null;
    private RouteServiceListener routeServiceListener;

    public RoutingMode(int mouseId) {
        super(mouseId);
    }

    public void addedToContext(ICanvasContext ctx) {
        super.addedToContext(ctx);
        IMouseCursorContext mcc = this.getContext().getMouseCursorContext();
        this.cursor = mcc == null ? null : mcc.setCursor(this.mouseId, new Cursor(1));
        this.routeService = Activator.getInstance().getRouteService();
        if (this.routeService != null) {
            this.routeServiceListener = e -> {
                switch (e.type) {
                    case 10: {
                        this.dispose();
                    }
                }
            };
            this.routeService.addListener(this.routeServiceListener);
            Resource diagramResource = (Resource)this.getHint(DiagramModelHints.KEY_DIAGRAM_RESOURCE);
            LOGGER.info("Diagram resource: " + diagramResource);
            this.route = this.routeService.createRoute("[UNPERSISTED] Current", (Object)diagramResource);
            this.routeService.registerRoute(this.route);
        }
    }

    public void removedFromContext(ICanvasContext ctx) {
        if (this.cursor != null) {
            this.cursor.remove();
            this.cursor = null;
        }
        if (this.routeService != null) {
            this.routeService.removeListener(this.routeServiceListener);
            if (this.route != null && !this.route.persisted()) {
                this.routeService.discardRoute(this.route);
                this.route = null;
            }
        }
        super.removedFromContext(ctx);
    }

    @HintReflection.HintListener(Class=Selection.class, Field="SELECTION0")
    public void hintChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
        Collection elements = AdaptionUtils.adaptToCollection((Object)newValue, IElement.class);
        for (IElement element : elements) {
            this.addRoutePoint(element);
        }
    }

    private void addRoutePoint(IElement element) {
        if (this.route == null) {
            return;
        }
        Object o = ElementUtils.getObject((IElement)element);
        if (o instanceof Resource && this.filterAcceptableElement(element, o)) {
            Waypoint wp = this.route.createWaypoint(o);
            this.route.addWaypoint(wp);
        }
    }

    private boolean filterAcceptableElement(IElement element, Object o) {
        ElementClass elementClass = element.getElementClass();
        return elementClass.getId().equals(DistrictNetworkVertexElement.CLASS.getId());
    }

    @SGNodeReflection.SGInit
    public void initSG(G2DParentNode parent) {
        this.parent = parent;
        this.node = (SingleElementNode)parent.addNode("route highlight", SingleElementNode.class);
        this.node.setZIndex(1000);
        this.node.setVisible(Boolean.TRUE);
        this.node.setComposite((Composite)AlphaComposite.SrcOver.derive(0.75f));
    }

    @SGNodeReflection.SGCleanup
    public void cleanupSG() {
        if (this.node != null) {
            this.node.remove();
            this.node = null;
        }
        this.parent = null;
    }

    @EventHandlerReflection.EventHandler(priority=30)
    public boolean handleEvent(Event e) {
        if (e instanceof KeyEvent.KeyPressedEvent) {
            if (this.route == null) {
                return false;
            }
            KeyEvent.KeyPressedEvent kpe = (KeyEvent.KeyPressedEvent)e;
            if (kpe.keyCode == 10) {
                Route committedRoute = this.route;
                this.route = null;
                SWTUtils.asyncExec((Display)Display.getDefault(), () -> this.askRouteNameAndPersist(committedRoute));
                this.dispose();
            }
        } else if (e instanceof CommandEvent) {
            Command cmd = ((CommandEvent)e).command;
            if (cmd.equals((Object)Commands.CANCEL)) {
                if (this.route != null && !this.route.persisted()) {
                    Route committedRoute = this.route;
                    SWTUtils.asyncExec((Display)Display.getDefault(), () -> {
                        if (!this.askDiscardUnpersistedRoute()) {
                            this.askRouteNameAndPersist(committedRoute);
                        }
                    });
                }
                return this.dispose();
            }
            if (cmd.equals((Object)Commands.RENAME)) {
                SWTUtils.asyncExec((Display)Display.getDefault(), () -> {
                    String newName = this.askRouteName("Rename Route", this.route.getName());
                    if (newName != null) {
                        this.route.setName(newName);
                        this.routeService.refreshRoute(this.route);
                    }
                });
            }
        }
        return false;
    }

    private void askRouteNameAndPersist(Route committedRoute) {
        String newName = this.askRouteName("Confirm Route", committedRoute.getName());
        if (newName != null) {
            committedRoute.setName(newName);
            this.routeService.persistRoute(committedRoute);
        } else {
            this.routeService.discardRoute(committedRoute);
        }
    }

    private boolean askDiscardUnpersistedRoute() {
        MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Discard route", null, "Discard current unpersisted route?", 2, 0, new String[]{"OK", "Cancel"});
        return dialog.open() == 0;
    }

    private String askRouteName(String dialogTitle, String initialValue) {
        InputDialog dialog = new InputDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), dialogTitle, "Route name", initialValue, s -> s.trim().length() > 0 ? null : "Name must be non-empty");
        if (dialog.open() == 0) {
            return dialog.getValue();
        }
        return null;
    }

    protected boolean dispose() {
        this.setDirty();
        this.remove();
        return false;
    }

    static class RenameDialog
    extends InputDialog {
        public RenameDialog(Shell parent, String title, String message, String initialValue, IInputValidator validator) {
            super(parent, title, message, initialValue, validator);
        }

        protected IDialogSettings getDialogBoundsSettings() {
            String sectionName = String.valueOf(((Object)((Object)this)).getClass().getName()) + "_dialogBounds";
            IDialogSettings settings = Activator.getInstance().getDialogSettings();
            IDialogSettings section = settings.getSection(sectionName);
            if (section == null) {
                section = settings.addNewSection(sectionName);
            }
            return section;
        }

        protected int getDialogBoundsStrategy() {
            return 1;
        }
    }
}

