/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.participants;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.district.network.profile.RuntimeDynamicVisualisationsRequest;
import org.simantics.district.network.ui.DistrictDiagramViewer;
import org.simantics.district.network.ui.nodes.DeferredRenderingNode;
import org.simantics.district.network.ui.nodes.DistrictNetworkEdgeArrayNode;
import org.simantics.district.network.ui.nodes.DistrictNetworkHoverInfoNode;
import org.simantics.district.network.ui.nodes.DynamicVisualisationContributionsNode;
import org.simantics.district.network.ui.styles.DistrictNetworkHoverInfoStyle;
import org.simantics.district.network.visualisations.model.ColorBarOptions;
import org.simantics.district.network.visualisations.model.DynamicColorContribution;
import org.simantics.district.network.visualisations.model.DynamicSizeContribution;
import org.simantics.district.network.visualisations.model.DynamicVisualisation;
import org.simantics.district.network.visualisations.model.SizeBarOptions;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.AbstractCanvasParticipant;
import org.simantics.g2d.canvas.impl.SGNodeReflection;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.command.CommandEvent;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.datastructures.hints.HintListenerAdapter;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintListener;
import org.simantics.utils.datastructures.hints.IHintObservable;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicVisualisationContributionsParticipant
extends AbstractCanvasParticipant {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicVisualisationContributionsParticipant.class);
    IHintListener hintListener = new HintListenerAdapter(){

        public void hintChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
            ICanvasContext cc = DynamicVisualisationContributionsParticipant.this.getContext();
            if (cc != null) {
                DynamicVisualisationContributionsParticipant.this.updateNode();
                cc.getContentContext().setDirty();
            }
        }
    };
    private DynamicVisualisationContributionsNode node;
    private AffineTransform transform;
    private DistrictNetworkHoverInfoNode hoverInfoNode;
    private DeferredRenderingNode deferredEdgeArrowRendererNode;
    private ScheduledFuture<?> hoverUpdateSchedule;
    private static final Object COMPLETE = new Object();

    public DynamicVisualisationContributionsParticipant(AffineTransform tr) {
        this.transform = tr;
    }

    public void addedToContext(ICanvasContext ctx) {
        super.addedToContext(ctx);
        this.getHintStack().addKeyHintListener(this.getThread(), DistrictDiagramViewer.KEY_MAP_COLORING_OBJECTS, this.hintListener);
        this.getHintStack().addKeyHintListener(this.getThread(), DistrictDiagramViewer.KEY_MAP_COLOR_BAR_OPTIONS, this.hintListener);
        this.getHintStack().addKeyHintListener(this.getThread(), DistrictDiagramViewer.KEY_MAP_SIZING_OBJECTS, this.hintListener);
        this.getHintStack().addKeyHintListener(this.getThread(), DistrictDiagramViewer.KEY_MAP_SIZE_BAR_OPTIONS, this.hintListener);
    }

    public void removedFromContext(ICanvasContext ctx) {
        if (this.hoverUpdateSchedule != null && !this.hoverUpdateSchedule.isDone()) {
            this.hoverUpdateSchedule.cancel(false);
        }
        this.getHintStack().removeKeyHintListener(this.getThread(), DistrictDiagramViewer.KEY_MAP_COLORING_OBJECTS, this.hintListener);
        this.getHintStack().removeKeyHintListener(this.getThread(), DistrictDiagramViewer.KEY_MAP_COLOR_BAR_OPTIONS, this.hintListener);
        this.getHintStack().removeKeyHintListener(this.getThread(), DistrictDiagramViewer.KEY_MAP_SIZING_OBJECTS, this.hintListener);
        this.getHintStack().removeKeyHintListener(this.getThread(), DistrictDiagramViewer.KEY_MAP_SIZE_BAR_OPTIONS, this.hintListener);
        super.removedFromContext(ctx);
    }

    @SGNodeReflection.SGInit
    public void initSG(G2DParentNode parent) {
        this.node = (DynamicVisualisationContributionsNode)((Object)parent.addNode("dynamicVisualisationContributionsNode", DynamicVisualisationContributionsNode.class));
        this.node.setTransform(this.transform);
        this.node.setEnabled(true);
        this.node.setZIndex(1000);
        this.hoverInfoNode = (DistrictNetworkHoverInfoNode)parent.addNode("districtNetworkHoverInfoNode", DistrictNetworkHoverInfoNode.class);
        this.hoverInfoNode.setLookupId("districtNetworkHoverInfoNode");
        this.hoverInfoNode.setTransform(this.transform);
        this.hoverInfoNode.setZIndex(2147483147);
        Pair<String, Class<DeferredRenderingNode>> dearn = DistrictNetworkEdgeArrayNode.renderer();
        this.deferredEdgeArrowRendererNode = (DeferredRenderingNode)((Object)parent.addNode((String)dearn.first, (Class)dearn.second));
    }

    @EventHandlerReflection.EventHandler(priority=0)
    protected boolean handleKeyEvent(CommandEvent e) {
        if (e.command.equals((Object)DistrictDiagramViewer.MAP_COLOR_BAR_OPTIONS_CHANGE)) {
            System.out.println(e);
            return true;
        }
        return false;
    }

    protected void updateNode() {
        this.node.setDynamicColoringObjects(this.getDynamicColoringObjects());
        this.node.setColorBarOptions(this.getColorBarOptions());
        this.node.setDynamicSizingObjects(this.getDynamicSizingObjects());
        this.node.setSizeBarOptions(this.getSizeBarOptions());
    }

    private Map<String, DynamicColorContribution> getDynamicColoringObjects() {
        return (Map)this.getHint(DistrictDiagramViewer.KEY_MAP_COLORING_OBJECTS);
    }

    private ColorBarOptions getColorBarOptions() {
        return (ColorBarOptions)this.getHint(DistrictDiagramViewer.KEY_MAP_COLOR_BAR_OPTIONS);
    }

    private Map<String, DynamicSizeContribution> getDynamicSizingObjects() {
        return (Map)this.getHint(DistrictDiagramViewer.KEY_MAP_SIZING_OBJECTS);
    }

    private SizeBarOptions getSizeBarOptions() {
        return (SizeBarOptions)this.getHint(DistrictDiagramViewer.KEY_MAP_SIZE_BAR_OPTIONS);
    }

    public void hoverNode(final Resource runtimeDiagram, final Resource mapElement, final INode hoveredNode, final int zoomLevel) {
        final IThreadWorkQueue thread = this.getThread();
        Simantics.getSession().asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                DynamicVisualisation visualisation = (DynamicVisualisation)graph.syncRequest((Read)new RuntimeDynamicVisualisationsRequest(runtimeDiagram));
                if (visualisation == null) {
                    return;
                }
                DynamicVisualisationContributionsParticipant.this.cancelCurrentHoverUpdate();
                DynamicVisualisationContributionsParticipant.this.hoverUpdateSchedule = ThreadUtils.getNonBlockingWorkExecutor().scheduleWithFixedDelay(() -> DynamicVisualisationContributionsParticipant.this.updateHoverInfo(runtimeDiagram, mapElement, hoveredNode, zoomLevel, visualisation, thread), 0L, visualisation.getInterval(), TimeUnit.MILLISECONDS);
            }
        });
    }

    private void updateHoverInfo(final Resource runtimeDiagram, final Resource mapElement, final INode hoveredNode, final int zoomLevel, final DynamicVisualisation visualisation, final IThreadWorkQueue thread) {
        final CompletableFuture future = new CompletableFuture();
        try {
            Simantics.getSession().syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    Set mapElementTypes = graph.getTypes(mapElement);
                    if (mapElementTypes.isEmpty()) {
                        future.complete(COMPLETE);
                        return;
                    }
                    DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
                    boolean doHover = mapElementTypes.contains(DN.Vertex) && visualisation.isKeyVariablesVertexHover() || mapElementTypes.contains(DN.Edge) && visualisation.isKeyVariablesEdgesHover();
                    DistrictNetworkHoverInfoStyle.StyleResult results = DistrictNetworkHoverInfoStyle.doCalculateStyleResult(graph, runtimeDiagram, mapElement);
                    if (results != null) {
                        Point2D location = DistrictNetworkHoverInfoStyle.calculatePoint(hoveredNode, zoomLevel, null);
                        thread.asyncExec(() -> {
                            if (DynamicVisualisationContributionsParticipant.this.isRemoved()) {
                                return;
                            }
                            if (doHover) {
                                DynamicVisualisationContributionsParticipant.this.hoverInfoNode.setLabels(results.getLabels());
                                DynamicVisualisationContributionsParticipant.this.hoverInfoNode.setOrigin(results.getOrigin());
                                DynamicVisualisationContributionsParticipant.this.hoverInfoNode.setMousePosition(location);
                                DynamicVisualisationContributionsParticipant.this.hoverInfoNode.setHoveredNode(hoveredNode);
                            } else {
                                DynamicVisualisationContributionsParticipant.this.hoverInfoNode.setHoveredNode(null);
                            }
                            future.complete(COMPLETE);
                        });
                    } else {
                        future.complete(COMPLETE);
                    }
                }
            });
        }
        catch (DatabaseException e) {
            future.completeExceptionally(e);
        }
        try {
            future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.debug("Interrupted hovering", (Throwable)e);
        }
    }

    public boolean doHover(boolean hover, boolean isConnectionTool) {
        if (!hover) {
            this.cancelCurrentHoverUpdate();
        }
        return this.hoverInfoNode.hover(hover, isConnectionTool);
    }

    private void cancelCurrentHoverUpdate() {
        if (this.hoverUpdateSchedule != null && !this.hoverUpdateSchedule.isDone()) {
            this.hoverUpdateSchedule.cancel(false);
        }
    }
}

