/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.nodes;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import org.simantics.district.network.ui.nodes.DistrictNetworkNodeUtils;
import org.simantics.district.network.ui.nodes.DistrictRenderingHints;
import org.simantics.maps.MapScalingTransform;
import org.simantics.scenegraph.g2d.nodes.UnboundedNode;

public class DistrictRenderingPreparationNode
extends UnboundedNode {
    private static final long serialVersionUID = 6891204351705486193L;

    public boolean validate() {
        return true;
    }

    public void render(Graphics2D g2d) {
        AffineTransform ot = g2d.getTransform();
        double scale = DistrictNetworkNodeUtils.getScale(ot);
        double scaleRecip = DistrictNetworkNodeUtils.calculateScaleRecip(ot);
        int zoomLevel = MapScalingTransform.zoomLevel((AffineTransform)ot);
        g2d.setRenderingHint(DistrictRenderingHints.KEY_VIEW_SCALE_UNDER_SPATIAL_ROOT, scale);
        g2d.setRenderingHint(DistrictRenderingHints.KEY_VIEW_SCALE_RECIPROCAL_UNDER_SPATIAL_ROOT, scaleRecip);
        g2d.setRenderingHint(DistrictRenderingHints.KEY_VIEW_ZOOM_LEVEL, zoomLevel);
    }
}

