/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.maps.tile;

import java.awt.Image;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.simantics.maps.tile.IFilter;
import org.simantics.maps.tile.ITileJobQueue;
import org.simantics.maps.tile.ITileListener;
import org.simantics.maps.tile.TileKey;

public class TileCache
implements ITileListener {
    private final ITileJobQueue job;
    private Map<Integer, LevelCache> levels = new HashMap<Integer, LevelCache>();
    private List<ITileListener> tileListeners = new ArrayList<ITileListener>();

    public TileCache(ITileJobQueue job) {
        this.job = job;
    }

    public void addTileListener(ITileListener l) {
        this.tileListeners.add(l);
    }

    public void removeTileListener(ITileListener l) {
        this.tileListeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LevelCache getLevel(int l, boolean create) {
        Map<Integer, LevelCache> map = this.levels;
        synchronized (map) {
            LevelCache level = this.levels.get(l);
            if (level == null && create) {
                level = new LevelCache();
                this.levels.put(l, level);
            }
            return level;
        }
    }

    public Image get(TileKey key) {
        LevelCache level = this.getLevel(key.getLevel(), true);
        Image image = level.get(key);
        if (image == null) {
            this.job.addJob(key, this);
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image peek(TileKey key) {
        LevelCache level = this.getLevel(key.getLevel(), false);
        if (level == null) {
            return null;
        }
        LevelCache levelCache = level;
        synchronized (levelCache) {
            return level.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void flush(TileKey key) {
        LevelCache level = this.getLevel(key.getLevel(), false);
        if (level != null) {
            LevelCache levelCache = level;
            synchronized (levelCache) {
                level.remove(key);
            }
        }
    }

    public void filterJobQueue(IFilter<TileKey> filter) {
        this.job.filterQueries(filter);
    }

    @Override
    public void tileCanceled(TileKey key) {
        for (ITileListener l : this.tileListeners) {
            l.tileCanceled(key);
        }
    }

    @Override
    public void tileFailed(TileKey key, Throwable e) {
        for (ITileListener l : this.tileListeners) {
            l.tileFailed(key, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tileUpdated(TileKey key, Image image) {
        LevelCache level;
        LevelCache levelCache = level = this.getLevel(key.getLevel(), true);
        synchronized (levelCache) {
            level.put(key, image);
        }
        for (ITileListener l : this.tileListeners) {
            l.tileUpdated(key, image);
        }
    }

    public static class LevelCache {
        private Map<TileKey, SoftReference<Image>> cache = new HashMap<TileKey, SoftReference<Image>>();

        public Image get(TileKey key) {
            SoftReference<Image> ref = this.cache.get(key);
            if (ref == null) {
                return null;
            }
            return ref.get();
        }

        public void put(TileKey key, Image value) {
            this.cache.put(key, new SoftReference<Image>(value));
        }

        public void remove(TileKey key) {
            this.cache.remove(key);
        }
    }
}

