/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.maps.debug;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.net.URI;
import java.net.URISyntaxException;
import org.simantics.maps.ProvisionException;
import org.simantics.maps.internal.ImageUtil;
import org.simantics.maps.tile.ITileProvider;
import org.simantics.maps.tile.TileKey;

public class DebugTileProvider
implements ITileProvider {
    private final Rectangle2D EXTENT = new Rectangle2D.Double(-180.0, -90.0, 360.0, 180.0);
    private int tileSize;
    private URI source;

    public DebugTileProvider(int tileSize) {
        this.tileSize = tileSize;
        try {
            this.source = new URI("debug://localhost");
        }
        catch (URISyntaxException e) {
            throw new Error("Should never happen", e);
        }
    }

    @Override
    public URI getSource() {
        return this.source;
    }

    @Override
    public Rectangle2D getExtent() {
        return (Rectangle2D)this.EXTENT.clone();
    }

    @Override
    public Image get(TileKey key) throws ProvisionException {
        int level = key.getLevel();
        int x = key.getX();
        int y = key.getY();
        double xTiles = Math.pow(2.0, level + 1);
        double yTiles = Math.pow(2.0, level);
        if (level < 0) {
            throw new IllegalArgumentException("invalid tile level " + level + " (tile=" + key + ")");
        }
        if (x < 0 || x >= (int)xTiles) {
            throw new IllegalArgumentException("tile x out of bounds " + x + " (tile=" + key + ")");
        }
        if (y < 0 || y >= (int)yTiles) {
            throw new IllegalArgumentException("tile y out of bounds " + y + " (tile=" + key + ")");
        }
        Rectangle2D.Double r = new Rectangle2D.Double();
        double minx = -180.0;
        double miny = -90.0;
        double w = 360.0;
        double h = 180.0;
        double xdelta = w / xTiles;
        double ydelta = h / yTiles;
        double xx = x;
        double yy = yTiles - (double)y - 1.0;
        r.setFrame(minx + xdelta * xx, miny + ydelta * yy, xdelta, ydelta);
        BufferedImage image = ImageUtil.createScreenCompatibleImage(this.tileSize, this.tileSize, 1);
        Graphics2D g = image.createGraphics();
        try {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g.setFont(new Font("SansSerif", 1, 16));
            g.setColor(Color.BLACK);
            g.fillRect(0, 0, this.tileSize, this.tileSize);
            g.setColor(Color.LIGHT_GRAY);
            g.fillRect(1, 1, this.tileSize - 1, this.tileSize - 1);
            g.setColor(Color.BLACK);
            this.drawCenteredString(g, String.valueOf(this.tileSize) + "x" + this.tileSize, this.tileSize, this.tileSize / 2 - 50);
            this.drawCenteredString(g, "(" + x + ", " + y + ")(" + level + ")", this.tileSize, this.tileSize / 2 + 50);
            this.drawCenteredString(g, String.valueOf(r.getMaxY()), this.tileSize, 50);
            this.drawCenteredString(g, String.valueOf(r.getMinY()), this.tileSize, 500);
            g.drawString(String.valueOf(r.getMinX()), 20, this.tileSize / 2);
            g.drawString(String.valueOf(r.getMaxX()), 412, this.tileSize / 2);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
            BufferedImage bufferedImage = image;
            return bufferedImage;
        }
        finally {
            g.dispose();
        }
    }

    private void drawCenteredString(Graphics2D g, String str, int width, int y) {
        FontMetrics metrics = g.getFontMetrics();
        Rectangle2D r2d = metrics.getStringBounds(str, g);
        g.drawString(str, (int)((double)(width / 2) - r2d.getWidth() / 2.0), y);
    }
}

