/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.imports;

import com.vividsolutions.jts.index.quadtree.Quadtree;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.referencing.CRS;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.request.Write;
import org.simantics.district.imports.CSVImportModel;
import org.simantics.district.network.DNEdgeBuilder;
import org.simantics.district.network.DistrictNetworkUtil;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistrictImportUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DistrictImportUtils.class);

    private DistrictImportUtils() {
    }

    public static Resource importCSVAsLayer(Path csvFile) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (CSVParser parser = CSVFormat.DEFAULT.withFirstRecordAsHeader().parse((Reader)Files.newBufferedReader(csvFile));){
            Map header = parser.getHeaderMap();
            System.out.println(header);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return null;
    }

    public static Map<String, Integer> readCSVHeader(Path source, char delimiter, boolean firstAsHeader) throws IOException {
        return DistrictImportUtils.readCSVHeader(source, CSVFormat.newFormat((char)delimiter), firstAsHeader);
    }

    public static Map<String, Integer> readCSVHeader(Path source, CSVFormat format, boolean firstAsHeader) throws IOException {
        if (firstAsHeader) {
            format = format.withFirstRecordAsHeader();
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (CSVParser parser = format.parse((Reader)Files.newBufferedReader(source));){
            return parser.getHeaderMap();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static Map<String, Character> getSupportedCSVDelimiterFormats() {
        HashMap<String, Character> delimiters = new HashMap<String, Character>();
        delimiters.put("Comma", Character.valueOf(','));
        delimiters.put("Semicolon", Character.valueOf(';'));
        delimiters.put("Tabulator", Character.valueOf('\t'));
        return delimiters;
    }

    public static List<Map<String, String>> readRows(Path source, CSVFormat format, boolean firstAsHeader, int amount) throws IOException {
        if (firstAsHeader) {
            format = format.withFirstRecordAsHeader();
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try (CSVParser parser = format.parse((Reader)Files.newBufferedReader(source));){
            int start = 0;
            ArrayList<Map<String, String>> results = new ArrayList<Map<String, String>>(amount);
            Iterator iter = parser.iterator();
            while (start < amount && iter.hasNext()) {
                CSVRecord record = (CSVRecord)iter.next();
                results.add(record.toMap());
                ++start;
            }
            return results;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static List<CSVRecord> readRows(Path source, char delim, boolean firstAsHeader, int rowAmount) throws IOException {
        ArrayList<CSVRecord> results = new ArrayList<CSVRecord>();
        AtomicInteger count = new AtomicInteger(0);
        DistrictImportUtils.consumeCSV(source, delim, firstAsHeader, t -> {
            results.add((CSVRecord)t);
            int current = count.incrementAndGet();
            if (current < rowAmount) {
                return true;
            }
            return false;
        });
        return results;
    }

    public static void consumeCSV(Path source, char delim, boolean firstAsHeader, Function<CSVRecord, Boolean> consumer) throws IOException {
        CSVFormat format = CSVFormat.newFormat((char)delim);
        if (firstAsHeader) {
            format = format.withFirstRecordAsHeader();
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try (CSVParser parser = format.parse((Reader)Files.newBufferedReader(source));){
            Iterator records = parser.iterator();
            while (records.hasNext()) {
                Boolean cont = consumer.apply((CSVRecord)records.next());
                if (cont.booleanValue()) continue;
                break;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static Map<CSVHeader, List<String>> readCSVHeaderAndRows(Path source, char delimiter, boolean firstAsHeader, int amount) throws IOException {
        HashMap<CSVHeader, List<String>> results = new HashMap<CSVHeader, List<String>>();
        CSVFormat format = CSVFormat.newFormat((char)delimiter);
        if (firstAsHeader) {
            format = format.withFirstRecordAsHeader();
        }
        Throwable throwable = null;
        Object var7_8 = null;
        try (CSVParser parser = format.parse((Reader)Files.newBufferedReader(source));){
            Map headers = parser.getHeaderMap();
            if (headers != null && !headers.isEmpty()) {
                int index = 0;
                while (index < headers.size()) {
                    for (String head : headers.keySet()) {
                        results.put(new CSVHeader(head, index), new ArrayList());
                    }
                    ++index;
                }
            }
            Iterator records = parser.iterator();
            int rows = 0;
            while (rows < amount && records.hasNext()) {
                CSVRecord record = (CSVRecord)records.next();
                int j = 0;
                while (j < record.size()) {
                    String value = record.get(j);
                    String header = Integer.toString(j);
                    CSVHeader csvHeader = new CSVHeader(header, j);
                    ArrayList<String> vals = (ArrayList<String>)results.get(csvHeader);
                    if (vals == null) {
                        vals = new ArrayList<String>();
                        results.put(csvHeader, vals);
                    }
                    vals.add(value);
                    ++j;
                }
                ++rows;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return results;
    }

    public static Collection<String> readDistinctValuesOfColumn(Path source, char delim, int mappingIndex) throws IOException {
        HashSet<String> results = new HashSet<String>();
        CSVFormat format = CSVFormat.newFormat((char)delim);
        Throwable throwable = null;
        Object var6_7 = null;
        try (CSVParser parser = format.parse((Reader)Files.newBufferedReader(source));){
            Iterator records = parser.iterator();
            if (records.hasNext()) {
                records.next();
            }
            while (records.hasNext()) {
                CSVRecord row = (CSVRecord)records.next();
                String value = row.get(mappingIndex);
                results.add(value);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return results;
    }

    public static void importVertices(final CSVImportModel model) throws NoSuchAuthorityCodeException, FactoryException, DatabaseException {
        final Path csvFile = model.getSource();
        final char delim = model.getDelimiter();
        final int xCoordColumnIndex = model.getXCoordIndex();
        final int yCoordColumnIndex = model.getYCoordIndex();
        final int zCoordColumnIndex = model.getZCoordIndex();
        final int altElevationIndex = model.getAlternativeElevationIndex();
        final int supplyTempColumnIndex = model.getSupplyTempIndex();
        final int returnTempColumnIndex = model.getReturnTempIndex();
        final int supplyPressureColumnIndex = model.getSupplyPressureIndex();
        final int returnPressureColumnIndex = model.getReturnPressureIndex();
        final int dpIndex = model.getDeltaPressureIndex();
        final int dtIndex = model.getDeltaTemperatureIndex();
        final int heatPowerIndex = model.getHeatPowerIndex();
        final int peakPowerIndex = model.getPeakPowerIndex();
        final int valvePositionIndex = model.getValvePositionIndx();
        final int nominalHeadMIndex = model.getNominalHeadMIndex();
        final int nominalHeadBIndex = model.getNominalHeadBIndex();
        final int nominalFlowIndex = model.getNominalFlowIndex();
        final int maximumHeadMIndex = model.getMaximumHeadMIndex();
        final int heatLoadDsIndex = model.getHeatLoadDsIndex();
        final int massFlowIndex = model.getMassFlowIndex();
        final int volFlowIndex = model.getVolFlowIndex();
        final int velocityIndex = model.getVelocityIndex();
        final int flowAreaIndex = model.getFlowAreaIndex();
        final int nominalPressureLossIndex = model.getNominalPressureLossIndex();
        final int addressIndex = model.getAddressIndex();
        final int regionIndex = model.getRegionIndex();
        final int mappingColumn = model.getComponentMappingIndex();
        final int idColumn = model.getIdIndex();
        String sourceEPSGCRS = model.getSourceCRS();
        MathTransform transform = null;
        boolean doTransform = false;
        if (sourceEPSGCRS != null && !sourceEPSGCRS.isEmpty()) {
            CoordinateReferenceSystem sourceCRS = CRS.decode((String)sourceEPSGCRS);
            CoordinateReferenceSystem targetCRS = CRS.decode((String)"EPSG:4326");
            transform = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS, (boolean)true);
            doTransform = true;
        }
        final boolean actualDoTransform = doTransform;
        final MathTransform actualTransform = transform;
        Simantics.getSession().syncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                try {
                    try {
                        Layer0Utils.setDependenciesIndexingDisabled((WriteOnlyGraph)graph, (boolean)true);
                        graph.markUndoPoint();
                        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
                        DistrictImportUtils.consumeCSV(csvFile, delim, true, row -> {
                            try {
                                double[] coords;
                                String zs;
                                String mappingValue = row.get(mappingColumn);
                                String xCoords = row.get(xCoordColumnIndex);
                                String yCoords = row.get(yCoordColumnIndex);
                                double xCoord = Double.parseDouble(xCoords);
                                double yCoord = Double.parseDouble(yCoords);
                                double z = 0.0;
                                if (zCoordColumnIndex != -1 && !(zs = row.get(zCoordColumnIndex)).isEmpty()) {
                                    try {
                                        z = Double.parseDouble(zs);
                                    }
                                    catch (NumberFormatException e1) {
                                        throw new DatabaseException((Throwable)e1);
                                    }
                                }
                                if (actualDoTransform) {
                                    DirectPosition2D targetPos = new DirectPosition2D();
                                    DirectPosition2D sourcePos = new DirectPosition2D(xCoord, yCoord);
                                    DirectPosition res = actualTransform.transform((DirectPosition)sourcePos, (DirectPosition)targetPos);
                                    coords = res.getCoordinate();
                                } else {
                                    coords = new double[]{xCoord, yCoord};
                                }
                                DistrictImportUtils.flipAxes(coords);
                                Resource vertex = DistrictNetworkUtil.createVertex((WriteGraph)graph, (Resource)model.getParentDiagram(), (double[])coords, (double)z, (Resource)model.getComponentMappings().get(mappingValue));
                                DistrictImportUtils.writeStringValue(graph, row, idColumn, vertex, districtNetworkResource.HasId);
                                DistrictImportUtils.writeValue(graph, row, altElevationIndex, vertex, districtNetworkResource.Vertex_HasAltElevation);
                                DistrictImportUtils.writeValue(graph, row, supplyTempColumnIndex, vertex, districtNetworkResource.Vertex_HasSupplyTemperature);
                                DistrictImportUtils.writeValue(graph, row, returnTempColumnIndex, vertex, districtNetworkResource.Vertex_HasReturnTemperature);
                                DistrictImportUtils.writeValue(graph, row, supplyPressureColumnIndex, vertex, districtNetworkResource.Vertex_HasSupplyPressure);
                                DistrictImportUtils.writeValue(graph, row, returnPressureColumnIndex, vertex, districtNetworkResource.Vertex_HasReturnPressure);
                                DistrictImportUtils.writeValue(graph, row, dpIndex, vertex, districtNetworkResource.Vertex_HasDeltaPressure);
                                DistrictImportUtils.writeValue(graph, row, dtIndex, vertex, districtNetworkResource.Vertex_HasDeltaTemperature);
                                DistrictImportUtils.writeValue(graph, row, heatPowerIndex, vertex, districtNetworkResource.Vertex_HasHeatPower);
                                DistrictImportUtils.writeValue(graph, row, peakPowerIndex, vertex, districtNetworkResource.Vertex_HasPeakPower);
                                DistrictImportUtils.writeValue(graph, row, valvePositionIndex, vertex, districtNetworkResource.Vertex_HasValvePosition);
                                DistrictImportUtils.writeValue(graph, row, nominalHeadMIndex, vertex, districtNetworkResource.Vertex_HasNominalHeadM);
                                DistrictImportUtils.writeValue(graph, row, nominalHeadBIndex, vertex, districtNetworkResource.Vertex_HasNominalHeadB);
                                DistrictImportUtils.writeValue(graph, row, nominalFlowIndex, vertex, districtNetworkResource.Vertex_HasNominalFlow);
                                DistrictImportUtils.writeValue(graph, row, maximumHeadMIndex, vertex, districtNetworkResource.Vertex_HasMaximumHeadM);
                                DistrictImportUtils.writeValue(graph, row, heatLoadDsIndex, vertex, districtNetworkResource.Vertex_HasHeatLoadDs);
                                DistrictImportUtils.writeValue(graph, row, massFlowIndex, vertex, districtNetworkResource.Vertex_HasMassFlow);
                                DistrictImportUtils.writeValue(graph, row, volFlowIndex, vertex, districtNetworkResource.Vertex_HasVolFlow);
                                DistrictImportUtils.writeValue(graph, row, velocityIndex, vertex, districtNetworkResource.Vertex_HasVelocity);
                                DistrictImportUtils.writeValue(graph, row, flowAreaIndex, vertex, districtNetworkResource.Vertex_HasFlowArea);
                                DistrictImportUtils.writeValue(graph, row, nominalPressureLossIndex, vertex, districtNetworkResource.Vertex_HasNominalPressureLoss);
                                DistrictImportUtils.writeStringValue(graph, row, addressIndex, vertex, districtNetworkResource.Vertex_HasAddress);
                                DistrictImportUtils.writeStringValue(graph, row, regionIndex, vertex, districtNetworkResource.HasRegion);
                            }
                            catch (MismatchedDimensionException | TransformException | DatabaseException e) {
                                throw new RuntimeException(e);
                            }
                            return true;
                        });
                    }
                    catch (IOException e) {
                        LOGGER.error("Could not import", (Throwable)e);
                        throw new DatabaseException((Throwable)e);
                    }
                }
                finally {
                    Layer0Utils.setDependenciesIndexingDisabled((WriteOnlyGraph)graph, (boolean)false);
                }
            }
        });
    }

    public static void importEdges(final CSVImportModel model) throws NoSuchAuthorityCodeException, FactoryException, DatabaseException {
        final Path csvFile = model.getSource();
        final char delim = model.getDelimiter();
        final HashSet writtenIds = new HashSet();
        final int startXCoordColumnIndex = model.getStartXCoordIndex();
        final int startYCoordColumnIndex = model.getStartYCoordIndex();
        final int startZValueColumnIndex = model.getStartZCoordIndex();
        final int endXCoordColumnIndex = model.getEndXCoordIndex();
        final int endYCoordColumnIndex = model.getEndYCoordIndex();
        final int endZValueColumnIndex = model.getEndZCoordIndex();
        final int diameterColumnIndex = model.getDiameterIndex();
        final int outerDiameterColumnIndex = model.getOuterDiamterIndex();
        final int nominalMassFlowIndex = model.getNominalMassFlowIndex();
        final int tGroundIndex = model.gettGroundIndex();
        final int edgeFlowAreaIndex = model.getEdgeFlowAreaIndex();
        final int kReturnIndex = model.getkReturnIndex();
        final int kSupplyIndex = model.getkSupplyIndex();
        final int lengthIndex = model.getLengthIndex();
        final int detailedGeometryIndex = model.getDetailedGeometryIndex();
        final int regionIndex = model.getRegionIndex();
        final int mappingColumn = model.getComponentMappingIndex();
        final int idColumn = model.getIdIndex();
        final double padding = model.getEdgePadding();
        String sourceEPSGCRS = model.getSourceCRS();
        MathTransform transform = null;
        boolean doTransform = false;
        if (sourceEPSGCRS != null && !sourceEPSGCRS.isEmpty()) {
            CoordinateReferenceSystem sourceCRS = CRS.decode((String)sourceEPSGCRS);
            CoordinateReferenceSystem targetCRS = CRS.decode((String)"EPSG:4326");
            transform = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS, (boolean)true);
            doTransform = true;
        }
        final boolean actualDoTransform = doTransform;
        final MathTransform actualTransform = transform;
        double halfPadding = padding / 2.0;
        final Quadtree existingVertices = DistrictNetworkUtil.existingVertices((Resource)model.getParentDiagram(), (Double)halfPadding);
        Simantics.getSession().syncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                try {
                    try {
                        Layer0Utils.setDependenciesIndexingDisabled((WriteOnlyGraph)graph, (boolean)true);
                        graph.markUndoPoint();
                        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
                        DistrictImportUtils.consumeCSV(csvFile, delim, true, row -> {
                            try {
                                String idValue = row.get(idColumn);
                                if (!writtenIds.contains(idValue)) {
                                    double[] endCoords;
                                    double[] startCoords;
                                    writtenIds.add(idValue);
                                    String mappingValue = row.get(mappingColumn);
                                    String startXCoords = row.get(startXCoordColumnIndex);
                                    String startYCoords = row.get(startYCoordColumnIndex);
                                    String startZCoords = row.get(startZValueColumnIndex);
                                    String endXCoords = row.get(endXCoordColumnIndex);
                                    String endYCoords = row.get(endYCoordColumnIndex);
                                    String endZCoords = row.get(endZValueColumnIndex);
                                    double startXCoord = Double.parseDouble(startXCoords);
                                    double startYCoord = Double.parseDouble(startYCoords);
                                    double startZCoord = Double.parseDouble(startZCoords);
                                    double endXCoord = Double.parseDouble(endXCoords);
                                    double endYCoord = Double.parseDouble(endYCoords);
                                    double endZCoord = Double.parseDouble(endZCoords);
                                    if (actualDoTransform) {
                                        DirectPosition2D startTargetPos = new DirectPosition2D();
                                        DirectPosition2D startSourcePos = new DirectPosition2D(startXCoord, startYCoord);
                                        DirectPosition startRes = actualTransform.transform((DirectPosition)startSourcePos, (DirectPosition)startTargetPos);
                                        startCoords = startRes.getCoordinate();
                                        DirectPosition2D endTargetPos = new DirectPosition2D();
                                        DirectPosition2D endSourcePos = new DirectPosition2D(endXCoord, endYCoord);
                                        DirectPosition endRes = actualTransform.transform((DirectPosition)endSourcePos, (DirectPosition)endTargetPos);
                                        endCoords = endRes.getCoordinate();
                                    } else {
                                        startCoords = new double[]{startXCoord, startYCoord};
                                        endCoords = new double[]{endXCoord, endYCoord};
                                    }
                                    DistrictImportUtils.flipAxes(startCoords);
                                    DistrictImportUtils.flipAxes(endCoords);
                                    Optional oedge = DNEdgeBuilder.create((WriteGraph)graph, (Quadtree)existingVertices, (Resource)model.getParentDiagram(), (Resource)model.getComponentMappings().get(mappingValue), (double[])startCoords, (double)startZCoord, (double[])endCoords, (double)endZCoord, (double[])new double[0], (double)padding, (boolean)true);
                                    if (oedge.isPresent()) {
                                        Resource edge = (Resource)oedge.get();
                                        DistrictImportUtils.writeStringValue(graph, row, idColumn, edge, districtNetworkResource.HasId);
                                        DistrictImportUtils.writeValue(graph, row, diameterColumnIndex, edge, districtNetworkResource.Edge_HasDiameter);
                                        DistrictImportUtils.writeValue(graph, row, outerDiameterColumnIndex, edge, districtNetworkResource.Edge_HasOuterDiameter);
                                        DistrictImportUtils.writeValue(graph, row, nominalMassFlowIndex, edge, districtNetworkResource.Edge_HasNominalMassFlow);
                                        DistrictImportUtils.writeValue(graph, row, tGroundIndex, edge, districtNetworkResource.Edge_HasTGround);
                                        DistrictImportUtils.writeValue(graph, row, kReturnIndex, edge, districtNetworkResource.Edge_HasKReturn);
                                        DistrictImportUtils.writeValue(graph, row, kSupplyIndex, edge, districtNetworkResource.Edge_HasKSupply);
                                        DistrictImportUtils.writeValue(graph, row, edgeFlowAreaIndex, edge, districtNetworkResource.Edge_HasFlowArea);
                                        DistrictImportUtils.writeValue(graph, row, lengthIndex, edge, districtNetworkResource.Edge_HasLength);
                                        DistrictImportUtils.writeStringValue(graph, row, regionIndex, edge, districtNetworkResource.HasRegion);
                                        DistrictImportUtils.writeDoubleArrayFromString(graph, row, detailedGeometryIndex, edge, districtNetworkResource.Edge_HasGeometry, actualTransform);
                                    }
                                }
                                return true;
                            }
                            catch (MismatchedDimensionException | TransformException | DatabaseException e) {
                                throw new RuntimeException(e);
                            }
                        });
                    }
                    catch (IOException e) {
                        LOGGER.error("Could not import edges {}", (Object)model.getSource(), (Object)e);
                        Layer0Utils.setDependenciesIndexingDisabled((WriteOnlyGraph)graph, (boolean)false);
                    }
                }
                finally {
                    Layer0Utils.setDependenciesIndexingDisabled((WriteOnlyGraph)graph, (boolean)false);
                }
            }
        });
    }

    private static void flipAxes(double[] coords) {
        double tmp = coords[0];
        coords[0] = coords[1];
        coords[1] = tmp;
    }

    private static void writeValue(WriteGraph graph, CSVRecord row, int index, Resource subject, Resource relation) throws DatabaseException {
        String stringValue;
        if (index != -1 && !(stringValue = row.get(index)).isEmpty()) {
            try {
                if (stringValue.startsWith("\"") && stringValue.endsWith("\"")) {
                    stringValue = stringValue.substring(1, stringValue.length() - 1);
                }
                graph.claimLiteral(subject, relation, (Object)Double.parseDouble(stringValue), (Binding)Bindings.DOUBLE);
            }
            catch (NumberFormatException e) {
                LOGGER.error("Could not parse {} {} {} {}", new Object[]{row, index, subject, relation, e});
            }
        }
    }

    private static void writeStringValue(WriteGraph graph, CSVRecord row, int index, Resource subject, Resource relation) throws DatabaseException {
        String stringValue;
        if (index != -1 && !(stringValue = row.get(index)).isEmpty()) {
            try {
                graph.claimLiteral(subject, relation, (Object)stringValue, (Binding)Bindings.STRING);
            }
            catch (NumberFormatException e) {
                throw new DatabaseException((Throwable)e);
            }
        }
    }

    private static void writeDoubleArrayFromString(WriteGraph graph, CSVRecord row, int index, Resource subject, Resource relation, MathTransform actualTransform) throws DatabaseException, MismatchedDimensionException, TransformException {
        String stringValue;
        if (index != -1 && !(stringValue = row.get(index)).isEmpty()) {
            if (stringValue.startsWith("\"") && stringValue.endsWith("\"")) {
                stringValue = stringValue.substring(1, stringValue.length() - 1);
            }
            String[] coordPairs = stringValue.split(";");
            ArrayList<Double> dd = new ArrayList<Double>(coordPairs.length * 2);
            int i = 0;
            while (i < coordPairs.length) {
                String coordPair = coordPairs[i];
                String[] p = coordPair.split(" ");
                double x = Double.parseDouble(p[0]);
                double y = Double.parseDouble(p[1]);
                if (actualTransform != null) {
                    DirectPosition2D targetPos = new DirectPosition2D();
                    DirectPosition2D sourcePos = new DirectPosition2D(y, x);
                    DirectPosition res = actualTransform.transform((DirectPosition)sourcePos, (DirectPosition)targetPos);
                    double[] coords = res.getCoordinate();
                    x = coords[1];
                    y = coords[0];
                }
                dd.add(x);
                dd.add(y);
                ++i;
            }
            double[] detailedGeometryCoords = new double[dd.size()];
            int i2 = 0;
            while (i2 < dd.size()) {
                double d;
                detailedGeometryCoords[i2] = d = ((Double)dd.get(i2)).doubleValue();
                ++i2;
            }
            try {
                graph.claimLiteral(subject, relation, (Object)detailedGeometryCoords, (Binding)Bindings.DOUBLE_ARRAY);
            }
            catch (NumberFormatException e) {
                throw new DatabaseException((Throwable)e);
            }
        }
    }

    public static class CSVHeader {
        private final String header;
        private final int index;

        public CSVHeader(String header, int index) {
            this.header = header;
            this.index = index;
        }

        public String getHeader() {
            return this.header;
        }

        public int getIndex() {
            return this.index;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.header == null ? 0 : this.header.hashCode());
            result = 31 * result + this.index;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CSVHeader other = (CSVHeader)obj;
            if (this.header == null ? other.header != null : !this.header.equals(other.header)) {
                return false;
            }
            return this.index == other.index;
        }
    }
}

