/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.imports.ui;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.csv.CSVRecord;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.geotools.referencing.CRS;
import org.simantics.district.imports.CSVImportModel;
import org.simantics.district.imports.ui.controls.DynamicComboFieldEditor;

public class CSVImportWizardPage
extends WizardPage {
    private CSVImportModel model;
    private Map<Integer, String> headerIndexAndValues = new HashMap<Integer, String>();
    private Table headerTable;
    private Combo delimiterCombo;
    private TableColumnLayout tableColumnLayout;
    private Composite tableComposite;
    private DynamicComboFieldEditor componentMappingSelector;
    private DynamicComboFieldEditor idSelector;
    private DynamicComboFieldEditor xCoordSelector;
    private DynamicComboFieldEditor yCoordSelector;
    private DynamicComboFieldEditor zValueSelector;
    private DynamicComboFieldEditor altElevationValueSelector;
    private DynamicComboFieldEditor supplyTempValueSelector;
    private DynamicComboFieldEditor returnTempValueSelector;
    private DynamicComboFieldEditor supplyPressureValueSelector;
    private DynamicComboFieldEditor returnPressureValueSelector;
    private DynamicComboFieldEditor dpSelector;
    private DynamicComboFieldEditor dtSelector;
    private DynamicComboFieldEditor heatPowerSelector;
    private DynamicComboFieldEditor peakPowerSelector;
    private DynamicComboFieldEditor regionSelector;
    private DynamicComboFieldEditor nominalHeadMSelector;
    private DynamicComboFieldEditor nominalHeadBSelector;
    private DynamicComboFieldEditor nominalFlowSelector;
    private DynamicComboFieldEditor maximumHeadMSelector;
    private DynamicComboFieldEditor heatLoadDsSelector;
    private DynamicComboFieldEditor massFlowSelector;
    private DynamicComboFieldEditor volFlowSelector;
    private DynamicComboFieldEditor velocitySelector;
    private DynamicComboFieldEditor flowAreaSelector;
    private DynamicComboFieldEditor nominalPressureLossSelector;
    private DynamicComboFieldEditor valvePositionSelector;
    private DynamicComboFieldEditor addressSelector;
    private DynamicComboFieldEditor lengthSelector;
    private DynamicComboFieldEditor startXCoordSelector;
    private DynamicComboFieldEditor startYCoordSelector;
    private DynamicComboFieldEditor startZValueSelector;
    private DynamicComboFieldEditor endXCoordSelector;
    private DynamicComboFieldEditor endYCoordSelector;
    private DynamicComboFieldEditor endZValueSelector;
    private DynamicComboFieldEditor detailedGeometrySelector;
    private Text edgeConnectionPadding;
    private DynamicComboFieldEditor outerDiameterSelector;
    private DynamicComboFieldEditor diameterSelector;
    private DynamicComboFieldEditor nominalMassFlowSelector;
    private Group indexMappingGroup;
    private Composite composite;
    private Button isVertexImport;
    private Combo sourceCRSCombo;
    private DynamicComboFieldEditor edgeFlowAreaSelector;
    private DynamicComboFieldEditor kReturnSelector;
    private DynamicComboFieldEditor kSupplySelector;
    private DynamicComboFieldEditor tGroundSelector;

    protected CSVImportWizardPage(CSVImportModel model) {
        super("Import CSV Data");
        this.model = model;
        this.setMessage("Select column index mappings");
    }

    public void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)this.composite);
        Label label = new Label(this.composite, 0);
        label.setText("Select delimiter");
        this.delimiterCombo = new Combo(this.composite, 12);
        this.delimiterCombo.setToolTipText("Select the delimiter that is used to separate elements in the CSV file");
        String[] formats = this.model.getDelimiterFormats();
        this.delimiterCombo.setItems(formats);
        if (formats.length > 0) {
            this.delimiterCombo.select(0);
        }
        this.delimiterCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setDelimiterByLabel(CSVImportWizardPage.this.delimiterCombo.getItem(CSVImportWizardPage.this.delimiterCombo.getSelectionIndex()));
                CSVImportWizardPage.this.updateHeaders();
                CSVImportWizardPage.this.updateCombos();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.tableComposite = new Composite(this.composite, 2048);
        this.tableColumnLayout = new TableColumnLayout();
        this.tableComposite.setLayout((Layout)this.tableColumnLayout);
        label = new Label(this.composite, 0);
        label.setText("Select source Coordinate Reference System");
        this.sourceCRSCombo = new Combo(this.composite, 0);
        this.sourceCRSCombo.setToolTipText("Select the coordinate reference system that is used in the source material for possible transformation to target coordinate reference system (EPSG:4326)");
        final Set codes = CRS.getSupportedCodes((String)"EPSG");
        this.sourceCRSCombo.setItems(codes.toArray(new String[codes.size()]));
        this.sourceCRSCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String current = CSVImportWizardPage.this.sourceCRSCombo.getItem(CSVImportWizardPage.this.sourceCRSCombo.getSelectionIndex());
                CSVImportWizardPage.this.model.setSourceCRS("EPSG:" + current);
            }
        });
        this.sourceCRSCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String currentText = CSVImportWizardPage.this.sourceCRSCombo.getText();
                if (codes.contains(currentText)) {
                    String[] items = CSVImportWizardPage.this.sourceCRSCombo.getItems();
                    int i = 0;
                    while (i < items.length) {
                        String item = items[i];
                        if (currentText.equals(item)) break;
                        ++i;
                    }
                    if (i != 0) {
                        CSVImportWizardPage.this.sourceCRSCombo.select(i);
                        CSVImportWizardPage.this.model.setSourceCRS("EPSG:" + currentText);
                    } else {
                        System.err.println("this should not happen");
                    }
                }
            }
        });
        this.isVertexImport = new Button(this.composite, 32);
        this.isVertexImport.setText("File contains vertices");
        this.isVertexImport.setToolTipText("Enable this if the file contains vertices, i.e. points");
        this.isVertexImport.setSelection(this.model.isVertexImport());
        this.isVertexImport.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setVertexImport(CSVImportWizardPage.this.isVertexImport.getSelection());
                CSVImportWizardPage.this.updateControls(false);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.updateControls(true);
        this.updateHeaders();
        this.setControl((Control)this.composite);
        IWizardContainer container = this.getContainer();
        if (container instanceof IPageChangeProvider) {
            ((IPageChangeProvider)container).addPageChangedListener(new IPageChangedListener(){

                public void pageChanged(PageChangedEvent event) {
                    if (CSVImportWizardPage.this.isCurrentPage()) {
                        CSVImportWizardPage.this.updateControls(false);
                    }
                }
            });
        }
        this.validatePageComplete();
    }

    private void updateControls(boolean initial) {
        this.createIndexMappingGroup();
        this.updateCombos();
        if (!initial) {
            this.composite.layout(true, true);
        }
    }

    private void createIndexMappingGroup() {
        if (this.indexMappingGroup != null) {
            this.indexMappingGroup.dispose();
        }
        this.indexMappingGroup = new Group(this.composite, 0);
        this.indexMappingGroup.setText("Column index mapping");
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.indexMappingGroup);
        if (this.model.isVertexImport()) {
            this.createVertexIndexMappingField(this.indexMappingGroup);
        } else {
            this.createEdgeIndexMappingField(this.indexMappingGroup);
        }
        this.createCommonIndexMappingField(this.indexMappingGroup);
        if (!this.model.isVertexImport()) {
            Label label = new Label((Composite)this.indexMappingGroup, 0);
            label.setText("Connection point padding");
            GridDataFactory.fillDefaults().applyTo((Control)label);
            this.edgeConnectionPadding = new Text((Composite)this.indexMappingGroup, 2048);
            GridDataFactory.fillDefaults().applyTo((Control)this.edgeConnectionPadding);
            this.edgeConnectionPadding.setText("0.0001");
            this.edgeConnectionPadding.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    try {
                        double padding = Double.parseDouble(CSVImportWizardPage.this.edgeConnectionPadding.getText());
                        CSVImportWizardPage.this.model.setEdgePadding(padding);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            });
        }
    }

    private void createCommonIndexMappingField(Group parent) {
        this.componentMappingSelector = new DynamicComboFieldEditor("componentMapping", "Apros component mapping", (Composite)parent);
        this.componentMappingSelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setComponentMappingIndex(Integer.parseInt(CSVImportWizardPage.this.componentMappingSelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
        this.idSelector = new DynamicComboFieldEditor("id", "ID", (Composite)parent);
        this.idSelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setIdIndex(Integer.parseInt(CSVImportWizardPage.this.idSelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
        this.regionSelector = new DynamicComboFieldEditor("regionValue", "Region", (Composite)parent);
        this.regionSelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setRegionIndex(Integer.parseInt(CSVImportWizardPage.this.regionSelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
    }

    private void createVertexIndexMappingField(Group parent) {
        this.xCoordSelector = new DynamicComboFieldEditor("xCoord", "X Coordinate", (Composite)parent);
        this.xCoordSelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setXCoordIndex(Integer.parseInt(CSVImportWizardPage.this.xCoordSelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
        this.yCoordSelector = new DynamicComboFieldEditor("yCoord", "Y Coordinate", (Composite)parent);
        this.yCoordSelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setYCoordIndex(Integer.parseInt(CSVImportWizardPage.this.yCoordSelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
        this.zValueSelector = new DynamicComboFieldEditor("zValue", "Z Value", (Composite)parent);
        this.zValueSelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setZCoordIndex(Integer.parseInt(CSVImportWizardPage.this.zValueSelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
        this.altElevationValueSelector = new DynamicComboFieldEditor("altElevation", "Alternative Elevation", (Composite)parent);
        this.altElevationValueSelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setAltElevationIndex(Integer.parseInt(CSVImportWizardPage.this.altElevationValueSelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
        this.supplyTempValueSelector = new DynamicComboFieldEditor("tempValue", "Supply Temperature value", (Composite)parent);
        this.supplyTempValueSelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setSupplyTempIndex(Integer.parseInt(CSVImportWizardPage.this.supplyTempValueSelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
        this.returnTempValueSelector = new DynamicComboFieldEditor("returnTempValue", "Return Temperature value", (Composite)parent);
        this.returnTempValueSelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setReturnTempIndex(Integer.parseInt(CSVImportWizardPage.this.returnTempValueSelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
        this.supplyPressureValueSelector = new DynamicComboFieldEditor("pressureValue", "Supply Pressure value", (Composite)parent);
        this.supplyPressureValueSelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setSupplyPressureIndex(Integer.parseInt(CSVImportWizardPage.this.supplyPressureValueSelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
        this.returnPressureValueSelector = new DynamicComboFieldEditor("returnPressureValue", "Return Pressure value", (Composite)parent);
        this.returnPressureValueSelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setReturnPressureIndex(Integer.parseInt(CSVImportWizardPage.this.returnPressureValueSelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
        this.dpSelector = new DynamicComboFieldEditor("dpValue", "Delta pressure ", (Composite)parent);
        this.dpSelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setDeltaPressureIndex(Integer.parseInt(CSVImportWizardPage.this.dpSelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
        this.dtSelector = new DynamicComboFieldEditor("dtValue", "Delta temperature ", (Composite)parent);
        this.dtSelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setDeltaTemperatureIndex(Integer.parseInt(CSVImportWizardPage.this.dtSelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
        this.heatPowerSelector = new DynamicComboFieldEditor("heatPowerValue", "Heat Power", (Composite)parent);
        this.heatPowerSelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setHeatPowerIndex(Integer.parseInt(CSVImportWizardPage.this.heatPowerSelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
        this.peakPowerSelector = new DynamicComboFieldEditor("peakPowerValue", "Peak Power", (Composite)parent);
        this.peakPowerSelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setPeakPowerIndex(Integer.parseInt(CSVImportWizardPage.this.peakPowerSelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
        this.nominalHeadMSelector = new DynamicComboFieldEditor("nominalHeadMValue", "nominalHeadM", (Composite)parent);
        this.nominalHeadMSelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setNominalHeadMIndex(Integer.parseInt(CSVImportWizardPage.this.nominalHeadMSelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
        this.nominalHeadBSelector = new DynamicComboFieldEditor("nominalHeadBValue", "nominalHeadB", (Composite)parent);
        this.nominalHeadBSelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setNominalHeadBIndex(Integer.parseInt(CSVImportWizardPage.this.nominalHeadBSelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
        this.nominalFlowSelector = new DynamicComboFieldEditor("nominalFlowValue", "nominalFlow", (Composite)parent);
        this.nominalFlowSelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setNominalFlowIndex(Integer.parseInt(CSVImportWizardPage.this.nominalFlowSelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
        this.maximumHeadMSelector = new DynamicComboFieldEditor("maximumHeadMValue", "maximumHeadM", (Composite)parent);
        this.maximumHeadMSelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setMaximumHeadMIndex(Integer.parseInt(CSVImportWizardPage.this.maximumHeadMSelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
        this.heatLoadDsSelector = new DynamicComboFieldEditor("heatLoadDsValue", "heatLoadDs", (Composite)parent);
        this.heatLoadDsSelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setHeatLoadDsIndex(Integer.parseInt(CSVImportWizardPage.this.heatLoadDsSelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
        this.massFlowSelector = new DynamicComboFieldEditor("massFlowValue", "massFlow", (Composite)parent);
        this.massFlowSelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setMassFlowIndex(Integer.parseInt(CSVImportWizardPage.this.massFlowSelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
        this.volFlowSelector = new DynamicComboFieldEditor("volFlowValue", "volFlow", (Composite)parent);
        this.volFlowSelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setVolFlowIndex(Integer.parseInt(CSVImportWizardPage.this.volFlowSelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
        this.velocitySelector = new DynamicComboFieldEditor("velocityValue", "velocity", (Composite)parent);
        this.velocitySelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setVelocityIndex(Integer.parseInt(CSVImportWizardPage.this.velocitySelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
        this.flowAreaSelector = new DynamicComboFieldEditor("flowAreaValue", "flowArea", (Composite)parent);
        this.flowAreaSelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setFlowAreaIndex(Integer.parseInt(CSVImportWizardPage.this.flowAreaSelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
        this.nominalPressureLossSelector = new DynamicComboFieldEditor("nominalPressureLossValue", "nominalPressureLoss", (Composite)parent);
        this.nominalPressureLossSelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setNominalPressureLossIndex(Integer.parseInt(CSVImportWizardPage.this.nominalPressureLossSelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
        this.valvePositionSelector = new DynamicComboFieldEditor("valvePositionSelectorValue", "valvePositionSelector", (Composite)parent);
        this.valvePositionSelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setValvePositionIndex(Integer.parseInt(CSVImportWizardPage.this.valvePositionSelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
        this.addressSelector = new DynamicComboFieldEditor("addressValue", "addressSelector", (Composite)parent);
        this.addressSelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setAddressIndex(Integer.parseInt(CSVImportWizardPage.this.addressSelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
    }

    private void createEdgeIndexMappingField(Group parent) {
        this.startXCoordSelector = new DynamicComboFieldEditor("startxCoord", "Start X Coordinate", (Composite)parent);
        this.startXCoordSelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setStartXCoordIndex(Integer.parseInt(CSVImportWizardPage.this.startXCoordSelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
        this.startYCoordSelector = new DynamicComboFieldEditor("startyCoord", "Start Y Coordinate", (Composite)parent);
        this.startYCoordSelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setStartYCoordIndex(Integer.parseInt(CSVImportWizardPage.this.startYCoordSelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
        this.startZValueSelector = new DynamicComboFieldEditor("startzValue", "Start Z Value", (Composite)parent);
        this.startZValueSelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setStartZCoordIndex(Integer.parseInt(CSVImportWizardPage.this.startZValueSelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
        this.endXCoordSelector = new DynamicComboFieldEditor("endxCoord", "End X Coordinate", (Composite)parent);
        this.endXCoordSelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setEndXCoordIndex(Integer.parseInt(CSVImportWizardPage.this.endXCoordSelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
        this.endYCoordSelector = new DynamicComboFieldEditor("endyCoord", "End Y Coordinate", (Composite)parent);
        this.endYCoordSelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setEndYCoordIndex(Integer.parseInt(CSVImportWizardPage.this.endYCoordSelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
        this.endZValueSelector = new DynamicComboFieldEditor("endzValue", "End Z Value", (Composite)parent);
        this.endZValueSelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setEndZCoordIndex(Integer.parseInt(CSVImportWizardPage.this.endZValueSelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
        this.detailedGeometrySelector = new DynamicComboFieldEditor("detailedGeometryValue", "Geometry", (Composite)parent);
        this.detailedGeometrySelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.detailedGeometryIndex(Integer.parseInt(CSVImportWizardPage.this.detailedGeometrySelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
        this.diameterSelector = new DynamicComboFieldEditor("diameterValue", "Diameter value", (Composite)parent);
        this.diameterSelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setDiameterIndex(Integer.parseInt(CSVImportWizardPage.this.diameterSelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
        this.outerDiameterSelector = new DynamicComboFieldEditor("outerDiameterValue", "Outer Diameter value", (Composite)parent);
        this.outerDiameterSelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setOuterDiameterIndex(Integer.parseInt(CSVImportWizardPage.this.outerDiameterSelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
        this.nominalMassFlowSelector = new DynamicComboFieldEditor("nominalMassFlowValue", "Nominal Mass Flow", (Composite)parent);
        this.nominalMassFlowSelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setNominalMassFlowIndex(Integer.parseInt(CSVImportWizardPage.this.nominalMassFlowSelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
        this.edgeFlowAreaSelector = new DynamicComboFieldEditor("edgeFlowAreaValue", "Flow Area", (Composite)parent);
        this.edgeFlowAreaSelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setEdgeFlowAreaIndex(Integer.parseInt(CSVImportWizardPage.this.edgeFlowAreaSelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
        this.kReturnSelector = new DynamicComboFieldEditor("kReturnValue", "K Return", (Composite)parent);
        this.kReturnSelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setKReturnIndex(Integer.parseInt(CSVImportWizardPage.this.kReturnSelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
        this.kSupplySelector = new DynamicComboFieldEditor("kSupplyValue", "K Supply", (Composite)parent);
        this.kSupplySelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setKSupplyIndex(Integer.parseInt(CSVImportWizardPage.this.kSupplySelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
        this.tGroundSelector = new DynamicComboFieldEditor("tGroundValue", "Temperature Ground", (Composite)parent);
        this.tGroundSelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setTGroundIndex(Integer.parseInt(CSVImportWizardPage.this.tGroundSelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
        this.lengthSelector = new DynamicComboFieldEditor("lengthValue", "lengthSelector", (Composite)parent);
        this.lengthSelector.addComboListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CSVImportWizardPage.this.model.setLengthIndex(Integer.parseInt(CSVImportWizardPage.this.lengthSelector.getValue()));
                CSVImportWizardPage.this.validatePageComplete();
            }
        });
    }

    private void updateCombos() {
        String[][] namesAndValues = new String[this.headerIndexAndValues.size() + 1][];
        namesAndValues[0] = new String[]{"", "-1"};
        int i = 1;
        for (Map.Entry<Integer, String> entry : this.headerIndexAndValues.entrySet()) {
            int key = entry.getKey();
            String value = entry.getValue();
            String[] nameAndValue = new String[]{value, Integer.toString(key)};
            namesAndValues[i++] = nameAndValue;
        }
        if (this.model.isVertexImport()) {
            this.updateVertexCombos(namesAndValues);
        } else {
            this.updateEdgeCombos(namesAndValues);
        }
        this.componentMappingSelector.updateCombo(namesAndValues);
        this.idSelector.updateCombo(namesAndValues);
    }

    private void updateEdgeCombos(String[][] namesAndValues) {
        this.startXCoordSelector.updateCombo(namesAndValues);
        this.endXCoordSelector.updateCombo(namesAndValues);
        this.startYCoordSelector.updateCombo(namesAndValues);
        this.endYCoordSelector.updateCombo(namesAndValues);
        this.startZValueSelector.updateCombo(namesAndValues);
        this.endZValueSelector.updateCombo(namesAndValues);
        this.detailedGeometrySelector.updateCombo(namesAndValues);
        this.diameterSelector.updateCombo(namesAndValues);
        this.outerDiameterSelector.updateCombo(namesAndValues);
        this.nominalMassFlowSelector.updateCombo(namesAndValues);
        this.edgeFlowAreaSelector.updateCombo(namesAndValues);
        this.kReturnSelector.updateCombo(namesAndValues);
        this.kSupplySelector.updateCombo(namesAndValues);
        this.tGroundSelector.updateCombo(namesAndValues);
        this.lengthSelector.updateCombo(namesAndValues);
    }

    private void updateVertexCombos(String[][] namesAndValues) {
        this.xCoordSelector.updateCombo(namesAndValues);
        this.yCoordSelector.updateCombo(namesAndValues);
        this.zValueSelector.updateCombo(namesAndValues);
        this.altElevationValueSelector.updateCombo(namesAndValues);
        this.supplyTempValueSelector.updateCombo(namesAndValues);
        this.returnTempValueSelector.updateCombo(namesAndValues);
        this.supplyPressureValueSelector.updateCombo(namesAndValues);
        this.returnPressureValueSelector.updateCombo(namesAndValues);
        this.dpSelector.updateCombo(namesAndValues);
        this.dtSelector.updateCombo(namesAndValues);
        this.heatPowerSelector.updateCombo(namesAndValues);
        this.valvePositionSelector.updateCombo(namesAndValues);
        this.nominalHeadMSelector.updateCombo(namesAndValues);
        this.nominalHeadBSelector.updateCombo(namesAndValues);
        this.nominalFlowSelector.updateCombo(namesAndValues);
        this.maximumHeadMSelector.updateCombo(namesAndValues);
        this.heatLoadDsSelector.updateCombo(namesAndValues);
        this.massFlowSelector.updateCombo(namesAndValues);
        this.volFlowSelector.updateCombo(namesAndValues);
        this.velocitySelector.updateCombo(namesAndValues);
        this.flowAreaSelector.updateCombo(namesAndValues);
        this.nominalPressureLossSelector.updateCombo(namesAndValues);
        this.addressSelector.updateCombo(namesAndValues);
    }

    private void updateHeaders() {
        if (this.headerTable != null) {
            this.headerTable.dispose();
        }
        this.headerTable = new Table(this.tableComposite, 0);
        this.headerTable.setHeaderVisible(true);
        this.headerTable.setLinesVisible(true);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)this.tableComposite);
        int i = 0;
        while (i < this.headerTable.getColumns().length) {
            TableColumn column = this.headerTable.getColumns()[i];
            column.dispose();
            ++i;
        }
        i = 0;
        while (i < this.headerTable.getItemCount()) {
            TableItem item = this.headerTable.getItem(i);
            item.dispose();
            ++i;
        }
        this.headerIndexAndValues.clear();
        try {
            List rows = this.model.getRows(5, false);
            int k = 0;
            while (k < rows.size()) {
                CSVRecord row = (CSVRecord)rows.get(k);
                int columnCount = row.size();
                int i2 = 0;
                while (i2 < columnCount) {
                    String value = row.get(i2);
                    if (k == 0) {
                        TableColumn headerCol = new TableColumn(this.headerTable, 0);
                        headerCol.setText(value);
                        this.tableColumnLayout.setColumnData((Widget)headerCol, (ColumnLayoutData)new ColumnWeightData(10));
                        headerCol.pack();
                        this.headerIndexAndValues.put(i2, value);
                    } else {
                        int actualK = k - 1;
                        int itemCount = this.headerTable.getItemCount();
                        TableItem item = actualK >= itemCount ? new TableItem(this.headerTable, 0) : this.headerTable.getItem(actualK);
                        item.setText(i2, value);
                    }
                    ++i2;
                }
                ++k;
            }
        }
        catch (IOException e) {
            this.setErrorMessage(e.getMessage());
        }
    }

    protected void validatePageComplete() {
        if (this.model.isVertexImport()) {
            this.setPageComplete(this.model.getXCoordIndex() != -1 && this.model.getYCoordIndex() != -1 && this.model.getComponentMappingIndex() != -1);
        } else {
            this.setPageComplete(this.model.getStartXCoordIndex() != -1 && this.model.getStartYCoordIndex() != -1 && this.model.getEndXCoordIndex() != -1 && this.model.getEndYCoordIndex() != -1 && this.model.getComponentMappingIndex() != -1);
        }
    }
}

