/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.tester;

import org.eclipse.core.expressions.PropertyTester;
import org.simantics.DatabaseJob;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.utils.RequestUtil;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.scl.reflection.OntologyVersions;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.utils.ResourceAdaptionUtils;

public class CollectionResourcePropertyTester
extends PropertyTester {
    private static final boolean DEBUG = false;
    protected static final String RESOURCE_TYPES = "resourceTypes";
    private static final OntologyVersions VERSIONS = OntologyVersions.getInstance();

    public boolean test(Object receiver, final String property, final Object[] args, final Object expectedValue) {
        final Resource[] resources = ResourceAdaptionUtils.toResources(receiver);
        if (resources == null) {
            return false;
        }
        ISessionContext ctx = Simantics.getSessionContext();
        if (ctx == null) {
            return false;
        }
        if (DatabaseJob.inProgress()) {
            return false;
        }
        try {
            return (Boolean)RequestUtil.trySyncRequest((Session)ctx.getSession(), (long)SimanticsUI.UI_THREAD_REQUEST_START_TIMEOUT, (long)SimanticsUI.UI_THREAD_REQUEST_EXECUTION_TIMEOUT, (Object)false, (Read)new UniqueRead<Boolean>(){

                public Boolean perform(ReadGraph g) throws DatabaseException {
                    return CollectionResourcePropertyTester.this.doTest(g, resources, property, args, expectedValue);
                }
            });
        }
        catch (InterruptedException | DatabaseException throwable) {
            return false;
        }
    }

    protected boolean doTest(ReadGraph g, Resource[] resources, String property, Object[] args, Object expectedValue) throws DatabaseException {
        if (RESOURCE_TYPES.equals(property)) {
            Resource[] resourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                block6: {
                    Resource r = resourceArray[n2];
                    try {
                        int i = 0;
                        while (i < args.length) {
                            if (!g.isInstanceOf(r, g.getResource(VERSIONS.currentVersion((String)args[i])))) {
                                ++i;
                                continue;
                            }
                            break block6;
                        }
                    }
                    catch (ResourceNotFoundException resourceNotFoundException) {
                        return false;
                    }
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }
}

