/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.graph.formula;

import org.simantics.spreadsheet.graph.CellFormulaFunction;
import org.simantics.spreadsheet.graph.CellValueVisitor;
import org.simantics.spreadsheet.graph.SpreadsheetGraphUtils;
import org.simantics.spreadsheet.graph.formula.FormulaError2;
import org.simantics.spreadsheet.graph.parser.ast.AstArgList;

public class SqrtFormulaFunction
implements CellFormulaFunction<Object> {
    @Override
    public Object evaluate(CellValueVisitor visitor, AstArgList args) {
        if (args.values.size() != 1) {
            throw new IllegalStateException();
        }
        Object number = args.values.get(0).accept(visitor);
        Double dVal = SpreadsheetGraphUtils.asDoubleWhereEmptyStringIsZero(number);
        if (dVal == null) {
            return FormulaError2.handleErrorCall(number);
        }
        if (dVal < 0.0) {
            return FormulaError2.NUM.getString();
        }
        return Math.sqrt(dVal);
    }
}

