/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.mapping;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.ClipboardUtils;
import org.simantics.db.layer0.util.SimanticsClipboardBuilder;
import org.simantics.db.layer0.util.SimanticsClipboardImpl;
import org.simantics.db.layer0.util.SimanticsKeys;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.ISynchronizationContext;
import org.simantics.graph.db.IImportAdvisor;
import org.simantics.graph.db.TransferableGraphs;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.modeling.mapping.ComponentAndElementCopyHandler;
import org.simantics.modeling.mapping.ComponentAndElementPasteImportAdvisor;
import org.simantics.modeling.mapping.ElementCopyAdvisor;
import org.simantics.utils.datastructures.hints.IHintContext;

public class TGElementCopyAdvisor
extends ElementCopyAdvisor {
    @Override
    public Object copy(ISynchronizationContext context, WriteGraph graph, Resource source, Resource sourceContainer, Resource targetContainer, Map<Object, Object> map) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        if (!graph.isInstanceOf(source, DIA.Connection)) {
            SimanticsClipboardImpl builder = new SimanticsClipboardImpl();
            ComponentAndElementCopyHandler handler = new ComponentAndElementCopyHandler(source, false, true){

                @Override
                protected void processElement(ReadGraph graph, Resource element, boolean includeElement, ArrayList<NamedResource> roots, ArrayList<Resource> exclusions) throws DatabaseException {
                    super.processElement(graph, element, includeElement, roots, exclusions);
                    TGElementCopyAdvisor.this.processElement(graph, element, includeElement, roots, exclusions);
                }
            };
            ComponentAndElementPasteImportAdvisor advisor = new ComponentAndElementPasteImportAdvisor((ReadGraph)graph, targetContainer, false, true);
            handler.copyToClipboard((ReadGraph)graph, (SimanticsClipboardBuilder)builder);
            for (Set object : builder.getContents()) {
                TransferableGraph1 tg = (TransferableGraph1)ClipboardUtils.accept((ReadGraph)graph, (Set)object, (IHintContext.Key)SimanticsKeys.KEY_TRANSFERABLE_GRAPH);
                if (tg == null) continue;
                TransferableGraphs.importGraph1((WriteGraph)graph, (TransferableGraph1)tg, (IImportAdvisor)advisor);
                advisor.attach(graph);
                Resource copy = advisor.getElement();
                map.put(source, copy);
                return copy;
            }
        } else {
            return super.copy(context, graph, source, sourceContainer, targetContainer, map);
        }
        throw new DatabaseException("Failed to copy resource " + NameUtils.getSafeName((ReadGraph)graph, (Resource)source, (boolean)true) + " under " + NameUtils.getSafeName((ReadGraph)graph, (Resource)targetContainer, (boolean)true));
    }

    protected void processElement(ReadGraph graph, Resource element, boolean includeElement, ArrayList<NamedResource> roots, ArrayList<Resource> exclusions) throws DatabaseException {
    }
}

