/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.ui.editor2;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.source.DefaultCharacterPairMatcher;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.TextNavigationAction;
import org.simantics.scl.ui.editor.SCLSourceViewerConfigurationNew;
import org.simantics.scl.ui.editor.completion.SCLTextEditorEnvironment;
import org.simantics.scl.ui.editor2.SCLModuleEditor2DocumentProvider;
import org.simantics.scl.ui.editor2.iterator.DocumentCharacterIterator;
import org.simantics.scl.ui.editor2.iterator.JavaWordIterator;

public class SCLModuleEditor2
extends TextEditor {
    private static final char[] CHARS = new char[]{'(', ')', '{', '}', '[', ']', '<', '>'};
    private static final String MATCHING_BRACKETS = "matchingBrackets";
    private static final String MATCHING_BRACKETS_COLOR = "matchingBracketsColor";
    private static final String HIGHLIGHT_BRACKET_AT_CARET_LOCATION = "highlightBracketAtCaretLocation";
    private static final String ENCLOSING_BRACKETS = "enclosingBrackets";
    private boolean disposed = false;
    protected ResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());
    private DefaultCharacterPairMatcher matcher;

    public SCLModuleEditor2() {
        SCLSourceViewerConfigurationNew sourceViewerConfiguration = new SCLSourceViewerConfigurationNew(this.resourceManager);
        this.setDocumentProvider((IDocumentProvider)new SCLModuleEditor2DocumentProvider(sourceViewerConfiguration));
        this.setSourceViewerConfiguration(sourceViewerConfiguration);
    }

    public boolean isTabsToSpacesConversionEnabled() {
        return true;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.getPreferenceStore().setValue(MATCHING_BRACKETS, true);
        this.getPreferenceStore().setValue(MATCHING_BRACKETS_COLOR, "192,192,192");
        this.getPreferenceStore().setValue(HIGHLIGHT_BRACKET_AT_CARET_LOCATION, true);
        this.getPreferenceStore().setValue(ENCLOSING_BRACKETS, true);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ((IContextService)this.getEditorSite().getService(IContextService.class)).activateContext("org.simantics.scl.ui.editor");
        this.updatePartName();
    }

    protected void createNavigationActions() {
        super.createNavigationActions();
        StyledText textWidget = this.getSourceViewer().getTextWidget();
        TextNavigationAction action = new NavigatePreviousSubWordAction();
        action.setActionDefinitionId("org.eclipse.ui.edit.text.goto.wordPrevious");
        this.setAction("org.eclipse.ui.edit.text.goto.wordPrevious", (IAction)action);
        textWidget.setKeyBinding(17039363, 0);
        action = new NavigateNextSubWordAction();
        action.setActionDefinitionId("org.eclipse.ui.edit.text.goto.wordNext");
        this.setAction("org.eclipse.ui.edit.text.goto.wordNext", (IAction)action);
        textWidget.setKeyBinding(0x1040004, 0);
        action = new SelectPreviousSubWordAction();
        action.setActionDefinitionId("org.eclipse.ui.edit.text.select.wordPrevious");
        this.setAction("org.eclipse.ui.edit.text.select.wordPrevious", (IAction)action);
        textWidget.setKeyBinding(17170435, 0);
        action = new SelectNextSubWordAction();
        action.setActionDefinitionId("org.eclipse.ui.edit.text.select.wordNext");
        this.setAction("org.eclipse.ui.edit.text.select.wordNext", (IAction)action);
        textWidget.setKeyBinding(17170436, 0);
    }

    protected void updatePartName() {
        this.setPartName(this.getEditorInput().getName());
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        this.matcher = new DefaultCharacterPairMatcher(CHARS);
        support.setCharacterPairMatcher((ICharacterPairMatcher)this.matcher);
        support.setMatchingCharacterPainterPreferenceKeys(MATCHING_BRACKETS, MATCHING_BRACKETS_COLOR, HIGHLIGHT_BRACKET_AT_CARET_LOCATION, ENCLOSING_BRACKETS);
        super.configureSourceViewerDecorationSupport(support);
    }

    public void dispose() {
        this.disposed = true;
        super.dispose();
        this.resourceManager.dispose();
        if (this.matcher != null) {
            this.matcher.dispose();
        }
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public SCLTextEditorEnvironment getSCLTextEditorEnvironment() {
        return ((SCLSourceViewerConfigurationNew)this.getSourceViewerConfiguration()).getSclTextEditorEnvironment();
    }

    public IDocument getDocument() {
        return this.getSourceViewer().getDocument();
    }

    protected class DeleteNextSubWordAction
    extends NextSubWordAction
    implements IUpdate {
        public DeleteNextSubWordAction() {
            super(262271);
        }

        @Override
        protected void setCaretPosition(int position) {
            if (!SCLModuleEditor2.this.validateEditorInputState()) {
                return;
            }
            ISourceViewer viewer = SCLModuleEditor2.this.getSourceViewer();
            StyledText text = viewer.getTextWidget();
            Point widgetSelection = text.getSelection();
            if (SCLModuleEditor2.this.isBlockSelectionModeEnabled() && widgetSelection.y != widgetSelection.x) {
                int caret = text.getCaretOffset();
                int offset = SCLModuleEditor2.modelOffset2WidgetOffset((ISourceViewer)viewer, (int)position);
                if (caret == widgetSelection.x) {
                    text.setSelectionRange(widgetSelection.y, offset - widgetSelection.y);
                } else {
                    text.setSelectionRange(widgetSelection.x, offset - widgetSelection.x);
                }
                text.invokeAction(127);
            } else {
                int length;
                int caret;
                Point selection = viewer.getSelectedRange();
                if (selection.y != 0) {
                    caret = selection.x;
                    length = selection.y;
                } else {
                    caret = SCLModuleEditor2.widgetOffset2ModelOffset((ISourceViewer)viewer, (int)text.getCaretOffset());
                    length = position - caret;
                }
                try {
                    viewer.getDocument().replace(caret, length, "");
                }
                catch (BadLocationException badLocationException) {}
            }
        }

        public void update() {
            this.setEnabled(SCLModuleEditor2.this.isEditorInputModifiable());
        }
    }

    protected class DeletePreviousSubWordAction
    extends PreviousSubWordAction
    implements IUpdate {
        public DeletePreviousSubWordAction() {
            super(262152);
        }

        @Override
        protected void setCaretPosition(int position) {
            if (!SCLModuleEditor2.this.validateEditorInputState()) {
                return;
            }
            ISourceViewer viewer = SCLModuleEditor2.this.getSourceViewer();
            StyledText text = viewer.getTextWidget();
            Point widgetSelection = text.getSelection();
            if (SCLModuleEditor2.this.isBlockSelectionModeEnabled() && widgetSelection.y != widgetSelection.x) {
                int caret = text.getCaretOffset();
                int offset = SCLModuleEditor2.modelOffset2WidgetOffset((ISourceViewer)viewer, (int)position);
                if (caret == widgetSelection.x) {
                    text.setSelectionRange(widgetSelection.y, offset - widgetSelection.y);
                } else {
                    text.setSelectionRange(widgetSelection.x, offset - widgetSelection.x);
                }
                text.invokeAction(8);
            } else {
                int length;
                Point selection = viewer.getSelectedRange();
                if (selection.y != 0) {
                    position = selection.x;
                    length = selection.y;
                } else {
                    length = SCLModuleEditor2.widgetOffset2ModelOffset((ISourceViewer)viewer, (int)text.getCaretOffset()) - position;
                }
                try {
                    viewer.getDocument().replace(position, length, "");
                }
                catch (BadLocationException badLocationException) {}
            }
        }

        public void update() {
            this.setEnabled(SCLModuleEditor2.this.isEditorInputModifiable());
        }
    }

    protected class NavigateNextSubWordAction
    extends NextSubWordAction {
        public NavigateNextSubWordAction() {
            super(0x1040004);
        }

        @Override
        protected void setCaretPosition(int position) {
            this.getTextWidget().setCaretOffset(SCLModuleEditor2.modelOffset2WidgetOffset((ISourceViewer)SCLModuleEditor2.this.getSourceViewer(), (int)position));
        }
    }

    protected class NavigatePreviousSubWordAction
    extends PreviousSubWordAction {
        public NavigatePreviousSubWordAction() {
            super(17039363);
        }

        @Override
        protected void setCaretPosition(int position) {
            this.getTextWidget().setCaretOffset(SCLModuleEditor2.modelOffset2WidgetOffset((ISourceViewer)SCLModuleEditor2.this.getSourceViewer(), (int)position));
        }
    }

    protected abstract class NextSubWordAction
    extends TextNavigationAction {
        protected JavaWordIterator fIterator;

        protected NextSubWordAction(int code) {
            super(SCLModuleEditor2.this.getSourceViewer().getTextWidget(), code);
            this.fIterator = new JavaWordIterator();
        }

        public void run() {
            ISourceViewer viewer = SCLModuleEditor2.this.getSourceViewer();
            IDocument document = viewer.getDocument();
            try {
                this.fIterator.setText(new DocumentCharacterIterator(document));
                int position = SCLModuleEditor2.widgetOffset2ModelOffset((ISourceViewer)viewer, (int)viewer.getTextWidget().getCaretOffset());
                if (position == -1) {
                    return;
                }
                int next = this.findNextPosition(position);
                if (SCLModuleEditor2.this.isBlockSelectionModeEnabled() && document.getLineOfOffset(next) != document.getLineOfOffset(position)) {
                    super.run();
                } else if (next != -1) {
                    this.setCaretPosition(next);
                    this.getTextWidget().showSelection();
                    this.fireSelectionChanged();
                }
            }
            catch (BadLocationException badLocationException) {}
        }

        protected int findNextPosition(int position) {
            ISourceViewer viewer = SCLModuleEditor2.this.getSourceViewer();
            int widget = -1;
            int next = position;
            while (next != -1 && widget == -1) {
                if ((next = this.fIterator.following(next)) == -1) continue;
                widget = SCLModuleEditor2.modelOffset2WidgetOffset((ISourceViewer)viewer, (int)next);
            }
            IDocument document = viewer.getDocument();
            LinkedModeModel model = LinkedModeModel.getModel((IDocument)document, (int)position);
            if (model != null && next != -1) {
                LinkedPosition linkedPosition = model.findPosition(new LinkedPosition(document, position, 0));
                if (linkedPosition != null) {
                    int linkedPositionEnd = linkedPosition.getOffset() + linkedPosition.getLength();
                    if (position != linkedPositionEnd && linkedPositionEnd < next) {
                        next = linkedPositionEnd;
                    }
                } else {
                    int nextLinkedPositionOffset;
                    LinkedPosition nextLinkedPosition = model.findPosition(new LinkedPosition(document, next, 0));
                    if (nextLinkedPosition != null && position != (nextLinkedPositionOffset = nextLinkedPosition.getOffset()) && nextLinkedPositionOffset < next) {
                        next = nextLinkedPositionOffset;
                    }
                }
            }
            return next;
        }

        protected abstract void setCaretPosition(int var1);
    }

    protected abstract class PreviousSubWordAction
    extends TextNavigationAction {
        protected JavaWordIterator fIterator;

        protected PreviousSubWordAction(int code) {
            super(SCLModuleEditor2.this.getSourceViewer().getTextWidget(), code);
            this.fIterator = new JavaWordIterator();
        }

        public void run() {
            ISourceViewer viewer = SCLModuleEditor2.this.getSourceViewer();
            IDocument document = viewer.getDocument();
            try {
                this.fIterator.setText(new DocumentCharacterIterator(document));
                int position = SCLModuleEditor2.widgetOffset2ModelOffset((ISourceViewer)viewer, (int)viewer.getTextWidget().getCaretOffset());
                if (position == -1) {
                    return;
                }
                int previous = this.findPreviousPosition(position);
                if (SCLModuleEditor2.this.isBlockSelectionModeEnabled() && document.getLineOfOffset(previous) != document.getLineOfOffset(position)) {
                    super.run();
                } else if (previous != -1) {
                    this.setCaretPosition(previous);
                    this.getTextWidget().showSelection();
                    this.fireSelectionChanged();
                }
            }
            catch (BadLocationException badLocationException) {}
        }

        protected int findPreviousPosition(int position) {
            ISourceViewer viewer = SCLModuleEditor2.this.getSourceViewer();
            int widget = -1;
            int previous = position;
            while (previous != -1 && widget == -1) {
                if ((previous = this.fIterator.preceding(previous)) == -1) continue;
                widget = SCLModuleEditor2.modelOffset2WidgetOffset((ISourceViewer)viewer, (int)previous);
            }
            IDocument document = viewer.getDocument();
            LinkedModeModel model = LinkedModeModel.getModel((IDocument)document, (int)position);
            if (model != null && previous != -1) {
                LinkedPosition linkedPosition = model.findPosition(new LinkedPosition(document, position, 0));
                if (linkedPosition != null) {
                    int linkedPositionOffset = linkedPosition.getOffset();
                    if (position != linkedPositionOffset && previous < linkedPositionOffset) {
                        previous = linkedPositionOffset;
                    }
                } else {
                    int previousLinkedPositionEnd;
                    LinkedPosition previousLinkedPosition = model.findPosition(new LinkedPosition(document, previous, 0));
                    if (previousLinkedPosition != null && position != (previousLinkedPositionEnd = previousLinkedPosition.getOffset() + previousLinkedPosition.getLength()) && previous < previousLinkedPositionEnd) {
                        previous = previousLinkedPositionEnd;
                    }
                }
            }
            return previous;
        }

        protected abstract void setCaretPosition(int var1);
    }

    protected class SelectNextSubWordAction
    extends NextSubWordAction {
        public SelectNextSubWordAction() {
            super(17170436);
        }

        @Override
        protected void setCaretPosition(int position) {
            ISourceViewer viewer = SCLModuleEditor2.this.getSourceViewer();
            StyledText text = viewer.getTextWidget();
            if (text != null && !text.isDisposed()) {
                Point selection = text.getSelection();
                int caret = text.getCaretOffset();
                int offset = SCLModuleEditor2.modelOffset2WidgetOffset((ISourceViewer)viewer, (int)position);
                if (caret == selection.x) {
                    text.setSelectionRange(selection.y, offset - selection.y);
                } else {
                    text.setSelectionRange(selection.x, offset - selection.x);
                }
            }
        }
    }

    protected class SelectPreviousSubWordAction
    extends PreviousSubWordAction {
        public SelectPreviousSubWordAction() {
            super(17170435);
        }

        @Override
        protected void setCaretPosition(int position) {
            ISourceViewer viewer = SCLModuleEditor2.this.getSourceViewer();
            StyledText text = viewer.getTextWidget();
            if (text != null && !text.isDisposed()) {
                Point selection = text.getSelection();
                int caret = text.getCaretOffset();
                int offset = SCLModuleEditor2.modelOffset2WidgetOffset((ISourceViewer)viewer, (int)position);
                if (caret == selection.x) {
                    text.setSelectionRange(selection.y, offset - selection.y);
                } else {
                    text.setSelectionRange(selection.x, offset - selection.x);
                }
            }
        }
    }
}

