/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.runtime;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.ui.IEditorInput;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.procedure.adapter.ListenerSupport;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.procedure.AsyncListener;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.db.request.WriteResult;
import org.simantics.diagram.runtime.RuntimeDiagramDesc;
import org.simantics.diagram.runtime.RuntimeVariable;
import org.simantics.diagram.runtime.RuntimeVariableForInput;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.ui.workbench.IResourceEditorInput2;
import org.simantics.utils.ui.ErrorLogger;

public class RuntimeDiagramManager {
    private boolean disposed;
    private Session session;
    private IEditorInput editorInput;
    private ListenerSupport support;
    private AtomicReference<Resource> runtimeDiagram = new AtomicReference();

    public static RuntimeDiagramManager track(Session session, Resource diagram, IEditorInput editorInput, ListenerSupport listenerSupport) throws DatabaseException {
        RuntimeDiagramManager manager = new RuntimeDiagramManager(session);
        manager.track(diagram, editorInput, listenerSupport);
        return manager;
    }

    public static RuntimeDiagramManager create(Session session, Resource diagram, String modelURI, String RVI2) throws DatabaseException {
        RuntimeDiagramManager manager = new RuntimeDiagramManager(session);
        manager.createRuntimeDiagram(diagram, modelURI, RVI2);
        return manager;
    }

    public RuntimeDiagramManager(Session session) {
        this.session = session;
    }

    public Resource getRuntimeDiagram() {
        return this.runtimeDiagram.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        RuntimeDiagramManager runtimeDiagramManager = this;
        synchronized (runtimeDiagramManager) {
            this.assertNotDisposed();
            this.disposed = true;
        }
        this.destroy();
        this.session = null;
        this.editorInput = null;
        this.support = null;
    }

    private void assertNotDisposed() {
        if (this.disposed) {
            throw new IllegalStateException(this + " is disposed");
        }
    }

    private static IResourceEditorInput2 getResourceInput(Object input) {
        if (input instanceof IResourceEditorInput2) {
            return (IResourceEditorInput2)input;
        }
        return null;
    }

    private IResourceEditorInput2 getResourceInput() {
        return RuntimeDiagramManager.getResourceInput(this.editorInput);
    }

    public Resource track(final Resource diagram, IEditorInput editorInput, ListenerSupport listenerSupport) throws DatabaseException {
        Resource runtime = this.runtimeDiagram.get();
        if (runtime != null) {
            return runtime;
        }
        if (editorInput == null) {
            throw new NullPointerException("null editorInput");
        }
        if (listenerSupport == null) {
            throw new NullPointerException("null listenerSupport");
        }
        final IResourceEditorInput2 input = RuntimeDiagramManager.getResourceInput(editorInput);
        if (input == null) {
            return null;
        }
        this.editorInput = editorInput;
        this.support = listenerSupport;
        runtime = (Resource)this.session.syncRequest((WriteResult)new WriteResultRequest<Resource>((VirtualGraph)this.session.getService(VirtualGraph.class)){

            public Resource perform(WriteGraph graph) throws DatabaseException {
                RuntimeDiagramDesc variable = (RuntimeDiagramDesc)((Object)graph.syncRequest((Read)new RuntimeVariableForInput(input)));
                if (variable == null) {
                    return null;
                }
                Resource runtime = RuntimeDiagramManager.this.createRuntimeDiagram(graph, diagram, variable);
                RuntimeDiagramManager.this.listenRequest((RequestProcessor)graph, diagram);
                return runtime;
            }
        });
        this.runtimeDiagram.set(runtime);
        return runtime;
    }

    public Resource createRuntimeDiagram(final Resource diagram, final String modelURI, final String RVI2) throws DatabaseException {
        Resource runtime = this.runtimeDiagram.get();
        if (runtime != null) {
            return runtime;
        }
        runtime = (Resource)this.session.syncRequest((WriteResult)new WriteResultRequest<Resource>((VirtualGraph)this.session.getService(VirtualGraph.class)){

            public Resource perform(WriteGraph graph) throws DatabaseException {
                Resource model = graph.getPossibleResource(modelURI);
                return RuntimeDiagramManager.this.createRuntimeDiagram(graph, diagram, model, RVI2);
            }
        });
        this.runtimeDiagram.set(runtime);
        return runtime;
    }

    public Resource createRuntimeDiagram(WriteGraph graph, Resource diagram, Resource model, String rvis) throws DatabaseException {
        RVI rvi = rvis != null ? RVI.fromResourceFormat((RequestProcessor)graph, (String)rvis) : null;
        RuntimeDiagramDesc desc = (RuntimeDiagramDesc)((Object)graph.syncRequest((Read)new RuntimeVariable(model, rvi, diagram)));
        if (desc == null) {
            return null;
        }
        return this.createRuntimeDiagram(graph, diagram, desc);
    }

    private void listenRequest(RequestProcessor processor, final Resource diagram) {
        processor.asyncRequest((Read)new RuntimeVariableForInput(this.getResourceInput()), (AsyncListener)new AsyncListener<RuntimeDiagramDesc>(){

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                ListenerSupport s = RuntimeDiagramManager.this.support;
                if (s != null) {
                    s.exception(throwable);
                }
            }

            public void execute(AsyncReadGraph graph, final RuntimeDiagramDesc desc) {
                if (desc == null) {
                    return;
                }
                Session session = graph.getSession();
                session.asyncRequest((Write)new WriteRequest((VirtualGraph)session.getService(VirtualGraph.class)){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        Resource runtime = RuntimeDiagramManager.this.getRuntimeDiagram();
                        if (runtime != null) {
                            RuntimeDiagramManager.this.writeConfig(graph, runtime, diagram, desc);
                        }
                    }
                }, e -> {
                    ListenerSupport s = RuntimeDiagramManager.this.support;
                    if (e != null && s != null) {
                        s.exception((Throwable)e);
                    }
                });
            }

            public boolean isDisposed() {
                if (RuntimeDiagramManager.this.disposed) {
                    return true;
                }
                return RuntimeDiagramManager.this.support != null && RuntimeDiagramManager.this.support.isDisposed();
            }
        });
    }

    private Resource createRuntimeDiagram(WriteGraph graph, Resource diagram, RuntimeDiagramDesc desc) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Resource runtime = graph.newResource();
        graph.claim(runtime, L0.InstanceOf, null, DIA.RuntimeDiagram);
        graph.claim(runtime, DIA.RuntimeDiagram_HasConfiguration, null, diagram);
        this.writeConfig(graph, runtime, diagram, desc);
        return runtime;
    }

    private void writeConfig(WriteGraph graph, Resource runtime, Resource diagram, RuntimeDiagramDesc desc) throws DatabaseException {
        Resource activeProfile;
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        if (desc.getVariableURI() != null) {
            graph.claimLiteral(runtime, DIA.RuntimeDiagram_HasVariable, (Object)desc.getVariableURI(), (Binding)Bindings.STRING);
        }
        if (desc.getRVI() != null) {
            graph.claimLiteral(runtime, DIA.RuntimeDiagram_HasRVI, (Object)desc.getRVI(), (Binding)Bindings.STRING);
        }
        if (desc.getModelURI() != null) {
            graph.claimLiteral(runtime, DIA.RuntimeDiagram_HasModelURI, (Object)desc.getModelURI(), (Binding)Bindings.STRING);
        }
        if (desc.getActiveProfileURI() != null && (activeProfile = graph.getPossibleResource(desc.getActiveProfileURI())) != null) {
            graph.deny(runtime, DIA.RuntimeDiagram_HasRuntimeProfile);
            graph.claim(runtime, DIA.RuntimeDiagram_HasRuntimeProfile, null, activeProfile);
        }
    }

    private void destroy() {
        final Resource rd = this.runtimeDiagram.getAndSet(null);
        if (rd != null) {
            try {
                this.session.syncRequest((Write)new WriteRequest((VirtualGraph)this.session.getService(VirtualGraph.class)){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        RemoverUtil.remove((WriteGraph)graph, (Resource)rd);
                    }
                });
            }
            catch (DatabaseException e) {
                ListenerSupport s = this.support;
                if (s != null) {
                    s.exception((Throwable)e);
                }
                ErrorLogger.defaultLogError((Throwable)e);
            }
        }
    }
}

