/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.query.FlagTypeVisual;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.template2d.ontology.Template2dResource;
import org.simantics.scenegraph.ontology.ScenegraphResources;

public class FlagTypeVisuals
extends ResourceRead<List<FlagTypeVisual>> {
    public FlagTypeVisuals(Resource flagTable) {
        super(flagTable);
    }

    public List<FlagTypeVisual> perform(ReadGraph g) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        ScenegraphResources SG = ScenegraphResources.getInstance((ReadGraph)g);
        Resource list = g.getPossibleObject(this.resource, SG.Node_children);
        if (list == null || !g.isInstanceOf(list, L0.List)) {
            return Collections.emptyList();
        }
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)g);
        Template2dResource TEMPLATE2D = Template2dResource.getInstance((ReadGraph)g);
        List flagTypeVisuals = ListUtils.toList((ReadGraph)g, (Resource)list);
        ArrayList<FlagTypeVisual> result = new ArrayList<FlagTypeVisual>(flagTypeVisuals.size());
        for (Resource flagTypeVisual : flagTypeVisuals) {
            if (!g.isInstanceOf(flagTypeVisual, TEMPLATE2D.FlagTypeVisual)) continue;
            String reference = null;
            String pattern = null;
            Resource visualComposite = null;
            Collection children = g.getObjects(flagTypeVisual, L0.ConsistsOf);
            for (Resource child : children) {
                if (g.isInstanceOf(child, TEMPLATE2D.FlagTypeVisual_Filter)) {
                    reference = (String)g.getPossibleRelatedValue2(child, TEMPLATE2D.FlagTypeVisual_Filter_HasProperty, (Binding)Bindings.STRING);
                    pattern = (String)g.getPossibleRelatedValue2(child, TEMPLATE2D.FlagTypeVisual_Filter_HasPattern, (Binding)Bindings.STRING);
                }
                if (!g.isInstanceOf(child, DIA.Scenegraph_Composite)) continue;
                visualComposite = child;
            }
            if (visualComposite == null) continue;
            result.add(new FlagTypeVisual(flagTypeVisual, reference, pattern, visualComposite));
        }
        return result;
    }
}

