/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.tooltip;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.swing.ToolTipManager;
import org.simantics.g2d.diagram.participant.AbstractDiagramParticipant;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.tooltip.FocusableTooltipProvider;
import org.simantics.g2d.tooltip.ITooltipParticipant;
import org.simantics.g2d.tooltip.TooltipProvider;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scenegraph.g2d.events.command.CommandEvent;
import org.simantics.scenegraph.g2d.events.command.Commands;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.threads.ThreadUtils;

public abstract class BaseTooltipParticipant
extends AbstractDiagramParticipant
implements ITooltipParticipant {
    public static IHintContext.Key TOOLTIP_KEY = new IHintContext.KeyOf(TooltipProvider.class, "TOOLTIP");
    public int tooltipDelay = ToolTipManager.sharedInstance().getInitialDelay();
    private IElement tooltipElement;
    private TooltipProvider creator;
    private boolean tooltipShowing = false;
    private Future<?> delayRunnable = null;
    private int x = 0;
    private int y = 0;

    @EventHandlerReflection.EventHandler(priority=0)
    public boolean handleKeyEvent(CommandEvent e) {
        if (e.command == Commands.FOCUS_TOOLTIP && this.tooltipShowing && this.creator instanceof FocusableTooltipProvider) {
            ((FocusableTooltipProvider)this.creator).focus();
        }
        return false;
    }

    @EventHandlerReflection.EventHandler(priority=0x7FFFFFFF)
    public boolean handleMouseEvent(MouseEvent e) {
        if (e.screenPosition != null) {
            this.x = (int)e.screenPosition.getX();
            this.y = (int)e.screenPosition.getY();
        }
        if (this.tooltipShowing && e instanceof MouseEvent.MouseButtonPressedEvent) {
            this.hideTooltip();
        }
        return false;
    }

    @Override
    public synchronized void showTooltip() {
        if (this.tooltipElement == null) {
            return;
        }
        this.creator.showTooltip(this.tooltipElement, this.x, this.y);
        this.tooltipShowing = true;
    }

    private void launchThread() {
        if (this.delayRunnable != null) {
            this.delayRunnable.cancel(false);
            this.delayRunnable = null;
        }
        this.delayRunnable = ThreadUtils.getNonBlockingWorkExecutor().schedule(new Runnable(){

            @Override
            public void run() {
                BaseTooltipParticipant.this.showTooltip();
            }
        }, (long)this.tooltipDelay, TimeUnit.MILLISECONDS);
    }

    public synchronized void showTooltipFor(IElement element) {
        if (this.tooltipShowing && this.creator instanceof FocusableTooltipProvider && ((FocusableTooltipProvider)this.creator).hasFocus()) {
            return;
        }
        this.creator = (TooltipProvider)element.getHint(TOOLTIP_KEY);
        if (this.creator != null) {
            this.tooltipElement = element;
            this.launchThread();
        } else {
            this.hideTooltip();
        }
    }

    public synchronized void hideTooltip() {
        if (this.tooltipShowing && this.creator instanceof FocusableTooltipProvider && ((FocusableTooltipProvider)this.creator).hasFocus()) {
            return;
        }
        if (this.creator != null && this.tooltipShowing) {
            this.creator.hideTooltip(this.tooltipElement);
        }
        this.creator = null;
        this.tooltipElement = null;
        this.tooltipShowing = false;
    }
}

