/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.image;

import java.awt.GraphicsConfiguration;
import java.awt.image.BufferedImage;
import org.simantics.g2d.image.Image;
import org.simantics.g2d.image.impl.AWTImage;
import org.simantics.g2d.image.impl.ImageProxy;
import org.simantics.g2d.image.impl.MipMapBufferedImage;
import org.simantics.g2d.image.impl.MipMapVRamBufferedImage;
import org.simantics.g2d.image.impl.Shadow;
import org.simantics.g2d.image.impl.VRamBufferedImage;

public class ImageUtils {
    public static Image adaptAWT(BufferedImage awtImage) {
        return new AWTImage(awtImage);
    }

    public static Image createBuffer(Image source) {
        return new MipMapBufferedImage(source);
    }

    public static Image createProxy(Image source) {
        return new ImageProxy(source);
    }

    public static Image createShadow(Image source, Shadow.ShadowParameters shadow) {
        return new Shadow(source, shadow);
    }

    public static Image createShadow(Image source, Shadow.ShadowParameters shadow, int width, int height) {
        return new Shadow(source, shadow, width, height);
    }

    public static Image createVideoMemoryBuffer(Image ps, GraphicsConfiguration gc) {
        ImageProxy p;
        if (gc == null) {
            throw new IllegalArgumentException("null arg");
        }
        if (ps instanceof VRamBufferedImage) {
            p = (VRamBufferedImage)ps;
            if (((VRamBufferedImage)p).getGraphicsConfiguration() != gc) {
                ps = ((VRamBufferedImage)p).getSource();
            } else {
                return ps;
            }
        }
        if (ps instanceof MipMapVRamBufferedImage) {
            p = (MipMapVRamBufferedImage)ps;
            if (((MipMapVRamBufferedImage)p).getGraphicsConfiguration() != gc) {
                ps = ((MipMapVRamBufferedImage)p).getSource();
            } else {
                return ps;
            }
        }
        if (ps.getFeatures().contains((Object)Image.Feature.Vector)) {
            return new MipMapVRamBufferedImage(ps, gc);
        }
        return new VRamBufferedImage(ps, gc);
    }
}

