/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.ResourceMap;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.SubgraphExtent;
import org.simantics.db.layer0.util.TransferableGraphConfiguration2;
import org.simantics.db.procedure.AsyncContextMultiProcedure;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.request.Read;
import org.simantics.db.service.DirectQuerySupport;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.Pair;

class ConsistsOfProcess {
    final List<ConsistsOfProcessEntry> result;
    final Set<Resource> childrenWithNoName;
    final AsyncContextMultiProcedure<ConsistsOfProcessEntry, Resource> structure;
    final AsyncContextMultiProcedure<ConsistsOfProcessEntry, Resource> names;

    public static Pair<List<ConsistsOfProcessEntry>, Set<Resource>> walk(ReadGraph graph, Collection<TransferableGraphConfiguration2.SeedSpec> specs, boolean ignoreVirtual) throws DatabaseException {
        return ConsistsOfProcess.walk(graph, null, specs, ignoreVirtual);
    }

    public static Pair<List<ConsistsOfProcessEntry>, Set<Resource>> walk(ReadGraph graph, ResourceMap<SubgraphExtent.ExtentStatus> status, Collection<TransferableGraphConfiguration2.SeedSpec> specs, boolean ignoreVirtual) throws DatabaseException {
        ConsistsOfProcess process = new ConsistsOfProcess(graph, status, specs, ignoreVirtual);
        return Pair.make(process.result, process.childrenWithNoName);
    }

    private ConsistsOfProcess(ReadGraph graph, final ResourceMap<SubgraphExtent.ExtentStatus> status, final Collection<TransferableGraphConfiguration2.SeedSpec> seeds, final boolean ignoreVirtual) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        final DirectQuerySupport dqs = (DirectQuerySupport)graph.getService(DirectQuerySupport.class);
        this.result = new ArrayList<ConsistsOfProcessEntry>();
        this.childrenWithNoName = new HashSet<Resource>();
        this.names = dqs.compileForEachObject(graph, L0.HasName, (AsyncContextMultiProcedure)new AsyncContextMultiProcedure<ConsistsOfProcessEntry, Resource>(){

            public void execute(AsyncReadGraph graph, final ConsistsOfProcessEntry entry, Resource nameResource) {
                if (status != null) {
                    status.put((Object)nameResource, (Object)SubgraphExtent.ExtentStatus.EXCLUDED);
                }
                graph.forPossibleValue(nameResource, (Procedure)new Procedure<String>(){

                    public void execute(String name) {
                        if (!entry.valid) {
                            return;
                        }
                        if (name == null) {
                            entry.valid = false;
                        } else if (entry.name != null) {
                            entry.valid = false;
                        } else {
                            entry.name = name;
                        }
                    }

                    public void exception(Throwable t) {
                        Logger.defaultLogError((Throwable)t);
                    }
                });
            }

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                Logger.defaultLogError((Throwable)throwable);
            }

            public void finished(AsyncReadGraph graph, ConsistsOfProcessEntry entry) {
                if (entry.valid) {
                    if (entry.name != null) {
                        ConsistsOfProcess.this.result.add(entry);
                    } else {
                        ConsistsOfProcess.this.childrenWithNoName.add(entry.resource);
                    }
                } else {
                    ConsistsOfProcess.this.childrenWithNoName.add(entry.resource);
                }
            }
        });
        this.structure = dqs.compileForEachObject(graph, L0.ConsistsOf, (AsyncContextMultiProcedure)new AsyncContextMultiProcedure<ConsistsOfProcessEntry, Resource>(){

            public void execute(AsyncReadGraph graph, ConsistsOfProcessEntry parent, Resource child) {
                if (status != null && SubgraphExtent.ExtentStatus.EXCLUDED.equals(status.get((Object)child))) {
                    return;
                }
                if (!ignoreVirtual || child.isPersistent()) {
                    ConsistsOfProcessEntry entry = new ConsistsOfProcessEntry(parent, child);
                    dqs.forEachObjectCompiled(graph, child, (Object)entry, ConsistsOfProcess.this.structure);
                    dqs.forEachObjectCompiled(graph, child, (Object)entry, ConsistsOfProcess.this.names);
                }
            }

            public void finished(AsyncReadGraph graph, ConsistsOfProcessEntry parent) {
            }

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                Logger.defaultLogError((Throwable)throwable);
            }
        });
        graph.syncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                for (TransferableGraphConfiguration2.SeedSpec seed : seeds) {
                    SubgraphExtent.ExtentStatus es;
                    if (status != null && (SubgraphExtent.ExtentStatus.EXCLUDED.equals((Object)(es = (SubgraphExtent.ExtentStatus)((Object)status.get((Object)seed.resource)))) || SubgraphExtent.ExtentStatus.EXTERNAL.equals((Object)es))) continue;
                    ConsistsOfProcessEntry entry = new ConsistsOfProcessEntry(null, seed.resource);
                    dqs.forEachObjectCompiled((AsyncReadGraph)graph, seed.resource, (Object)entry, ConsistsOfProcess.this.structure);
                    if (!TransferableGraphConfiguration2.SeedSpec.SeedSpecType.INTERNAL.equals((Object)seed.specType)) continue;
                    dqs.forEachObjectCompiled((AsyncReadGraph)graph, seed.resource, (Object)entry, ConsistsOfProcess.this.names);
                }
            }
        });
    }

    static class ConsistsOfProcessEntry {
        public ConsistsOfProcessEntry parent;
        public Resource resource;
        public boolean valid = true;
        public String name = null;

        ConsistsOfProcessEntry(ConsistsOfProcessEntry parent, Resource resource) {
            this.parent = parent;
            this.resource = resource;
        }
    }
}

