/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.genericrelation.combinators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.GenericRelation;
import org.simantics.db.layer0.genericrelation.AbstractRelation;
import org.simantics.utils.datastructures.Pair;

public class Intersection
extends AbstractRelation {
    GenericRelation realizable = null;
    Collection<GenericRelation> constraints;

    public Intersection(Collection<GenericRelation> relations) {
        for (GenericRelation relation : relations) {
            if (this.realizable == null && relation.isRealizable()) {
                this.realizable = relation;
                continue;
            }
            this.constraints.add(relation);
        }
    }

    public Intersection(GenericRelation realizable, Collection<GenericRelation> constraints) {
        assert (realizable.isRealizable());
        this.realizable = realizable;
        this.constraints = constraints;
    }

    @Override
    public boolean contains(ReadGraph g, Object[] tuple) throws DatabaseException {
        if (!this.realizable.contains(g, tuple)) {
            return false;
        }
        for (GenericRelation relation : this.constraints) {
            if (relation.contains(g, tuple)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isRealizable() {
        return this.realizable != null;
    }

    @Override
    public List<Object[]> realize(ReadGraph g) throws DatabaseException {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        block0: for (Object[] tuple : this.realizable.realize(g)) {
            for (GenericRelation constraint : this.constraints) {
                if (!constraint.contains(g, tuple)) continue block0;
            }
            result.add(tuple);
        }
        return result;
    }

    @Override
    public GenericRelation selectByRelation(String bindingPattern, GenericRelation constraint) {
        if (this.realizable != null) {
            return new Intersection(this.realizable.selectByRelation(bindingPattern, constraint), this.constraints);
        }
        return super.selectByRelation(bindingPattern, constraint);
    }

    @Override
    public Pair<String, String>[] getFields() {
        if (this.realizable != null) {
            return this.realizable.getFields();
        }
        Iterator<GenericRelation> iterator = this.constraints.iterator();
        if (iterator.hasNext()) {
            GenericRelation relation = iterator.next();
            return relation.getFields();
        }
        return null;
    }
}

