/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.modelBrowser;

import java.util.Collections;
import java.util.Map;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.browsing.ui.content.LabelerFactory;
import org.simantics.browsing.ui.graph.impl.LazyGraphLabeler;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.modeling.ui.modelBrowser.model.INode;
import org.simantics.ui.SimanticsUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NodeLabelerFactory
implements LabelerFactory {
    NodeLabelerFactory() {
    }

    public Labeler create(PrimitiveQueryUpdater updater, final NodeContext context, BuiltinKeys.LabelerKey key) {
        return new LazyGraphLabeler(updater, context, key){

            public Object getIdentity(BuiltinKeys.LabelerKey key) {
                return NodeLabelerFactory.this.getClass();
            }

            public Map<String, String> labels(ReadGraph graph) throws DatabaseException {
                return Collections.singletonMap("single", ((INode)context.getConstant(BuiltinKeys.INPUT)).getLabel(graph));
            }

            public Labeler.Modifier getModifier(GraphExplorer.ModificationContext sourcePart, String key) {
                return ((INode)context.getConstant(BuiltinKeys.INPUT)).getModifier(SimanticsUI.getSession(), key);
            }

            public int category(ReadGraph graph) throws DatabaseException {
                return ((INode)context.getConstant(BuiltinKeys.INPUT)).getCategory(graph);
            }

            public Logger getLogger() {
                return LoggerFactory.getLogger(NodeLabelerFactory.class);
            }
        };
    }
}

