/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.componentTypeEditor;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collections;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.scl.SCLDatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ui.Activator;
import org.simantics.modeling.ui.componentTypeEditor.ProceduralComponentTypeCodeEditor;
import org.simantics.modeling.ui.componentTypeEditor.SCLModuleEditorDocumentProvider;
import org.simantics.modeling.userComponent.ComponentTypeCommands;
import org.simantics.scl.compiler.errors.CompilationError;
import org.simantics.scl.ui.editor.SCLSourceViewerConfigurationNew;
import org.simantics.scl.ui.editor.TextAndErrors;
import org.simantics.structural2.scl.procedural.CompileProceduralComponentTypeRequest;
import org.simantics.structural2.scl.procedural.ProceduralComponentTypeCompilationException;
import org.simantics.ui.workbench.ResourceEditorInput;
import org.simantics.utils.logging.TimeLogger;
import org.simantics.utils.ui.SWTUtils;

public class ProceduralComponentTypeCodeDocumentProvider
extends SCLModuleEditorDocumentProvider {
    Display display;
    ProceduralComponentTypeCodeEditor editor;

    public ProceduralComponentTypeCodeDocumentProvider(SCLSourceViewerConfigurationNew sourceViever, Display display, ProceduralComponentTypeCodeEditor editor) {
        super(sourceViever);
        this.display = display;
        this.editor = editor;
    }

    @Override
    protected IDocument createDocument(Object element) throws CoreException {
        ResourceEditorInput input = (ResourceEditorInput)element;
        this.resource = input.getResource();
        try {
            return (IDocument)Simantics.getSession().syncRequest((Read)new UniqueRead<Document>(){

                public Document perform(ReadGraph graph) throws DatabaseException {
                    ProceduralComponentTypeCodeDocumentProvider.this.currentText = (String)graph.getValue(ProceduralComponentTypeCodeDocumentProvider.this.resource, (Binding)Bindings.STRING);
                    ProceduralComponentTypeCodeDocumentProvider.this.errorHappened = false;
                    return new Document(ProceduralComponentTypeCodeDocumentProvider.this.currentText != null ? ProceduralComponentTypeCodeDocumentProvider.this.currentText : "");
                }
            });
        }
        catch (DatabaseException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            this.errorHappened = true;
            return new Document(sw.toString());
        }
    }

    @Override
    protected void updateAnnotations() {
        Simantics.getSession().asyncRequest((Read)new ResourceRead<TextAndErrors>(this.resource){

            public TextAndErrors perform(ReadGraph graph) throws DatabaseException {
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                String text = (String)graph.getValue(this.resource, (Binding)Bindings.STRING);
                Resource componentType = graph.getPossibleObject(this.resource, L0.PropertyOf);
                CompilationError[] errors = CompilationError.EMPTY_ARRAY;
                if (componentType != null) {
                    try {
                        graph.syncRequest((Read)new CompileProceduralComponentTypeRequest(componentType));
                    }
                    catch (SCLDatabaseException e) {
                        errors = e.compilationErrors;
                    }
                    catch (ProceduralComponentTypeCompilationException e) {
                        errors = e.errors;
                    }
                }
                return new TextAndErrors(text, errors);
            }
        }, (Listener)new Listener<TextAndErrors>(){

            public void execute(final TextAndErrors textAndErrors) {
                if (ProceduralComponentTypeCodeDocumentProvider.this.editor.isDisposed()) {
                    return;
                }
                SWTUtils.asyncExec((Display)ProceduralComponentTypeCodeDocumentProvider.this.display, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if ((this).ProceduralComponentTypeCodeDocumentProvider.this.editor.isDisposed()) {
                            return;
                        }
                        if (textAndErrors.errors.length > 0) {
                            ProceduralComponentTypeCodeDocumentProvider.this.setAnnotations(Arrays.asList(textAndErrors.errors));
                        } else {
                            ProceduralComponentTypeCodeDocumentProvider.this.setAnnotations(Collections.emptyList());
                        }
                    }
                });
            }

            public void exception(Throwable t) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.modeling.ui", "Internal error in procedural user component code compilation.", t));
            }

            public boolean isDisposed() {
                return ProceduralComponentTypeCodeDocumentProvider.this.editor.isDisposed();
            }
        });
    }

    @Override
    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        TimeLogger.resetTimeAndLog(((Object)((Object)this)).getClass(), (String)"doSaveDocument");
        this.currentText = document.get();
        Simantics.getSession().asyncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                graph.markUndoPoint();
                ComponentTypeCommands.saveProceduralCode((WriteGraph)graph, (Resource)ProceduralComponentTypeCodeDocumentProvider.this.resource, (String)ProceduralComponentTypeCodeDocumentProvider.this.currentText);
            }
        });
    }
}

