/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.content;

import java.util.Collection;
import org.simantics.browsing.ui.content.LabelDecorator;

public class CompositeLabelDecorator
implements LabelDecorator {
    Collection<LabelDecorator> decorators;
    public static final LabelDecorator ID = new LabelDecorator(){

        @Override
        public String decorateLabel(String label, String column, int itemIndex) {
            return label;
        }

        @Override
        public <Color> Color decorateForeground(Color color, String column, int itemIndex) {
            return color;
        }

        @Override
        public <Color> Color decorateBackground(Color color, String column, int itemIndex) {
            return color;
        }

        @Override
        public <Font> Font decorateFont(Font font, String column, int itemIndex) {
            return font;
        }
    };

    private CompositeLabelDecorator(Collection<LabelDecorator> decorators) {
        this.decorators = decorators;
    }

    public static LabelDecorator create(Collection<LabelDecorator> decorators) {
        if (decorators.isEmpty()) {
            return ID;
        }
        if (decorators.size() == 1) {
            return decorators.iterator().next();
        }
        return new CompositeLabelDecorator(decorators);
    }

    @Override
    public String decorateLabel(String label, String column, int itemIndex) {
        for (LabelDecorator decorator : this.decorators) {
            String dlabel = decorator.decorateLabel(label, column, itemIndex);
            if (dlabel == null) continue;
            label = dlabel;
        }
        return label;
    }

    @Override
    public <Color> Color decorateForeground(Color color, String column, int itemIndex) {
        for (LabelDecorator decorator : this.decorators) {
            Color dcolor = decorator.decorateForeground(color, column, itemIndex);
            if (dcolor == null) continue;
            color = dcolor;
        }
        return color;
    }

    @Override
    public <Color> Color decorateBackground(Color color, String column, int itemIndex) {
        for (LabelDecorator decorator : this.decorators) {
            Color dcolor = decorator.decorateBackground(color, column, itemIndex);
            if (dcolor == null) continue;
            color = dcolor;
        }
        return color;
    }

    @Override
    public <Font> Font decorateFont(Font font, String column, int itemIndex) {
        for (LabelDecorator decorator : this.decorators) {
            Font dfont = decorator.decorateFont(font, column, itemIndex);
            if (dfont == null) continue;
            font = dfont;
        }
        return font;
    }
}

