/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.selectionview;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Consumer;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.browsing.ui.DataSource;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.NodeQueryProcessor;
import org.simantics.browsing.ui.PrimitiveQueryProcessor;
import org.simantics.browsing.ui.common.EvaluatorData;
import org.simantics.browsing.ui.common.EvaluatorDataImpl;
import org.simantics.browsing.ui.common.comparators.AlphanumericComparatorFactory;
import org.simantics.browsing.ui.common.processors.ComparableFactoryResolver;
import org.simantics.browsing.ui.common.processors.ComparableSelectorQueryProcessor;
import org.simantics.browsing.ui.common.processors.FilterSelectionRequestQueryProcessor;
import org.simantics.browsing.ui.common.processors.ImageDecoratorFactoryResolver;
import org.simantics.browsing.ui.common.processors.ImagerFactoryResolver;
import org.simantics.browsing.ui.common.processors.LabelDecoratorFactoryResolver;
import org.simantics.browsing.ui.common.processors.LabelerFactoryResolver;
import org.simantics.browsing.ui.common.processors.UserSelectedComparableFactoryQueryProcessor;
import org.simantics.browsing.ui.common.processors.UserSelectedViewpointFactoryQueryProcessor;
import org.simantics.browsing.ui.common.processors.ViewpointFactoryResolver;
import org.simantics.browsing.ui.common.views.IFilterArea;
import org.simantics.browsing.ui.common.views.IFilterAreaProvider;
import org.simantics.browsing.ui.common.views.PropertyTableConstants;
import org.simantics.browsing.ui.content.ComparableContextFactory;
import org.simantics.browsing.ui.content.ImagerFactory;
import org.simantics.browsing.ui.content.LabelerFactory;
import org.simantics.browsing.ui.content.ViewpointFactory;
import org.simantics.browsing.ui.graph.impl.ArrayPropertyLabelerFactory;
import org.simantics.browsing.ui.graph.impl.ArrayPropertyValueViewpointFactory;
import org.simantics.browsing.ui.graph.impl.AsyncReadGraphDataSource;
import org.simantics.browsing.ui.graph.impl.PropertyViewpointFactory;
import org.simantics.browsing.ui.graph.impl.ReadGraphDataSource;
import org.simantics.browsing.ui.graph.impl.RelationContextLabelerFactory;
import org.simantics.browsing.ui.graph.impl.ResourceProperty;
import org.simantics.browsing.ui.graph.impl.StringRepresentationLabelerFactory;
import org.simantics.browsing.ui.swt.ArrayPropertyImagerFactory;
import org.simantics.browsing.ui.swt.ComparatorSelector;
import org.simantics.browsing.ui.swt.ContextMenuInitializer;
import org.simantics.browsing.ui.swt.GraphExplorerFactory;
import org.simantics.browsing.ui.swt.PropertyTableUtil;
import org.simantics.browsing.ui.swt.RootFilterArea;
import org.simantics.browsing.ui.swt.TypesQueryProcessor;
import org.simantics.browsing.ui.swt.ViewpointSelector;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.AsyncRequestProcessor;
import org.simantics.db.ReadGraph;
import org.simantics.db.RelationContext;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.Statement;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.management.ISessionContext;
import org.simantics.selectionview.IPropertyTab2;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.utils.ObjectUtils;
import org.simantics.utils.ui.LayoutUtils;

public class PropertyTable
extends Composite
implements IFilterAreaProvider,
IPropertyTab2 {
    protected IWorkbenchSite site;
    protected GraphExplorer explorer;
    protected Object dragSource;
    protected ISessionContext sessionContext;
    protected ISelection currentInput;
    protected UserSelectedComparableFactoryQueryProcessor userSelectedComparableFactoryQueryProcessor;
    protected UserSelectedViewpointFactoryQueryProcessor userSelectedViewpointFactoryQueryProcessor;
    protected FilterSelectionRequestQueryProcessor filterSelectionRequestQueryProcessor;
    protected LocalResourceManager resourceManager;
    private RootFilterArea filterArea;
    private IContributionItem filterAreaContribution;
    private IActionBars actionBars;

    public PropertyTable(IWorkbenchSite site, Composite parent, int style) {
        super(parent, style);
        this.site = site;
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources((Display)parent.getDisplay()));
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                PropertyTable.this.tableDisposed();
                PropertyTableUtil.setupDragSource((Object)PropertyTable.this.dragSource, null);
                PropertyTable.this.site = null;
                PropertyTable.this.explorer = null;
                PropertyTable.this.dragSource = null;
                PropertyTable.this.sessionContext = null;
                PropertyTable.this.currentInput = null;
                PropertyTable.this.userSelectedComparableFactoryQueryProcessor = null;
                PropertyTable.this.userSelectedViewpointFactoryQueryProcessor = null;
                PropertyTable.this.filterSelectionRequestQueryProcessor = null;
                PropertyTable.this.resourceManager.dispose();
            }
        });
    }

    protected void tableDisposed() {
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (PropertyTable.this.filterAreaContribution != null) {
                    PropertyTable.this.actionBars.getToolBarManager().remove(PropertyTable.this.filterAreaContribution);
                    PropertyTable.this.filterAreaContribution.dispose();
                    PropertyTable.this.filterAreaContribution = null;
                    PropertyTable.this.actionBars.updateActionBars();
                }
            }
        });
    }

    @Override
    public Control getControl() {
        return this;
    }

    @Override
    public void createControl(Composite parent, ISessionContext context) {
        this.explorer = this.createExplorerControl(parent);
        this.dragSource = this.createDragSource(this.explorer);
        Control control = (Control)this.explorer.getControl();
        this.userSelectedComparableFactoryQueryProcessor = new UserSelectedComparableFactoryQueryProcessor();
        this.userSelectedViewpointFactoryQueryProcessor = new UserSelectedViewpointFactoryQueryProcessor();
        this.filterSelectionRequestQueryProcessor = new FilterSelectionRequestQueryProcessor();
        parent.setLayout((Layout)LayoutUtils.createNoBorderGridLayout((int)2, (boolean)false));
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo(control);
        this.addControls(parent);
        this.setSessionContext(context);
    }

    protected void addControls(Composite parent) {
    }

    protected void createSelectors(Composite parent) {
        Control control = (Control)this.explorer.getControl();
        ComparatorSelector comparatorSelector = new ComparatorSelector(this.explorer, this.userSelectedComparableFactoryQueryProcessor, parent, 8);
        comparatorSelector.moveAbove(control);
        ViewpointSelector viewpointSelector = new ViewpointSelector(this.explorer, this.userSelectedViewpointFactoryQueryProcessor, parent, 8);
        viewpointSelector.moveAbove(control);
    }

    protected void createFilterArea(IActionBars actionBars) {
        this.filterAreaContribution = new ContributionItem("filterArea"){
            ToolItem item;

            public boolean isDynamic() {
                return true;
            }

            public final void fill(ToolBar parent, int index) {
                Control control = this.createControl((Composite)parent);
                this.item = new ToolItem(parent, 2, index);
                this.item.setControl(control);
                this.item.setWidth(this.computeWidth(control));
            }

            protected Control createControl(Composite parent) {
                PropertyTable.this.filterArea = new RootFilterArea(PropertyTable.this.explorer, PropertyTable.this.filterSelectionRequestQueryProcessor, parent, 0);
                return PropertyTable.this.filterArea;
            }

            protected int computeWidth(Control control) {
                return control.computeSize((int)150, (int)-1, (boolean)true).x;
            }

            public void dispose() {
                if (PropertyTable.this.filterArea != null) {
                    PropertyTable.this.filterArea.dispose();
                    PropertyTable.this.filterArea = null;
                }
                if (this.item != null) {
                    this.item.dispose();
                    this.item = null;
                }
            }
        };
        this.actionBars = actionBars;
        actionBars.getToolBarManager().add(this.filterAreaContribution);
    }

    protected void createFilterArea(Composite parent) {
        Control control = (Control)this.explorer.getControl();
        this.filterArea = new RootFilterArea(this.explorer, this.filterSelectionRequestQueryProcessor, parent, 0);
        this.filterArea.moveAbove(control);
    }

    protected GraphExplorer createExplorerControl(Composite parent) {
        GraphExplorer e = GraphExplorerFactory.getInstance().create(parent, 65536);
        Control c = (Control)e.getControl();
        ISelectionProvider selectionProvider = (ISelectionProvider)e.getAdapter(ISelectionProvider.class);
        new ContextMenuInitializer("#PropertiesPopup").createContextMenu(c, selectionProvider, this.site);
        if (c instanceof Tree) {
            ((Tree)c).setLinesVisible(true);
        }
        e.setColumns(PropertyTableConstants.NORMAL_COLUMNS);
        return e;
    }

    protected Object createDragSource(GraphExplorer explorer) {
        Control c = (Control)explorer.getControl();
        DragSource existingSource = (DragSource)c.getData("DragSource");
        if (existingSource != null) {
            return existingSource;
        }
        return PropertyTableUtil.createResourceDragSource((GraphExplorer)explorer);
    }

    protected void setupDragSource(ISessionContext sessionContext) {
        PropertyTableUtil.setupDragSource((Object)this.dragSource, (ISessionContext)sessionContext);
    }

    @Override
    public ISelectionProvider getSelectionProvider() {
        GraphExplorer e = this.explorer;
        if (e != null) {
            IPostSelectionProvider selectionProvider = (IPostSelectionProvider)e.getAdapter(IPostSelectionProvider.class);
            return selectionProvider;
        }
        return null;
    }

    @Override
    public void requestFocus() {
        GraphExplorer e = this.explorer;
        if (e != null) {
            e.setFocus();
        }
    }

    public IFilterArea getFilterArea() {
        return this.filterArea;
    }

    protected ISessionContext getSessionContext() {
        return this.sessionContext;
    }

    protected Session getSession() {
        return this.sessionContext != null ? this.sessionContext.getSession() : null;
    }

    @Override
    public void setInput(ISessionContext context, ISelection selection, boolean force) {
        if (this.isDisposed()) {
            return;
        }
        if (this.sessionContext == null) {
            return;
        }
        if (!force && ObjectUtils.objectEquals((Object)this.currentInput, (Object)selection)) {
            return;
        }
        Object[] rs = this.toObjects(selection);
        if (rs.length == 0) {
            this.explorer.setRoot(GraphExplorer.EMPTY_INPUT);
        } else if (rs.length == 1) {
            this.explorer.setRoot(rs[0]);
        } else {
            this.explorer.setRoot((Object)rs);
        }
        this.currentInput = selection;
    }

    protected Object[] toObjects(ISelection s) {
        Object[] ras = ResourceAdaptionUtils.toResourceArrays((Object)s);
        if (ras.length > 0) {
            return ras;
        }
        Object[] rs = ResourceAdaptionUtils.toResources((Object)s);
        if (rs.length > 0) {
            return rs;
        }
        if (!(s instanceof IStructuredSelection)) {
            return new Object[0];
        }
        IStructuredSelection ss = (IStructuredSelection)s;
        ArrayList result = new ArrayList();
        Iterator iterator = ss.iterator();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        return result.toArray();
    }

    public void setSessionContext(ISessionContext sessionContext) {
        if (this.isDisposed()) {
            return;
        }
        if (this.sessionContext == sessionContext) {
            return;
        }
        this.sessionContext = sessionContext;
        Session session = sessionContext != null ? sessionContext.getSession() : null;
        this.reinitializeExplorer(this.explorer, sessionContext, session);
    }

    protected void reinitializeExplorer(GraphExplorer explorer, ISessionContext sessionContext, Session session) {
        if (this.isDisposed()) {
            return;
        }
        this.setupDragSource(sessionContext);
        EvaluatorDataImpl data = new EvaluatorDataImpl();
        if (session != null) {
            explorer.setDataSource((DataSource)new AsyncReadGraphDataSource((AsyncRequestProcessor)session));
            explorer.setDataSource((DataSource)new ReadGraphDataSource((AsyncRequestProcessor)session));
            EvaluatorData.Evaluator resourceEvaluator = data.newEvaluator().addViewpoint((ViewpointFactory)new PropertyViewpointFactory(), 1.0).addComparator((ComparableContextFactory)new AlphanumericComparatorFactory("Property"), 2.0).addComparator((ComparableContextFactory)new AlphanumericComparatorFactory("Property", true), 1.0).addLabeler((LabelerFactory)new StringRepresentationLabelerFactory("Property"), 1.0);
            EvaluatorData.Evaluator statementEvaluator = data.newEvaluator().addViewpoint((ViewpointFactory)new PropertyViewpointFactory(), 1.0).addComparator((ComparableContextFactory)new AlphanumericComparatorFactory("Property"), 2.0).addComparator((ComparableContextFactory)new AlphanumericComparatorFactory("Property", true), 1.0);
            EvaluatorData.Evaluator relationContextEvaluator = data.newEvaluator().addLabeler((LabelerFactory)new RelationContextLabelerFactory(), 1.0);
            EvaluatorData.Evaluator propertyEvaluator = data.newEvaluator().addViewpoint((ViewpointFactory)new ArrayPropertyValueViewpointFactory(), 1.0).addLabeler((LabelerFactory)new ArrayPropertyLabelerFactory(), 1.0).addImager((ImagerFactory)new ArrayPropertyImagerFactory(), 1.0);
            data.addEvaluator(Resource.class, resourceEvaluator);
            data.addEvaluator(ResourceArray.class, resourceEvaluator);
            data.addEvaluator(Statement.class, statementEvaluator);
            data.addEvaluator(RelationContext.class, relationContextEvaluator);
            data.addEvaluator(ResourceProperty.class, propertyEvaluator);
        } else {
            explorer.removeDataSource(AsyncReadGraph.class);
            explorer.removeDataSource(ReadGraph.class);
        }
        explorer.setProcessor((NodeQueryProcessor)new ComparableFactoryResolver((EvaluatorData)data));
        explorer.setProcessor((NodeQueryProcessor)new ViewpointFactoryResolver((EvaluatorData)data));
        explorer.setProcessor((NodeQueryProcessor)new LabelerFactoryResolver((EvaluatorData)data));
        explorer.setProcessor((NodeQueryProcessor)new ImagerFactoryResolver((EvaluatorData)data));
        explorer.setProcessor((NodeQueryProcessor)new LabelDecoratorFactoryResolver((EvaluatorData)data));
        explorer.setProcessor((NodeQueryProcessor)new ImageDecoratorFactoryResolver((EvaluatorData)data));
        explorer.setPrimitiveProcessor((PrimitiveQueryProcessor)new TypesQueryProcessor());
        explorer.setPrimitiveProcessor((PrimitiveQueryProcessor)this.userSelectedViewpointFactoryQueryProcessor);
        explorer.setProcessor((NodeQueryProcessor)new ComparableSelectorQueryProcessor());
        explorer.setPrimitiveProcessor((PrimitiveQueryProcessor)this.userSelectedComparableFactoryQueryProcessor);
        explorer.setPrimitiveProcessor((PrimitiveQueryProcessor)this.filterSelectionRequestQueryProcessor);
        explorer.setRoot(GraphExplorer.EMPTY_INPUT);
    }

    @Override
    public void updatePartName(Consumer<String> updateCallback) {
        ISelection forSelection = this.currentInput;
        if (forSelection instanceof IStructuredSelection) {
            IStructuredSelection s = (IStructuredSelection)forSelection;
            int size = s.size();
            if (size == 1) {
                Object obj = s.getFirstElement();
                if (obj != null) {
                    updateCallback.accept(obj.toString());
                } else {
                    updateCallback.accept("Properties");
                }
            } else {
                updateCallback.accept("Properties [" + size + "]");
            }
        } else {
            updateCallback.accept("Properties");
        }
    }
}

