/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.Simantics;
import org.simantics.browsing.ui.swt.ModelledAction;
import org.simantics.browsing.ui.swt.ModelledWizardPage;
import org.simantics.browsing.ui.swt.stubs.BrowsingResource;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.primitiverequest.PossibleAdapter;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.request.Read;

public class ModelledWizard
extends Wizard
implements ModelledAction {
    final Resource configuration;
    private final ArrayList<IWizardPage> pages = new ArrayList();
    private Runnable finishAction;

    public ModelledWizard(Resource configuration) {
        this.setNeedsProgressMonitor(true);
        this.configuration = configuration;
    }

    public void addPages() {
        super.addPages();
        for (IWizardPage page : this.pages) {
            this.addPage(page);
        }
    }

    public boolean performFinish() {
        return true;
    }

    @Override
    public Runnable create(IWorkbenchSite site, ISessionContext context, final WidgetSupport support) throws DatabaseException {
        String title = (String)Simantics.getSession().syncRequest((Read)new Read<String>(){

            public String perform(ReadGraph graph) throws DatabaseException {
                BrowsingResource br = BrowsingResource.getInstance((ReadGraph)graph);
                return (String)graph.getPossibleRelatedValue(ModelledWizard.this.configuration, br.Wizard_Title, (Binding)Bindings.STRING);
            }
        });
        this.setWindowTitle(title);
        List pageResources = (List)Simantics.getSession().syncRequest((Read)new Read<List<Resource>>(){

            public List<Resource> perform(ReadGraph graph) throws DatabaseException {
                BrowsingResource br = BrowsingResource.getInstance((ReadGraph)graph);
                Resource pageList = graph.getPossibleObject(ModelledWizard.this.configuration, br.Wizard_Pages);
                if (pageList == null) {
                    return Collections.emptyList();
                }
                return OrderedSetUtils.toList((ReadGraph)graph, (Resource)pageList);
            }
        });
        for (Resource page : pageResources) {
            ModelledWizardPage p = (ModelledWizardPage)Simantics.getSession().syncRequest((AsyncRead)new PossibleAdapter(page, ModelledWizardPage.class));
            this.pages.add(p.create(context, support));
        }
        ModelledAction finishAction = (ModelledAction)Simantics.getSession().syncRequest((Read)new Read<ModelledAction>(){

            public ModelledAction perform(ReadGraph graph) throws DatabaseException {
                BrowsingResource BRO = BrowsingResource.getInstance((ReadGraph)graph);
                Resource actionResource = graph.getPossibleObject(ModelledWizard.this.configuration, BRO.Wizard_FinishAction);
                return (ModelledAction)graph.adapt(actionResource, ModelledAction.class);
            }
        });
        this.finishAction = finishAction.create(null, null, support);
        return new Runnable(){

            @Override
            public void run() {
                WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)ModelledWizard.this);
                dialog.create();
                support.update();
                dialog.open();
                if (ModelledWizard.this.finishAction != null) {
                    ModelledWizard.this.finishAction.run();
                }
            }
        };
    }
}

