/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.event.view.preference;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.event.ontology.EventViewResource;

public final class EventPrefs {
    public static boolean hideInfoEvents(ReadGraph graph, Resource project) throws DatabaseException {
        return EventPrefs.testBoolean(graph, project, EventViewResource.getInstance((ReadGraph)graph).HideInfoEvents);
    }

    public static boolean hideWarningEvents(ReadGraph graph, Resource project) throws DatabaseException {
        return EventPrefs.testBoolean(graph, project, EventViewResource.getInstance((ReadGraph)graph).HideWarningEvents);
    }

    public static boolean hideReturnEvents(ReadGraph graph, Resource project) throws DatabaseException {
        return EventPrefs.testBoolean(graph, project, EventViewResource.getInstance((ReadGraph)graph).HideReturnEvents);
    }

    public static boolean showHiddenEvents(ReadGraph graph, Resource project) throws DatabaseException {
        return EventPrefs.testBoolean(graph, project, EventViewResource.getInstance((ReadGraph)graph).ShowHiddenEvents);
    }

    public static boolean showOnlyMilestones(ReadGraph graph, Resource project) throws DatabaseException {
        return EventPrefs.testBoolean(graph, project, EventViewResource.getInstance((ReadGraph)graph).ShowOnlyMilestones);
    }

    public static boolean showOnlyActiveEvents(ReadGraph graph, Resource project) throws DatabaseException {
        return EventPrefs.testBoolean(graph, project, EventViewResource.getInstance((ReadGraph)graph).ShowOnlyActiveEvents);
    }

    private static boolean testBoolean(ReadGraph graph, Resource project, Resource property) throws DatabaseException {
        if (project == null) {
            return false;
        }
        return Boolean.TRUE.equals(graph.getPossibleRelatedValue(project, property, (Binding)Bindings.BOOLEAN));
    }

    public static void setHideInfoEvents(WriteGraph graph, Resource project, boolean show) throws DatabaseException {
        EventPrefs.setBoolean(graph, project, EventViewResource.getInstance((ReadGraph)graph).HideInfoEvents, show);
    }

    public static void setHideWarningEvents(WriteGraph graph, Resource project, boolean show) throws DatabaseException {
        EventPrefs.setBoolean(graph, project, EventViewResource.getInstance((ReadGraph)graph).HideWarningEvents, show);
    }

    public static void setHideReturnEvents(WriteGraph graph, Resource project, boolean show) throws DatabaseException {
        EventPrefs.setBoolean(graph, project, EventViewResource.getInstance((ReadGraph)graph).HideReturnEvents, show);
    }

    public static void setShowHiddenEvents(WriteGraph graph, Resource project, boolean show) throws DatabaseException {
        EventPrefs.setBoolean(graph, project, EventViewResource.getInstance((ReadGraph)graph).ShowHiddenEvents, show);
    }

    public static void setShowOnlyMilestones(WriteGraph graph, Resource project, boolean show) throws DatabaseException {
        EventPrefs.setBoolean(graph, project, EventViewResource.getInstance((ReadGraph)graph).ShowOnlyMilestones, show);
    }

    public static void setShowOnlyActiveEvents(WriteGraph graph, Resource project, boolean show) throws DatabaseException {
        EventPrefs.setBoolean(graph, project, EventViewResource.getInstance((ReadGraph)graph).ShowOnlyActiveEvents, show);
    }

    private static void setBoolean(WriteGraph graph, Resource project, Resource property, boolean value) throws DatabaseException {
        graph.claimLiteral(project, property, (Object)value, (Binding)Bindings.BOOLEAN);
    }
}

