/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.swt.core.widget;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.simantics.document.server.IEventCommand;
import org.simantics.document.server.JSONObject;
import org.simantics.document.server.bean.Command;
import org.simantics.document.server.client.CommandManager;
import org.simantics.document.server.client.WidgetData;
import org.simantics.document.server.handler.AbstractEventHandler;
import org.simantics.document.swt.core.SWTDocument;
import org.simantics.document.swt.core.base.LeafWidgetManager;
import org.simantics.document.swt.core.base.PostEventCommand;
import org.simantics.document.swt.core.base.WidgetContainer;
import org.simantics.document.swt.core.widget.ButtonSelectionListener;

public class ButtonWidget
extends LeafWidgetManager<Button> {
    @Override
    protected void doUpdateProperties(SWTDocument document, Button control, JSONObject object) {
        if (control.isDisposed()) {
            return;
        }
        String text = (String)object.getJSONField("text");
        control.setText(text);
        document.layout();
    }

    @Override
    protected Button doCreateControl(SWTDocument document, Composite parent, JSONObject object) {
        Button label = new Button(parent, 0);
        return label;
    }

    @Override
    public IEventCommand eventCommand(SWTDocument document, JSONObject object, WidgetContainer widget, String command) {
        if ("onPress".equals(command)) {
            AbstractEventHandler onPress = (AbstractEventHandler)object.getJSONField("onPress");
            Map<String, String> data = Collections.emptyMap();
            return new PostEventCommand(document, onPress, data);
        }
        return null;
    }

    public static class ButtonCommandManager
    implements CommandManager<SWTDocument, WidgetContainer<Button>> {
        public Collection<Object> updateCommandListeners(SWTDocument document, JSONObject object, WidgetContainer<Button> container) {
            List commands = (List)object.getJSONField("commands");
            HashSet<Object> listeners = new HashSet<Object>();
            LinkedHashMap<WidgetData, String> data = new LinkedHashMap<WidgetData, String>();
            if (commands != null) {
                for (Command c : commands) {
                    WidgetData wd;
                    String trigger;
                    if (c.getCommand() == null || c.getTargetId() == null || c.getTrigger() == null || !"click".equals(trigger = c.getTrigger()) || (wd = (WidgetData)document.getWidgetData().get(c.getTargetId())) == null) continue;
                    data.put(wd, c.getCommand());
                }
            }
            data.put((WidgetData)document.getWidgetData().get(object.getId()), "onPress");
            ButtonSelectionListener listener = new ButtonSelectionListener(data);
            Button button = container.getControl();
            if (!button.isDisposed()) {
                button.addSelectionListener((SelectionListener)listener);
                listeners.add(listener);
            }
            return listeners;
        }

        public void removeListener(WidgetContainer<Button> container, Object listener) {
            if (container.getControl().isDisposed()) {
                return;
            }
            if (listener instanceof SelectionListener) {
                container.getControl().removeSelectionListener((SelectionListener)listener);
            }
        }
    }
}

