/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.project.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IFilter;
import org.simantics.project.features.registry.GroupReference;
import org.simantics.project.features.registry.IProjectFeatureExtension;
import org.simantics.project.features.registry.IProjectFeatureRegistry;
import org.simantics.project.features.registry.InjectedDependency;
import org.simantics.project.features.registry.ProjectFeatureReference;
import org.simantics.project.internal.ProjectFeatureExtension;
import org.simantics.project.internal.ProjectPolicy;
import org.simantics.utils.strings.StringUtils;

public class ProjectFeatureRegistry
implements IProjectFeatureRegistry,
IExtensionChangeHandler {
    private static final String NAMESPACE = "org.simantics.project";
    private static final String EP_NAME = "feature";
    private static final String FEATURE = "feature";
    private static final String INJECT_DEPENDENCY = "injectDependency";
    private final ExtensionTracker tracker;
    private IProjectFeatureExtension[] extensions = new IProjectFeatureExtension[0];

    public ProjectFeatureRegistry() {
        this.tracker = new ExtensionTracker();
        IExtensionPoint expt = Platform.getExtensionRegistry().getExtensionPoint(NAMESPACE, "feature");
        this.loadExtensions(expt.getConfigurationElements());
        IFilter filter = ExtensionTracker.createExtensionPointFilter((IExtensionPoint)expt);
        this.tracker.registerHandler((IExtensionChangeHandler)this, filter);
    }

    private void loadExtensions(IConfigurationElement[] configurationElements) {
        HashSet<IProjectFeatureExtension> newExtensions = new HashSet<IProjectFeatureExtension>(Arrays.asList(this.extensions));
        IConfigurationElement[] iConfigurationElementArray = configurationElements;
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement el = iConfigurationElementArray[n2];
            if ("feature".equals(el.getName())) {
                String id = StringUtils.safeString((String)el.getAttribute("id"));
                if (ProjectPolicy.TRACE_PROJECT_FEATURE_LOAD) {
                    System.out.println(this + " Trying to load project feature extension id '" + id + "' contributed by " + el.getContributor().getName());
                }
                if (id.isEmpty()) {
                    if (ProjectPolicy.TRACE_PROJECT_FEATURE_LOAD) {
                        System.out.println(this + " skipping feature with empty ID contributed by " + el.getContributor().getName());
                    }
                } else if (StringUtils.safeString((String)el.getAttribute("class")).isEmpty()) {
                    if (ProjectPolicy.TRACE_PROJECT_FEATURE_LOAD) {
                        System.out.println(this + " skipping feature missing 'class' attribute contributed by " + el.getContributor().getName());
                    }
                } else {
                    String label = StringUtils.safeString((String)el.getAttribute("label"));
                    String description = StringUtils.safeString((String)el.getAttribute("description"));
                    boolean published = "true".equalsIgnoreCase(el.getAttribute("published"));
                    Collection<ProjectFeatureReference> requires = this.readProjectFeatureReferenceCollection(el, "requires");
                    Collection<InjectedDependency> injections = this.readInjectedDependencies(el, id);
                    Collection<GroupReference> installGroups = this.readGroupReferenceCollection(el, "installGroup");
                    ProjectFeatureExtension ext = new ProjectFeatureExtension(el, id, label, description, published, requires, injections, installGroups);
                    this.tracker.registerObject(el.getDeclaringExtension(), (Object)ext, 0);
                    newExtensions.add(ext);
                }
            }
            ++n2;
        }
        this.extensions = newExtensions.toArray(new IProjectFeatureExtension[newExtensions.size()]);
    }

    private Collection<InjectedDependency> readInjectedDependencies(IConfigurationElement element, String id) {
        ArrayList<InjectedDependency> result = new ArrayList<InjectedDependency>();
        IConfigurationElement[] iConfigurationElementArray = element.getChildren(INJECT_DEPENDENCY);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            String targetId = StringUtils.safeString((String)child.getAttribute("targetId"));
            if (targetId.isEmpty()) {
                return null;
            }
            result.add(new InjectedDependency(new ProjectFeatureReference(id, false), new ProjectFeatureReference(targetId, false)));
            ++n2;
        }
        return result;
    }

    private Collection<ProjectFeatureReference> readProjectFeatureReferenceCollection(IConfigurationElement element, String childName) {
        ArrayList<ProjectFeatureReference> result = new ArrayList<ProjectFeatureReference>();
        IConfigurationElement[] iConfigurationElementArray = element.getChildren(childName);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            String id = StringUtils.safeString((String)child.getAttribute("id"));
            if (!id.isEmpty()) {
                boolean optional = "true".equalsIgnoreCase(child.getAttribute("optional"));
                result.add(new ProjectFeatureReference(id, optional));
            }
            ++n2;
        }
        return result;
    }

    private Collection<GroupReference> readGroupReferenceCollection(IConfigurationElement element, String childName) {
        ArrayList<GroupReference> result = new ArrayList<GroupReference>();
        IConfigurationElement[] iConfigurationElementArray = element.getChildren(childName);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            String id = StringUtils.safeString((String)child.getAttribute("id"));
            if (!id.isEmpty()) {
                String version = StringUtils.safeString((String)child.getAttribute("version"));
                if (version.isEmpty()) {
                    version = null;
                }
                result.add(new GroupReference(id, version));
            }
            ++n2;
        }
        return result;
    }

    public void addExtension(IExtensionTracker tracker, IExtension extension) {
        this.loadExtensions(extension.getConfigurationElements());
    }

    public void removeExtension(IExtension extension, Object[] objects) {
        HashSet<IProjectFeatureExtension> newExtensions = new HashSet<IProjectFeatureExtension>(Arrays.asList(this.extensions));
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            this.tracker.unregisterObject(extension, o);
            newExtensions.remove(o);
            ++n2;
        }
        this.extensions = newExtensions.toArray(new IProjectFeatureExtension[newExtensions.size()]);
    }

    @Override
    public IProjectFeatureExtension[] getExtensions() {
        return this.extensions;
    }

    @Override
    public IProjectFeatureExtension getExtensionById(String id) {
        if (id == null) {
            throw new IllegalArgumentException("null id");
        }
        IProjectFeatureExtension[] iProjectFeatureExtensionArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IProjectFeatureExtension ext = iProjectFeatureExtensionArray[n2];
            if (id.equals(ext.getId())) {
                return ext;
            }
            ++n2;
        }
        return null;
    }
}

