/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.deriving;

import java.util.ArrayList;
import org.simantics.scl.compiler.common.datatypes.Constructor;
import org.simantics.scl.compiler.common.names.Names;
import org.simantics.scl.compiler.constants.StringConstant;
import org.simantics.scl.compiler.elaboration.errors.NotPatternException;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EConstant;
import org.simantics.scl.compiler.elaboration.expressions.EListLiteral;
import org.simantics.scl.compiler.elaboration.expressions.ELiteral;
import org.simantics.scl.compiler.elaboration.expressions.ERecord;
import org.simantics.scl.compiler.elaboration.expressions.EVar;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.records.FieldAssignment;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.elaboration.modules.TypeAlias;
import org.simantics.scl.compiler.elaboration.modules.TypeConstructor;
import org.simantics.scl.compiler.elaboration.modules.TypeDescriptor;
import org.simantics.scl.compiler.environment.AmbiguousNameException;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.environment.Environments;
import org.simantics.scl.compiler.errors.ErrorLog;
import org.simantics.scl.compiler.internal.deriving.DerivingUtils;
import org.simantics.scl.compiler.internal.deriving.InstanceDeriver;
import org.simantics.scl.compiler.internal.parsing.declarations.DDerivingInstanceAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DInstanceAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DValueAst;
import org.simantics.scl.compiler.internal.parsing.translation.ProcessedDInstanceAst;
import org.simantics.scl.compiler.internal.parsing.translation.ValueRepository;
import org.simantics.scl.compiler.internal.parsing.types.TVarAst;
import org.simantics.scl.compiler.types.TApply;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;

class JsonDeriver
implements InstanceDeriver {
    JsonDeriver() {
    }

    @Override
    public void derive(ErrorLog errorLog, Environment environment, ArrayList<ProcessedDInstanceAst> instancesAst, DDerivingInstanceAst der) {
        Expression componentsExpression;
        int i;
        Expression[] components;
        TCon con;
        if (der.types.length != 1) {
            errorLog.log(der.location, "Invalid number of parameters to " + der.name);
            return;
        }
        TVarAst headType = DerivingUtils.getHeadType(der.types[0]);
        if (headType == null) {
            errorLog.log(der.types[0].location, "Cannot derive Json instance for the type " + headType + ".");
            return;
        }
        try {
            con = Environments.getTypeDescriptorName(environment, headType.name);
        }
        catch (AmbiguousNameException e1) {
            errorLog.log(headType.location, e1.getMessage());
            return;
        }
        if (con == null) {
            errorLog.log(headType.location, "Couldn't resolve " + headType.name);
            return;
        }
        TypeDescriptor tdesc = environment.getTypeDescriptor(con);
        if (tdesc == null) {
            errorLog.log(headType.location, "Didn't find type constructor for " + headType.name);
            return;
        }
        if (tdesc instanceof TypeAlias) {
            errorLog.log(headType.location, "Cannot derive instance for a type alias.");
            return;
        }
        TypeConstructor tcon = (TypeConstructor)tdesc;
        if (tcon.isOpen) {
            errorLog.log(headType.location, "Cannot derive instance for open data types.");
            return;
        }
        if (tcon.constructors.length != 1) {
            errorLog.log(headType.location, "Data must have exactly one constructor for deriving to work.");
            return;
        }
        Constructor constructor = tcon.constructors[0];
        if (constructor.recordFieldNames == null) {
            errorLog.log(headType.location, "Data must have a record constructor for deriving to work.");
            return;
        }
        DInstanceAst instanceAst = new DInstanceAst(der.location, der.context, der.name, der.types);
        ValueRepository valueDefs = new ValueRepository();
        SCLValue fromJson = environment.getValue(Names.Json_fromJson);
        SCLValue toJson = environment.getValue(Names.Json_toJson);
        SCLValue lookupJsonField = environment.getValue(Names.Json_lookupJsonField);
        SCLValue JsonObject = environment.getValue(Names.Json_JsonObject);
        SCLValue JsonField = environment.getValue(Names.Json_JsonField);
        SCLValue Just = environment.getValue(Names.Builtin_Just);
        SCLValue fromJust = environment.getValue(Names.Prelude_fromJust);
        SCLValue map = environment.getValue(Names.Prelude_map);
        SCLValue filterJust = environment.getValue(Names.Prelude_filterJust);
        SCLValue dot = environment.getValue(Names.Prelude_dot);
        String constructorName = constructor.name.name;
        int fieldCount = constructor.parameterTypes.length;
        String[] fieldNames = constructor.recordFieldNames;
        boolean[] isOptional = new boolean[fieldCount];
        boolean hasAtLeastOneOptional = false;
        int i2 = 0;
        while (i2 < fieldCount) {
            Type type = constructor.parameterTypes[i2];
            isOptional[i2] = type instanceof TApply && ((TApply)type).function == Types.MAYBE;
            hasAtLeastOneOptional |= isOptional[i2];
            ++i2;
        }
        FieldAssignment[] fieldAssignments = new FieldAssignment[fieldCount];
        int i3 = 0;
        while (i3 < fieldCount) {
            fieldAssignments[i3] = new FieldAssignment(fieldNames[i3], null);
            ++i3;
        }
        EApply lhs = new EApply((Expression)new EVar("toJson"), (Expression)new ERecord(new EVar(constructorName), fieldAssignments));
        if (hasAtLeastOneOptional) {
            components = new Expression[fieldCount];
            i = 0;
            while (i < fieldCount) {
                components[i] = isOptional[i] ? new EApply((Expression)new EConstant(map), new EApply((Expression)new EConstant(dot), new EApply((Expression)new EConstant(JsonField), (Expression)new ELiteral(new StringConstant(fieldNames[i]))), new EConstant(toJson)), new EVar(fieldNames[i])) : new EApply((Expression)new EConstant(Just), (Expression)new EApply((Expression)new EConstant(JsonField), new ELiteral(new StringConstant(fieldNames[i])), new EApply((Expression)new EConstant(toJson), (Expression)new EVar(fieldNames[i]))));
                ++i;
            }
            componentsExpression = new EApply((Expression)new EConstant(filterJust), (Expression)new EListLiteral(components));
        } else {
            components = new Expression[fieldCount];
            i = 0;
            while (i < fieldCount) {
                components[i] = new EApply((Expression)new EConstant(JsonField), new ELiteral(new StringConstant(fieldNames[i])), new EApply((Expression)new EConstant(toJson), (Expression)new EVar(fieldNames[i])));
                ++i;
            }
            componentsExpression = new EListLiteral(components);
        }
        EApply rhs = new EApply((Expression)new EConstant(JsonObject), componentsExpression);
        try {
            DValueAst valueAst = new DValueAst(lhs, rhs);
            valueAst.setLocationDeep(der.location);
            valueDefs.add(valueAst);
        }
        catch (NotPatternException e) {
            errorLog.log(e.getExpression().location, "Not a pattern (a).");
        }
        EApply lhs2 = new EApply((Expression)new EVar("fromJson"), (Expression)new EVar("jsonObject"));
        FieldAssignment[] fieldAssignments2 = new FieldAssignment[fieldCount];
        int i4 = 0;
        while (i4 < fieldCount) {
            EApply fieldValue = new EApply((Expression)new EConstant(lookupJsonField), new ELiteral(new StringConstant(fieldNames[i4])), new EVar("jsonObject"));
            if (isOptional[i4]) {
                fieldValue = new EApply((Expression)new EConstant(map), new EConstant(fromJson), fieldValue);
            } else {
                fieldValue = new EApply((Expression)new EConstant(fromJust), (Expression)fieldValue);
                fieldValue = new EApply((Expression)new EConstant(fromJson), (Expression)fieldValue);
            }
            fieldAssignments2[i4] = new FieldAssignment(fieldNames[i4], fieldValue);
            ++i4;
        }
        ERecord rhs2 = new ERecord(new EVar(constructorName), fieldAssignments2);
        try {
            DValueAst valueAst = new DValueAst(lhs2, rhs2);
            valueAst.setLocationDeep(der.location);
            valueDefs.add(valueAst);
        }
        catch (NotPatternException e) {
            errorLog.log(e.getExpression().location, "Not a pattern (b).");
        }
        instancesAst.add(new ProcessedDInstanceAst(instanceAst, valueDefs));
    }
}

