/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.codegen.utils;

import gnu.trove.map.hash.THashMap;
import java.util.Arrays;
import java.util.Map;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.constants.FunctionValue;
import org.simantics.scl.compiler.constants.LocalFieldConstant;
import org.simantics.scl.compiler.constants.LocalVariableConstant;
import org.simantics.scl.compiler.internal.codegen.references.BoundVar;
import org.simantics.scl.compiler.internal.codegen.references.Val;
import org.simantics.scl.compiler.internal.codegen.types.JavaTypeTranslator;
import org.simantics.scl.compiler.internal.codegen.utils.ClassBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.CodeBuilderUtils;
import org.simantics.scl.compiler.internal.codegen.utils.Constants;
import org.simantics.scl.compiler.internal.codegen.utils.JavaNamingPolicy;
import org.simantics.scl.compiler.internal.codegen.utils.LocalVariable;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilderBase;
import org.simantics.scl.compiler.internal.codegen.utils.MethodSizeCounter;
import org.simantics.scl.compiler.types.Type;

public class ModuleBuilder {
    JavaNamingPolicy namingPolicy;
    JavaTypeTranslator javaTypeTranslator;
    THashMap<String, byte[]> classes = new THashMap();
    THashMap<ClosureDesc, TypeDesc> cache = new THashMap();
    MethodSizeCounter methodSizeCounter;

    public void addClass(ClassBuilder cb) {
        byte[] bytecode = cb.finishClass();
        this.classes.put((Object)cb.getClassName(), (Object)bytecode);
    }

    public JavaTypeTranslator getJavaTypeTranslator() {
        return this.javaTypeTranslator;
    }

    public ModuleBuilder(JavaNamingPolicy namingPolicy, JavaTypeTranslator javaTypeTranslator) {
        this.namingPolicy = namingPolicy;
        this.javaTypeTranslator = javaTypeTranslator;
    }

    public TypeDesc getClosure(FunctionValue functionValue, int knownParametersCount) {
        ClosureDesc desc = new ClosureDesc(functionValue, knownParametersCount);
        TypeDesc result = (TypeDesc)this.cache.get((Object)desc);
        if (result == null) {
            result = this.createClosure(functionValue, knownParametersCount);
            this.cache.put((Object)desc, (Object)result);
        }
        return result;
    }

    private TypeDesc createClosure(FunctionValue functionValue, int knownParametersCount) {
        ClassBuilder classBuilder;
        String className = this.namingPolicy.getFreshClosureClassName();
        int remainingArity = functionValue.getArity() - knownParametersCount;
        TypeDesc[] parameterTypes = this.javaTypeTranslator.toTypeDescs(functionValue.getParameterTypes());
        if (remainingArity <= 8) {
            classBuilder = new ClassBuilder(this, 1, className, MethodBuilderBase.getClassName(Constants.FUNCTION_IMPL[remainingArity]), new String[0]);
            classBuilder.setSourceFile("_SCL_Closure");
            CodeBuilderUtils.makeRecord(classBuilder, functionValue.toString(), 18, "p", Arrays.copyOf(parameterTypes, knownParametersCount), true);
            MethodBuilder mb = classBuilder.addMethod(1, "apply", TypeDesc.OBJECT, Constants.OBJECTS[remainingArity]);
            Val[] parameters = new Val[functionValue.getArity()];
            int i = 0;
            while (i < knownParametersCount) {
                parameters[i] = new LocalFieldConstant(functionValue.getParameterTypes()[i], "p" + i);
                ++i;
            }
            i = 0;
            while (i < remainingArity) {
                Type type = functionValue.getParameterTypes()[knownParametersCount + i];
                parameters[knownParametersCount + i] = new LocalVariableConstant(type, mb.getParameter(i));
                ++i;
            }
            functionValue.prepare(mb);
            Type returnType = functionValue.applyExact(mb, parameters);
            mb.box(returnType);
            mb.returnValue(TypeDesc.OBJECT);
            mb.finish();
        } else {
            classBuilder = new ClassBuilder(this, 1, className, MethodBuilderBase.getClassName(Constants.FUNCTION_N_IMPL), new String[0]);
            classBuilder.setSourceFile("_SCL_Closure");
            int i = 0;
            while (i < knownParametersCount) {
                classBuilder.addField(18, "p" + i, parameterTypes[i]);
                ++i;
            }
            MethodBuilderBase mb = classBuilder.addConstructorBase(1, Arrays.copyOf(parameterTypes, knownParametersCount));
            mb.loadThis();
            mb.loadConstant(remainingArity);
            mb.invokeConstructor(MethodBuilderBase.getClassName(Constants.FUNCTION_N_IMPL), new TypeDesc[]{TypeDesc.INT});
            int i2 = 0;
            while (i2 < knownParametersCount) {
                mb.loadThis();
                mb.loadLocal(mb.getParameter(i2));
                mb.storeField(className, "p" + i2, parameterTypes[i2]);
                ++i2;
            }
            mb.returnVoid();
            mb.finish();
            mb = classBuilder.addMethod(1, "doApply", TypeDesc.OBJECT, new TypeDesc[]{TypeDesc.forClass(Object[].class)});
            Val[] parameters = new Val[functionValue.getArity()];
            int i3 = 0;
            while (i3 < knownParametersCount) {
                parameters[i3] = new LocalFieldConstant(functionValue.getParameterTypes()[i3], "p" + i3);
                ++i3;
            }
            LocalVariable parameter = mb.getParameter(0);
            int i4 = 0;
            while (i4 < remainingArity) {
                mb.loadLocal(parameter);
                mb.loadConstant(i4);
                mb.loadFromArray(TypeDesc.OBJECT);
                Type type = functionValue.getParameterTypes()[knownParametersCount + i4];
                TypeDesc typeDesc = this.javaTypeTranslator.toTypeDesc(type);
                ((MethodBuilder)mb).unbox(type);
                LocalVariable lv = mb.createLocalVariable("p" + (i4 + knownParametersCount), typeDesc);
                mb.storeLocal(lv);
                BoundVar var = new BoundVar(type);
                parameters[knownParametersCount + i4] = var;
                ((MethodBuilder)mb).setLocalVariable(var, lv);
                ++i4;
            }
            functionValue.applyExact((MethodBuilder)mb, parameters);
            ((MethodBuilder)mb).box(functionValue.getReturnType());
            mb.returnValue(TypeDesc.OBJECT);
            CodeBuilderUtils.implementHashCodeAndEquals(classBuilder, functionValue.toString(), "p", parameterTypes);
        }
        this.addClass(classBuilder);
        return TypeDesc.forClass(className);
    }

    public Map<String, byte[]> getClasses() {
        return this.classes;
    }

    public JavaNamingPolicy getNamingPolicy() {
        return this.namingPolicy;
    }

    public MethodSizeCounter getMethodSizeCounter() {
        return this.methodSizeCounter;
    }

    static class ClosureDesc {
        FunctionValue functionValue;
        int knownParametersCount;

        public ClosureDesc(FunctionValue functionValue, int knownParametersCount) {
            this.functionValue = functionValue;
            this.knownParametersCount = knownParametersCount;
        }

        public int hashCode() {
            return this.functionValue.hashCode() + 31 * this.knownParametersCount;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            ClosureDesc other = (ClosureDesc)obj;
            return this.functionValue == other.functionValue && this.knownParametersCount == other.knownParametersCount;
        }
    }
}

