/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.request;

import gnu.trove.set.hash.THashSet;
import java.util.Collections;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;

public class ResourceSetURIs
extends UnaryRead<Set<Resource>, Set<String>> {
    public ResourceSetURIs(Set<Resource> set) {
        super(set);
    }

    public Set<String> perform(ReadGraph graph) throws DatabaseException {
        if (this.parameter == null || ((Set)this.parameter).isEmpty()) {
            return Collections.emptySet();
        }
        THashSet result = new THashSet(((Set)this.parameter).size());
        for (Resource r : (Set)this.parameter) {
            String uri = graph.getPossibleURI(r);
            if (uri == null) continue;
            result.add(uri);
        }
        return result;
    }
}

