/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.internal.DirectStatementImpl;
import fi.vtt.simantics.procore.internal.SessionImplSocket;
import gnu.trove.TIntCollection;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.procedure.TIntObjectProcedure;
import gnu.trove.procedure.TIntProcedure;
import gnu.trove.procedure.TObjectIntProcedure;
import gnu.trove.procedure.TObjectProcedure;
import gnu.trove.set.hash.TIntHashSet;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Consumer;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.ResourceMap;
import org.simantics.db.Statement;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.impl.ResourceImpl;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.query.IntSet;
import org.simantics.db.impl.support.ResourceSupport;
import org.simantics.db.service.CollectionSupport;

public class CollectionSupportImpl
implements CollectionSupport {
    private final SessionImplSocket session;
    private static Comparator<Resource> RESOURCE_COMPARATOR = (o1, o2) -> {
        ResourceImpl r1 = (ResourceImpl)o1;
        ResourceImpl r2 = (ResourceImpl)o2;
        return Integer.compare(r1.id, r2.id);
    };

    CollectionSupportImpl(SessionImplSocket session) {
        this.session = session;
    }

    public IntResourceMap createIntResourceMap() {
        return new IntResourceMap(this.session);
    }

    public <T, I> T createObjectResourceMap(Class<I> clazz) {
        return (T)new ObjectResourceMap(this.session);
    }

    public <T, I> T createObjectResourceMap(Class<I> clazz, int capacity) {
        return (T)new ObjectResourceMap(this.session, capacity);
    }

    public <T, I> T createMap(Class<I> clazz) {
        return (T)new ResourceMap(this.session);
    }

    public Set<Resource> createSet() {
        return new ResourceSet(this.session);
    }

    public Set<Resource> createSet(int capacity) {
        return new ResourceSet(this.session, capacity);
    }

    public List<Resource> createList() {
        return new ResourceList(this.session);
    }

    public List<Resource> createList(int capacity) {
        return new ResourceList(this.session, capacity);
    }

    public Collection<Statement> createStatementList() {
        return new StatementList(this.session);
    }

    public void sort(List<Resource> list) {
        if (list instanceof ResourceList) {
            ((ResourceList)list).sort();
        } else {
            Collections.sort(list, RESOURCE_COMPARATOR);
        }
    }

    public List<Resource> asSortedList(Collection<Resource> rs) {
        ResourceList result = new ResourceList(this.session, rs);
        result.sort();
        return result;
    }

    public org.simantics.db.ResourceSet getResourceSet(ReadGraph graph, Collection<Resource> resources) {
        if (resources instanceof ResourceSet) {
            return (org.simantics.db.ResourceSet)resources;
        }
        IntSet result = new IntSet(((ReadGraphImpl)graph).processor.querySupport);
        for (Resource r : resources) {
            result.add((Object)r);
        }
        return result;
    }

    public org.simantics.db.ResourceSet getResourceSet(ReadGraph graph, Resource ... rs) {
        IntSet result = new IntSet(((ReadGraphImpl)graph).processor.querySupport);
        Resource[] resourceArray = rs;
        int n = rs.length;
        int n2 = 0;
        while (n2 < n) {
            Resource r = resourceArray[n2];
            result.add((Object)r);
            ++n2;
        }
        return result;
    }

    static final class IntResourceMap {
        private final SessionImplSocket session;
        private final TIntIntHashMap backend = new TIntIntHashMap(10, 0.5f, -1, 0);

        IntResourceMap(SessionImplSocket session) {
            this.session = session;
        }

        public int size() {
            return this.backend.size();
        }

        public boolean isEmpty() {
            return this.backend.isEmpty();
        }

        public boolean containsKey(int key) {
            return this.backend.containsKey(key);
        }

        public boolean containsValue(int value) {
            return this.backend.containsValue(value);
        }

        public Resource get(int key) {
            try {
                return this.session.getResourceByKey(this.backend.get(key));
            }
            catch (ResourceNotFoundException e) {
                e.printStackTrace();
                return null;
            }
        }

        public Resource put(int key, Resource value) {
            ResourceImpl impl = (ResourceImpl)value;
            int i = this.backend.put(key, impl.id);
            if (i == 0) {
                return null;
            }
            try {
                return this.session.getResourceByKey(i);
            }
            catch (ResourceNotFoundException e) {
                e.printStackTrace();
                return null;
            }
        }

        public Resource remove(int key) {
            throw new UnsupportedOperationException("remove not supported");
        }

        public int hashCode() {
            return this.backend.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IntResourceMap other = (IntResourceMap)obj;
            return this.session == other.session && this.backend.equals((Object)other.backend);
        }
    }

    static final class ObjectResourceMap<T>
    implements Map<T, Resource> {
        private final SessionImplSocket session;
        private final TObjectIntHashMap<T> backend;

        ObjectResourceMap(SessionImplSocket session) {
            this.session = session;
            this.backend = new TObjectIntHashMap(10, 0.5f, 0);
        }

        ObjectResourceMap(SessionImplSocket session, int capacity) {
            this.session = session;
            this.backend = new TObjectIntHashMap(capacity, 0.5f, 0);
        }

        @Override
        public int size() {
            return this.backend.size();
        }

        @Override
        public boolean isEmpty() {
            return this.backend.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.backend.contains(key);
        }

        @Override
        public boolean containsValue(Object value) {
            ResourceImpl impl = (ResourceImpl)value;
            return this.backend.containsValue(impl.id);
        }

        @Override
        public Resource get(Object key) {
            int result;
            block3: {
                try {
                    result = this.backend.get(key);
                    if (result != 0) break block3;
                    return null;
                }
                catch (ResourceNotFoundException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            return this.session.getResourceByKey(result);
        }

        @Override
        public Resource put(T key, Resource value) {
            ResourceImpl impl = (ResourceImpl)value;
            int i = this.backend.put(key, impl.id);
            if (i == 0) {
                return null;
            }
            try {
                return this.session.getResourceByKey(i);
            }
            catch (ResourceNotFoundException e) {
                e.printStackTrace();
                return null;
            }
        }

        @Override
        public Resource remove(Object key) {
            throw new UnsupportedOperationException("remove not supported, structure is immutable");
        }

        @Override
        public void putAll(Map<? extends T, ? extends Resource> map) {
            ObjectResourceMap other = (ObjectResourceMap)map;
            other.backend.forEachEntry(new TObjectIntProcedure<T>(){

                public boolean execute(T a, int b) {
                    backend.put(a, b);
                    return true;
                }
            });
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("clear not supported, structure is immutable");
        }

        @Override
        public Set<T> keySet() {
            final HashSet result = new HashSet();
            this.backend.forEach(new TObjectProcedure<T>(){

                public boolean execute(T object) {
                    result.add(object);
                    return true;
                }
            });
            return result;
        }

        @Override
        public Collection<Resource> values() {
            ArrayList<Resource> result = new ArrayList<Resource>();
            int[] nArray = this.backend.values();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int key = nArray[n2];
                try {
                    result.add(this.session.getResourceByKey(key));
                }
                catch (ResourceNotFoundException e) {
                    e.printStackTrace();
                }
                ++n2;
            }
            return result;
        }

        @Override
        public Set<Map.Entry<T, Resource>> entrySet() {
            final HashSet<Map.Entry<T, Resource>> result = new HashSet<Map.Entry<T, Resource>>();
            this.backend.forEachEntry(new TObjectIntProcedure<T>(){

                public boolean execute(final T a, final int b) {
                    return result.add(new Map.Entry<T, Resource>(){

                        @Override
                        public T getKey() {
                            return a;
                        }

                        @Override
                        public Resource getValue() {
                            return new ResourceImpl((ResourceSupport)((ObjectResourceMap)(this).this).session.resourceSupport, b);
                        }

                        @Override
                        public Resource setValue(Resource value) {
                            throw new UnsupportedOperationException("Map.Entry.setValue not supported, structure is immutable");
                        }
                    });
                }
            });
            return result;
        }

        @Override
        public int hashCode() {
            return this.backend.hashCode();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                if (!(obj instanceof Map)) {
                    return false;
                }
                Map m = (Map)obj;
                if (m.size() != this.size()) {
                    return false;
                }
                try {
                    T key;
                    Map.Entry<T, Resource> e;
                    Resource value;
                    Iterator<Map.Entry<T, Resource>> i = this.entrySet().iterator();
                    do {
                        if (!i.hasNext()) {
                            return true;
                        }
                        e = i.next();
                        key = e.getKey();
                    } while (!((value = e.getValue()) == null ? m.get(key) != null || !m.containsKey(key) : !value.equals(m.get(key))));
                    return false;
                }
                catch (ClassCastException classCastException) {
                    return false;
                }
                catch (NullPointerException nullPointerException) {
                    return false;
                }
            }
            ObjectResourceMap other = (ObjectResourceMap)obj;
            return this.session == other.session && this.backend.equals(other.backend);
        }
    }

    static final class ResourceList
    implements List<Resource> {
        private final SessionImplSocket session;
        private final TIntArrayList backend;

        ResourceList(SessionImplSocket session) {
            this.session = session;
            this.backend = new TIntArrayList();
        }

        ResourceList(SessionImplSocket session, int capacity) {
            this.session = session;
            this.backend = new TIntArrayList(capacity);
        }

        ResourceList(SessionImplSocket session, Collection<Resource> rs) {
            this.session = session;
            this.backend = new TIntArrayList(rs.size());
            this.addAll((Collection<? extends Resource>)rs);
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Not implemented");
        }

        @Override
        public int size() {
            return this.backend.size();
        }

        @Override
        public boolean add(Resource resource) {
            if (resource == null) {
                this.backend.add(0);
            } else {
                ResourceImpl impl = (ResourceImpl)resource;
                this.backend.add(impl.id);
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends Resource> rs) {
            if (rs instanceof ResourceList) {
                ResourceList rl = (ResourceList)rs;
                this.backend.addAll((TIntCollection)rl.backend);
                return !rl.isEmpty();
            }
            boolean result = true;
            for (Resource resource : rs) {
                result &= this.add(resource);
            }
            return result;
        }

        @Override
        public boolean contains(Object resource) {
            ResourceImpl impl = (ResourceImpl)resource;
            return this.backend.contains(impl.id);
        }

        @Override
        public boolean containsAll(Collection<?> rs) {
            boolean result = true;
            for (Object r : rs) {
                result &= this.contains(r);
            }
            return result;
        }

        @Override
        public boolean isEmpty() {
            return this.backend.isEmpty();
        }

        @Override
        public Iterator<Resource> iterator() {
            return new Iterator<Resource>(){
                int index = 0;
                int max;
                {
                    this.max = resourceList.backend.size();
                }

                @Override
                public boolean hasNext() {
                    return this.index < this.max;
                }

                @Override
                public Resource next() {
                    int i = this.index;
                    if (i >= this.max) {
                        throw new NoSuchElementException();
                    }
                    int id = backend.getQuick(i);
                    this.index = i + 1;
                    return new ResourceImpl((ResourceSupport)((ResourceList)this).session.resourceSupport, id);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("remove not supported");
                }
            };
        }

        @Override
        public boolean remove(Object resource) {
            if (!(resource instanceof ResourceImpl)) {
                return false;
            }
            ResourceImpl impl = (ResourceImpl)resource;
            return this.backend.remove(impl.id);
        }

        @Override
        public boolean removeAll(Collection<?> rs) {
            boolean modified = false;
            for (Object o : rs) {
                modified |= this.remove(o);
            }
            return modified;
        }

        @Override
        public boolean retainAll(Collection<?> arg0) {
            throw new UnsupportedOperationException("Not implemented");
        }

        @Override
        public Object[] toArray() {
            return this.toArray(new Object[this.backend.size()]);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            int size = this.backend.size();
            final Object[] r = a.length >= size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), size);
            this.backend.forEach(new TIntProcedure(){
                int index = 0;

                public boolean execute(int value) {
                    r[this.index++] = new ResourceImpl((ResourceSupport)((ResourceList)this).session.resourceSupport, value);
                    return true;
                }
            });
            return r;
        }

        void sort() {
            this.backend.sort();
        }

        @Override
        public boolean addAll(int index, Collection<? extends Resource> rs) {
            if (rs.isEmpty()) {
                return false;
            }
            int i = index;
            for (Resource resource : rs) {
                this.add(i++, resource);
            }
            return true;
        }

        @Override
        public Resource get(int index) {
            int id = this.backend.get(index);
            if (id == 0) {
                return null;
            }
            return new ResourceImpl((ResourceSupport)this.session.resourceSupport, id);
        }

        @Override
        public Resource set(int index, Resource resource) {
            ResourceImpl impl = (ResourceImpl)resource;
            int old = this.backend.set(index, impl.id);
            if (old == 0) {
                return null;
            }
            return new ResourceImpl((ResourceSupport)this.session.resourceSupport, old);
        }

        @Override
        public void add(int index, Resource resource) {
            ResourceImpl impl = (ResourceImpl)resource;
            this.backend.insert(index, impl.id);
        }

        @Override
        public Resource remove(int index) {
            int id = this.backend.removeAt(index);
            return new ResourceImpl((ResourceSupport)this.session.resourceSupport, id);
        }

        @Override
        public int indexOf(Object o) {
            if (!(o instanceof ResourceImpl)) {
                return -1;
            }
            ResourceImpl impl = (ResourceImpl)o;
            return this.backend.indexOf(impl.id);
        }

        @Override
        public int lastIndexOf(Object o) {
            if (!(o instanceof ResourceImpl)) {
                return -1;
            }
            ResourceImpl impl = (ResourceImpl)o;
            return this.backend.lastIndexOf(impl.id);
        }

        @Override
        public ListIterator<Resource> listIterator() {
            return new ListItr(0);
        }

        @Override
        public ListIterator<Resource> listIterator(int index) {
            if (index < 0 || index > this.backend.size()) {
                throw new IndexOutOfBoundsException("Index: " + index);
            }
            return new ListItr(index);
        }

        @Override
        public List<Resource> subList(int fromIndex, int toIndex) {
            ResourceList result = new ResourceList(this.session);
            int i = fromIndex;
            while (i < toIndex) {
                result.add(this.get(i));
                ++i;
            }
            return result;
        }

        @Override
        public int hashCode() {
            return this.backend.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                if (obj instanceof List) {
                    ListIterator<Resource> e1 = this.listIterator();
                    ListIterator e2 = ((List)obj).listIterator();
                    while (e1.hasNext() && e2.hasNext()) {
                        Resource o1 = e1.next();
                        Object o2 = e2.next();
                        if (!(o1 == null ? o2 != null : !o1.equals(o2))) continue;
                        return false;
                    }
                    return !e1.hasNext() && !e2.hasNext();
                }
                return false;
            }
            ResourceList other = (ResourceList)obj;
            return this.session == other.session && this.backend.equals((Object)other.backend);
        }

        private class ListItr
        implements ListIterator<Resource> {
            int index;
            int max;

            public ListItr(int index) {
                this.index = index;
                this.max = ResourceList.this.size();
            }

            @Override
            public boolean hasNext() {
                return this.index < this.max;
            }

            @Override
            public Resource next() {
                int i = this.index;
                if (i >= this.max) {
                    throw new NoSuchElementException();
                }
                int id = ResourceList.this.backend.getQuick(this.index);
                this.index = i + 1;
                return new ResourceImpl((ResourceSupport)((ResourceList)ResourceList.this).session.resourceSupport, id);
            }

            @Override
            public boolean hasPrevious() {
                return this.index != 0;
            }

            @Override
            public Resource previous() {
                int i = this.index - 1;
                if (i < 0) {
                    throw new NoSuchElementException();
                }
                int id = ResourceList.this.backend.getQuick(this.index);
                this.index = i;
                return new ResourceImpl((ResourceSupport)((ResourceList)ResourceList.this).session.resourceSupport, id);
            }

            @Override
            public int nextIndex() {
                return this.index;
            }

            @Override
            public int previousIndex() {
                return this.index - 1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove not supported");
            }

            @Override
            public void set(Resource e) {
                throw new UnsupportedOperationException("set not supported");
            }

            @Override
            public void add(Resource e) {
                throw new UnsupportedOperationException("add not supported");
            }
        }
    }

    static final class ResourceMap<T>
    implements org.simantics.db.ResourceMap<T> {
        private final SessionImplSocket session;
        private final TIntObjectHashMap<T> backend = new TIntObjectHashMap();

        ResourceMap(SessionImplSocket session) {
            this.session = session;
        }

        public void clear() {
            throw new UnsupportedOperationException("Not implemented");
        }

        public boolean containsKey(Object resource) {
            ResourceImpl impl = (ResourceImpl)resource;
            return this.backend.containsKey(impl.id);
        }

        public boolean containsValue(Object value) {
            return this.backend.containsValue(value);
        }

        public Set<Map.Entry<Resource, T>> entrySet() {
            final HashSet<Map.Entry<Resource, T>> result = new HashSet<Map.Entry<Resource, T>>();
            this.backend.forEachEntry(new TIntObjectProcedure<T>(){

                public boolean execute(final int a, final T b) {
                    result.add(new Map.Entry<Resource, T>(){

                        @Override
                        public Resource getKey() {
                            return new ResourceImpl((ResourceSupport)((ResourceMap)(this).this).session.resourceSupport, a);
                        }

                        @Override
                        public T getValue() {
                            return b;
                        }

                        @Override
                        public T setValue(T arg0) {
                            throw new UnsupportedOperationException("Not supported");
                        }
                    });
                    return true;
                }
            });
            return result;
        }

        public T get(Object resource) {
            ResourceImpl impl = (ResourceImpl)resource;
            return (T)this.backend.get(impl.id);
        }

        public boolean isEmpty() {
            return this.backend.isEmpty();
        }

        public void iterateEntries(final Consumer<ResourceMap.ResourceMapEntry<T>> callback) {
            final CallbackEntry entry = new CallbackEntry();
            this.backend.forEach(new TIntProcedure(){

                public boolean execute(int value) {
                    entry.id = value;
                    entry.value = backend.get(value);
                    callback.accept(entry);
                    return true;
                }
            });
        }

        public Set<Resource> keySet() {
            final ResourceSet result = new ResourceSet(this.session);
            this.backend.forEach(new TIntProcedure(){

                public boolean execute(int value) {
                    result.add(value);
                    return true;
                }
            });
            return result;
        }

        public T put(Resource resource, T value) {
            ResourceImpl impl = (ResourceImpl)resource;
            return (T)this.backend.put(impl.id, value);
        }

        public void putAll(Map<? extends Resource, ? extends T> map) {
            ResourceMap other = (ResourceMap)((Object)map);
            other.backend.forEachEntry(new TIntObjectProcedure<T>(){

                public boolean execute(int a, T b) {
                    backend.put(a, b);
                    return true;
                }
            });
        }

        public T remove(Object key) {
            if (key instanceof ResourceImpl) {
                ResourceImpl impl = (ResourceImpl)key;
                return (T)this.backend.remove(impl.id);
            }
            return null;
        }

        public int size() {
            return this.backend.size();
        }

        public Collection<T> values() {
            ArrayList<Object> result = new ArrayList<Object>();
            Object[] objectArray = this.backend.values();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                result.add(o);
                ++n2;
            }
            return result;
        }

        public int hashCode() {
            return this.backend.hashCode();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                if (!(obj instanceof Map)) {
                    return false;
                }
                Map m = (Map)obj;
                if (m.size() != this.size()) {
                    return false;
                }
                try {
                    Resource key;
                    Map.Entry<Resource, T> e;
                    T value;
                    Iterator<Map.Entry<Resource, T>> i = this.entrySet().iterator();
                    do {
                        if (!i.hasNext()) {
                            return true;
                        }
                        e = i.next();
                        key = e.getKey();
                    } while (!((value = e.getValue()) == null ? m.get(key) != null || !m.containsKey(key) : !value.equals(m.get(key))));
                    return false;
                }
                catch (ClassCastException classCastException) {
                    return false;
                }
                catch (NullPointerException nullPointerException) {
                    return false;
                }
            }
            ResourceMap other = (ResourceMap)obj;
            return this.session == other.session && this.backend.equals(other.backend);
        }

        public class CallbackEntry<E>
        implements ResourceMap.ResourceMapEntry<E> {
            int id;
            E value;

            public Resource getKey() {
                return new ResourceImpl((ResourceSupport)((ResourceMap)ResourceMap.this).session.resourceSupport, this.id);
            }

            public E getValue() {
                return this.value;
            }
        }
    }

    static final class ResourceSet
    implements Set<Resource> {
        private final SessionImplSocket session;
        private final TIntHashSet backend;

        ResourceSet(SessionImplSocket session) {
            this.session = session;
            this.backend = new TIntHashSet();
        }

        ResourceSet(SessionImplSocket session, int capacity) {
            this.session = session;
            this.backend = new TIntHashSet(capacity);
        }

        @Override
        public void clear() {
            this.backend.clear();
        }

        @Override
        public int size() {
            return this.backend.size();
        }

        @Override
        public boolean add(Resource resource) {
            ResourceImpl impl = (ResourceImpl)resource;
            return this.backend.add(impl.id);
        }

        @Override
        boolean add(int id) {
            return this.backend.add(id);
        }

        @Override
        public boolean addAll(Collection<? extends Resource> rs) {
            boolean result = false;
            for (Resource resource : rs) {
                result |= this.add(resource);
            }
            return result;
        }

        @Override
        public boolean contains(Object resource) {
            ResourceImpl impl = (ResourceImpl)resource;
            return this.backend.contains(impl.id);
        }

        @Override
        public boolean containsAll(Collection<?> rs) {
            for (Object r : rs) {
                if (this.contains(r)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isEmpty() {
            return this.backend.isEmpty();
        }

        @Override
        public Iterator<Resource> iterator() {
            return new Iterator<Resource>(){
                TIntIterator it;
                {
                    this.it = resourceSet.backend.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public Resource next() {
                    return new ResourceImpl((ResourceSupport)((ResourceSet)this).session.resourceSupport, this.it.next());
                }

                @Override
                public void remove() {
                    this.it.remove();
                }
            };
        }

        @Override
        public boolean remove(Object resource) {
            ResourceImpl impl = (ResourceImpl)resource;
            return this.backend.remove(impl.id);
        }

        @Override
        public boolean removeAll(Collection<?> rs) {
            boolean result = false;
            for (Object r : rs) {
                result |= this.remove(r);
            }
            return result;
        }

        @Override
        public boolean retainAll(Collection<?> arg0) {
            throw new UnsupportedOperationException("Not implemented");
        }

        @Override
        public Object[] toArray() {
            return this.toArray(new Object[this.backend.size()]);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            int size = this.backend.size();
            final Object[] r = a.length >= size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), size);
            this.backend.forEach(new TIntProcedure(){
                int index = 0;

                public boolean execute(int value) {
                    r[this.index++] = new ResourceImpl((ResourceSupport)((ResourceSet)this).session.resourceSupport, value);
                    return true;
                }
            });
            return r;
        }

        @Override
        public int hashCode() {
            return this.backend.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                if (obj instanceof Set) {
                    Collection c = (Collection)obj;
                    if (c.size() != this.size()) {
                        return false;
                    }
                    try {
                        return this.containsAll(c);
                    }
                    catch (ClassCastException classCastException) {
                        return false;
                    }
                    catch (NullPointerException nullPointerException) {
                        return false;
                    }
                }
                return false;
            }
            ResourceSet other = (ResourceSet)obj;
            return this.session == other.session && this.backend.equals((Object)other.backend);
        }
    }

    static final class StatementList
    implements Collection<Statement> {
        private final SessionImplSocket session;
        private final TIntArrayList backend = new TIntArrayList();

        StatementList(SessionImplSocket session) {
            this.session = session;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Not implemented");
        }

        @Override
        public int size() {
            return this.backend.size() / 3;
        }

        @Override
        public boolean add(Statement stm) {
            ResourceImpl s = (ResourceImpl)stm.getSubject();
            ResourceImpl p = (ResourceImpl)stm.getPredicate();
            ResourceImpl o = (ResourceImpl)stm.getObject();
            this.backend.add(s.id);
            this.backend.add(p.id);
            this.backend.add(o.id);
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends Statement> rs) {
            boolean result = false;
            for (Statement statement : rs) {
                result |= this.add(statement);
            }
            return result;
        }

        @Override
        public boolean contains(Object statement) {
            throw new UnsupportedOperationException("Not implemented");
        }

        @Override
        public boolean containsAll(Collection<?> rs) {
            throw new UnsupportedOperationException("Not implemented");
        }

        @Override
        public boolean isEmpty() {
            return this.backend.isEmpty();
        }

        @Override
        public Iterator<Statement> iterator() {
            return new Iterator<Statement>(){
                int index = 0;
                int max;
                {
                    this.max = statementList.backend.size();
                }

                @Override
                public boolean hasNext() {
                    return this.index < this.max;
                }

                @Override
                public Statement next() {
                    return new DirectStatementImpl(((StatementList)this).session.resourceSupport, backend.getQuick(this.index++), backend.getQuick(this.index++), backend.getQuick(this.index++));
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Not supported");
                }
            };
        }

        @Override
        public boolean remove(Object resource) {
            throw new UnsupportedOperationException("Not implemented");
        }

        @Override
        public boolean removeAll(Collection<?> rs) {
            throw new UnsupportedOperationException("Not implemented");
        }

        @Override
        public boolean retainAll(Collection<?> arg0) {
            throw new UnsupportedOperationException("Not implemented");
        }

        @Override
        public Object[] toArray() {
            int stms = this.backend.size() / 3;
            return this.toArray(new Object[stms]);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            int size = this.backend.size();
            int stms = size / 3;
            T[] r = a.length >= size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), stms);
            int index = 0;
            int i = 0;
            while (i < size) {
                r[index++] = new DirectStatementImpl(this.session.resourceSupport, this.backend.getQuick(i), this.backend.getQuick(i + 1), this.backend.getQuick(i + 2));
                i += 3;
            }
            return r;
        }

        @Override
        public int hashCode() {
            return this.backend.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                if (obj instanceof Collection) {
                    Iterator<Statement> e1 = this.iterator();
                    Iterator e2 = ((Collection)obj).iterator();
                    while (e1.hasNext() && e2.hasNext()) {
                        Statement o1 = e1.next();
                        Object o2 = e2.next();
                        if (!(o1 == null ? o2 != null : !o1.equals(o2))) continue;
                        return false;
                    }
                    return !e1.hasNext() && !e2.hasNext();
                }
                return false;
            }
            StatementList other = (StatementList)obj;
            return this.session == other.session && this.backend.equals((Object)other.backend);
        }
    }
}

