/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.nodes;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.scenegraph.utils.GeometryUtils;

public class PageBorderNode
extends G2DNode {
    private static final long serialVersionUID = -5969105979396122487L;
    private static final Paint MARGIN_COLOR = new Color(192, 128, 128);
    protected Rectangle2D border = null;
    protected Rectangle2D margin = null;
    protected Boolean enabled = null;

    @INode.SyncField(value={"border", "margin", "enabled"})
    public void init(Rectangle2D border, Rectangle2D margin, Boolean enabled) {
        this.border = border;
        this.margin = margin;
        this.enabled = enabled;
    }

    @INode.SyncField(value={"enabled"})
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public Rectangle2D getBounds() {
        if (this.border != null) {
            return this.border;
        }
        if (this.margin != null) {
            return this.margin;
        }
        return null;
    }

    @Override
    public void render(Graphics2D g) {
        if (Boolean.FALSE.equals(this.enabled)) {
            return;
        }
        boolean borderPaintable = this.isPaintable(this.border);
        boolean marginPaintable = this.isPaintable(this.margin);
        if (!borderPaintable && !marginPaintable) {
            return;
        }
        double scaleRecip = 1.0 / GeometryUtils.getScale(g.getTransform());
        BasicStroke s = new BasicStroke((float)(1.0 * scaleRecip));
        boolean borderPainted = false;
        if (borderPaintable) {
            BasicStroke ss = new BasicStroke((float)(2.0 * scaleRecip));
            this.paintRectangle(g, scaleRecip, this.border, s, Color.BLACK, ss, Color.GRAY);
            borderPainted = true;
        }
        if (!(!marginPaintable || borderPainted && this.margin.equals(this.border))) {
            this.paintRectangle(g, scaleRecip, this.margin, s, MARGIN_COLOR, null, null);
        }
    }

    boolean isPaintable(Rectangle2D r) {
        return r != null && !r.isEmpty() && r.getWidth() != Double.POSITIVE_INFINITY && r.getHeight() != Double.POSITIVE_INFINITY;
    }

    void paintRectangle(Graphics2D g, double scaleRecip, Rectangle2D r, Stroke stroke, Paint strokePaint, Stroke shadowStroke, Paint shadowPaint) {
        g.setPaint(strokePaint);
        g.setStroke(stroke);
        g.draw(r);
        if (shadowStroke != null) {
            g.setPaint(shadowPaint);
            g.setStroke(shadowStroke);
            double offset = 2.0 * scaleRecip;
            double w = r.getWidth();
            double h = r.getHeight();
            double x = r.getMaxX() + offset;
            double x1 = r.getMinX() + offset * 2.0;
            double y1 = r.getMinY() + offset * 2.0;
            g.draw(new Line2D.Double(x, y1, x, y1 + h - offset));
            double y = r.getMaxY() + offset;
            g.draw(new Line2D.Double(x1, y, x1 + w - offset, y));
        }
    }

    @Override
    public Rectangle2D getBoundsInLocal() {
        return this.border;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " [enabled=" + this.enabled + ", border=" + this.border + ", margin=" + this.margin + "]";
    }
}

