/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.ui.handler;

import java.util.ArrayList;
import java.util.List;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Write;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.issues.ui.handler.PreferenceHandler;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function;

class FunctionHandler
extends PreferenceHandler {
    private String functionPropertyName;
    private Object argument;

    public FunctionHandler(String virtualGraphId, String functionPropertyName, Object argument) {
        super(virtualGraphId, null, false);
        this.functionPropertyName = functionPropertyName;
        this.argument = argument;
    }

    @Override
    public void execute(final List<Variable> vars, List<Resource> resources) {
        if (vars.isEmpty()) {
            return;
        }
        Session session = Simantics.peekSession();
        if (session == null) {
            return;
        }
        VirtualGraph vg = this.virtualGraphId == null ? null : ((VirtualGraphSupport)session.getService(VirtualGraphSupport.class)).getWorkspacePersistent(this.virtualGraphId);
        session.asyncRequest((Write)new WriteRequest(vg){

            public void perform(WriteGraph graph) throws DatabaseException {
                graph.markUndoPoint();
                FunctionHandler.this.execute(graph, vars, FunctionHandler.this.functionPropertyName);
            }
        }, e -> {
            if (e != null) {
                Logger.defaultLogError((Throwable)e);
            }
        });
    }

    protected void execute(WriteGraph graph, List<Variable> vars, String functionPropertyName) throws DatabaseException {
        ArrayList<Function> hiders = new ArrayList<Function>(vars.size());
        for (Variable v : vars) {
            Function f = (Function)v.getPossiblePropertyValue((ReadGraph)graph, functionPropertyName);
            if (f == null) continue;
            hiders.add(f);
        }
        if (!hiders.isEmpty()) {
            SCLContext ctx = SCLContext.getCurrent();
            Object oldGraph = ctx.put((Object)"graph", (Object)graph);
            try {
                try {
                    for (Function f : hiders) {
                        f.apply(this.argument);
                    }
                }
                catch (Throwable t) {
                    throw new DatabaseException(t);
                }
            }
            finally {
                ctx.put((Object)"graph", oldGraph);
            }
        }
    }
}

