/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.ui.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.request.PossibleObjectWithType;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleActiveModel;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.issues.common.IssueUtils;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingUtils;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.dialogs.ListDialog;

public class ConfigureIssueSources
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        List sources;
        block3: {
            sources = (List)Simantics.getSession().syncRequest((Read)new UniqueRead<List<IssueSourceEntry>>(){

                public List<IssueSourceEntry> perform(ReadGraph graph) throws DatabaseException {
                    Resource activeModel = (Resource)graph.syncRequest((Read)new PossibleActiveModel(Simantics.getProjectResource()));
                    if (activeModel == null) {
                        return Collections.emptyList();
                    }
                    ArrayList<IssueSourceEntry> result = new ArrayList<IssueSourceEntry>();
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    IssueResource ISSUE = IssueResource.getInstance((ReadGraph)graph);
                    for (Resource type : ModelingUtils.searchByType((ReadGraph)graph, (Resource)activeModel, (Resource)ISSUE.IssueSourceType)) {
                        String name = NameUtils.getSafeLabel((ReadGraph)graph, (Resource)type);
                        boolean exists = graph.syncRequest((Read)new PossibleObjectWithType(activeModel, L0.ConsistsOf, type)) != null;
                        boolean deprecated = graph.hasStatement(type, L0.Deprecated);
                        if (!exists && deprecated) continue;
                        result.add(new IssueSourceEntry(name, type, exists));
                    }
                    return result;
                }
            });
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            ListDialog<IssueSourceEntry> dialog = new ListDialog<IssueSourceEntry>(shell, (Collection)sources, "Select available issue sources", "Selected sources will be used and existing deselected sources will be removed."){

                protected CheckboxTableViewer createViewer(Composite composite) {
                    CheckboxTableViewer viewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2816);
                    final Table table = (Table)viewer.getControl();
                    viewer.setCheckStateProvider(new ICheckStateProvider(){

                        public boolean isGrayed(Object arg0) {
                            return false;
                        }

                        public boolean isChecked(Object arg0) {
                            IssueSourceEntry entry = (IssueSourceEntry)((Object)arg0);
                            return entry.isChecked();
                        }
                    });
                    viewer.addCheckStateListener(new ICheckStateListener(){

                        public void checkStateChanged(CheckStateChangedEvent arg0) {
                            IssueSourceEntry entry = (IssueSourceEntry)((Object)arg0.getElement());
                            entry.setChecked(arg0.getChecked());
                        }
                    });
                    table.addSelectionListener(new SelectionListener(){

                        public void widgetSelected(SelectionEvent e) {
                            table.deselectAll();
                        }

                        public void widgetDefaultSelected(SelectionEvent e) {
                        }
                    });
                    return viewer;
                }
            };
            int result = dialog.open();
            if (result == 0) break block3;
            return null;
        }
        try {
            Simantics.getSession().syncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    Resource activeModel = (Resource)graph.syncRequest((Read)new PossibleActiveModel(Simantics.getProjectResource()));
                    if (activeModel == null) {
                        return;
                    }
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    for (IssueSourceEntry entry : sources) {
                        Resource existing = (Resource)graph.syncRequest((Read)new PossibleObjectWithType(activeModel, L0.ConsistsOf, entry.getResource()));
                        if (existing == null && entry.isChecked()) {
                            String name = NameUtils.getSafeLabel((ReadGraph)graph, (Resource)entry.getResource());
                            IssueUtils.addIssueSource((WriteGraph)graph, (Resource)activeModel, (Resource)entry.getResource(), (String)name);
                        }
                        if (existing == null || entry.isChecked()) continue;
                        RemoverUtil.remove((WriteGraph)graph, (Resource)existing);
                    }
                }
            });
        }
        catch (DatabaseException e) {
            ErrorLogger.defaultLogError((Throwable)e);
        }
        return null;
    }

    private static class IssueSourceEntry
    extends NamedResource {
        private boolean checked;

        public IssueSourceEntry(String name, Resource resource, boolean checked) {
            super(name, resource);
            this.checked = checked;
        }

        public boolean isChecked() {
            return this.checked;
        }

        public void setChecked(boolean value) {
            this.checked = value;
        }
    }
}

