/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.gfx;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.simantics.utils.ui.gfx.ImageCache;

public class AlphaAdjustmentImageDescriptor
extends ImageDescriptor {
    int alphaAdjustment;
    ImageDescriptor desc;

    public static ImageDescriptor adjustAlpha(ImageDescriptor desc, int alphaAdjustment) {
        if (alphaAdjustment == 256) {
            return desc;
        }
        return new AlphaAdjustmentImageDescriptor(desc, alphaAdjustment);
    }

    public AlphaAdjustmentImageDescriptor(ImageDescriptor original, int alphaAdjustment) {
        assert (alphaAdjustment >= 0 && alphaAdjustment <= 256);
        assert (original != null);
        this.alphaAdjustment = alphaAdjustment;
        this.desc = original;
    }

    public ImageData getImageData() {
        ImageData id;
        block5: {
            ImageData orig;
            block4: {
                orig = ImageCache.getInstance().getImage(this.desc).getImageData();
                id = new ImageData(orig.width, orig.height, orig.depth, orig.palette);
                id.setAlpha(0, 0, 0);
                if (orig.getTransparencyType() != 1 && orig.getTransparencyType() != 0) break block4;
                int x = 0;
                while (x < orig.width) {
                    int y = 0;
                    while (y < orig.height) {
                        id.setPixel(x, y, orig.getPixel(x, y));
                        int alpha = orig.getAlpha(x, y) * this.alphaAdjustment >> 8;
                        id.setAlpha(x, y, alpha);
                        ++y;
                    }
                    ++x;
                }
                break block5;
            }
            if (orig.getTransparencyType() != 2 && orig.getTransparencyType() != 4) break block5;
            ImageData mask = orig.getTransparencyMask();
            int x = 0;
            while (x < orig.width) {
                int y = 0;
                while (y < orig.height) {
                    id.setPixel(x, y, orig.getPixel(x, y));
                    int alpha = mask.getPixel(x, y) == 1 ? this.alphaAdjustment : 0;
                    id.setAlpha(x, y, alpha);
                    ++y;
                }
                ++x;
            }
        }
        return id;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AlphaAdjustmentImageDescriptor)) {
            return false;
        }
        AlphaAdjustmentImageDescriptor other = (AlphaAdjustmentImageDescriptor)((Object)obj);
        if (!other.desc.equals(this.desc)) {
            return false;
        }
        return other.alphaAdjustment == this.alphaAdjustment;
    }

    public int hashCode() {
        return this.desc.hashCode() ^ 0x58FB2 ^ this.alphaAdjustment;
    }
}

