/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.tests;

import java.util.UUID;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.serialization.Serializer;

public class TestPrimitiveSetters {

    public static class X {
        
        public boolean z; // 0
        public Boolean zz;// 1
        
        public byte b;    // 2
        public Byte bb;   // 3
        
        public int i;     // 4
        public Integer ii;// 5
        
        public long l;    // 6        
        public Long ll;   // 7
        
        public float f;   // 8
        public Float ff;  // 9
        
        public double d;  // 10
        public Double dd; // 11

        private boolean z_; // 12
        private Boolean zz_;// 13
        
        private byte b_;    // 14
        private Byte bb_;   // 15
        /*
        private int i_;     // 16
        private Integer ii_;// 17
        
        private long l_;    // 18       
        private Long ll_;   // 19
        
        private float f_;   // 20
        private Float ff_;  // 21
        
        private double d_;  // 22
        private Double dd_; // 23
        */
        public void setZ_(boolean z) {this.z_ = z;}
        public boolean getZ_() {return z_;}

        public void setZz_(Boolean z) {this.zz_ = z;}
        public Boolean getZz_() {return zz_;}
        
        public void setB_(byte z) {this.b_ = z;}
        public byte getB_() {return b_;}

        public void setBb_(Byte z) {this.bb_ = z;}
        public Byte getBb_() {return bb_;}        
        
    }
    
    public static void main(String[] args) throws Exception {
    	// DONE Add primitive support for Deserialization
    	// TODO Test UUID
    	// TODO Remove validator from AsmBindingClassLoader
    	// DONE Test Setters
    	
        RecordBinding b = Bindings.getBinding( X.class );
        
        X x = new X();
        b.setBoolean(x, 0, true);
        b.setBoolean(x, 1, true);
        
        b.setByte(x, 2, (byte)3);
        b.setByte(x, 3, (byte)3);
        
        b.setInt(x, 4, 3);
        b.setInt(x, 5, 3);

        b.setLong(x, 6, 3L);
        b.setLong(x, 7, 3L);
        
        b.setFloat(x, 8, 3.f);
        b.setFloat(x, 9, 3.f);
        
        b.setDouble(x, 10, 3.2);
        b.setDouble(x, 11, 3.4);

        b.setBoolean(x, 12, true);
        b.setBoolean(x, 13, true);
        
        b.setByte(x, 14, (byte)3);
        b.setByte(x, 15, (byte)3);
        
        System.out.println( b.getBoolean(x, 0) );
        System.out.println( b.getBoolean(x, 1) );
        
        System.out.println( b.getByte(x, 2) );
        System.out.println( b.getByte(x, 3) );
        
        System.out.println( b.getInt(x, 4) );
        System.out.println( b.getInt(x, 5) );
        
        System.out.println( b.getLong(x, 6) );
        System.out.println( b.getLong(x, 7) );
        
        System.out.println( b.getFloat(x, 8) );
        System.out.println( b.getFloat(x, 9) );
        
        System.out.println( b.getDouble(x, 10) );
        System.out.println( b.getDouble(x, 11) );
        
        System.out.println( b.getBoolean(x, 12) );
        System.out.println( b.getBoolean(x, 13) );
        
        System.out.println( b.getByte(x, 14) );
        System.out.println( b.getByte(x, 15) );
        
        System.out.println(b.toString(x));
        
        UUID guid = UUID.randomUUID();
        Binding binding = Bindings.getBinding(UUID.class);
        Serializer s = Bindings.getSerializer(binding);
        byte[] data = s.serialize( guid );
        
        guid = (UUID) s.deserialize( data );
        
    }
}
